/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.InvokeActionResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseCompleteMacro
extends Macro {
    private final String myName;
    private final boolean myCheckCompletionChar;

    protected BaseCompleteMacro(@NonNls String name) {
        this(name, true);
    }

    protected BaseCompleteMacro(@NonNls String name, boolean checkCompletionChar) {
        this.myName = name;
        this.myCheckCompletionChar = checkCompletionChar;
    }

    public String getName() {
        return this.myName;
    }

    public String getPresentableName() {
        return this.myName + "()";
    }

    @NotNull
    public String getDefaultValue() {
        return "a";
    }

    public final Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        return new InvokeActionResult(() -> this.invokeCompletion(context));
    }

    private void invokeCompletion(ExpressionContext context) {
        Project project = context.getProject();
        Editor editor = context.getEditor();
        PsiFile psiFile = editor != null ? PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project) : null;
        Runnable runnable2 = () -> {
            if (project.isDisposed() || editor == null || editor.isDisposed() || psiFile == null || !psiFile.isValid()) {
                return;
            }
            if (CompletionServiceImpl.getCompletionService().getCurrentCompletion() != null) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(project, () -> {
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                this.invokeCompletionHandler(project, editor);
                LookupEx lookup2 = LookupManager.getInstance(project).getActiveLookup();
                if (lookup2 != null) {
                    lookup2.addLookupListener(new MyLookupListener(context, this.myCheckCompletionChar));
                }
            }, "", null);
        };
        ApplicationManager.getApplication().invokeLater(runnable2);
    }

    protected abstract void invokeCompletionHandler(Project var1, Editor var2);

    public static void waitForNextTab() {
        UIUtil.dispatchAllInvocationEvents();
    }

    private static class MyLookupListener
    implements LookupListener {
        private final ExpressionContext myContext;
        private final boolean myCheckCompletionChar;

        MyLookupListener(@NotNull ExpressionContext context, boolean checkCompletionChar) {
            this.myContext = context;
            this.myCheckCompletionChar = checkCompletionChar;
        }

        public void itemSelected(@NotNull LookupEvent event) {
            LookupElement item = event.getItem();
            if (item == null) {
                return;
            }
            char c = event.getCompletionChar();
            if (this.myCheckCompletionChar && !LookupEvent.isSpecialCompletionChar((char)c)) {
                return;
            }
            Project project = this.myContext.getProject();
            if (project == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                TemplateState templateState;
                Editor editor = this.myContext.getEditor();
                if (editor != null && (templateState = TemplateManagerImpl.getTemplateState(editor)) != null) {
                    templateState.considerNextTabOnLookupItemSelected(item);
                }
            }), ModalityState.current(), project.getDisposed());
        }
    }
}

