/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class TemplateSubstitutionContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Editor myEditor;

    TemplateSubstitutionContext(@NotNull Project project, @NotNull Editor editor) {
        this.myProject = project;
        this.myEditor = editor;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public int getOffset() {
        return this.myEditor.getCaretModel().getOffset();
    }

    @NotNull
    public PsiFile getPsiFile() {
        Document document = this.myEditor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        return Objects.requireNonNull(psiFile, () -> "Can't find a psi file for the " + document + " in " + this.myEditor);
    }

    @NotNull
    public Document getDocument() {
        return this.myEditor.getDocument();
    }
}

