/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LiveTemplateRunLogger {
    private static final String GROUP = "live.templates";

    LiveTemplateRunLogger() {
    }

    static void log(@NotNull Project project, @NotNull TemplateImpl template, @NotNull Language language) {
        FeatureUsageData data2 = LiveTemplateRunLogger.createTemplateData(template, language);
        if (data2 != null) {
            FUCounterUsageLogger.getInstance().logEvent(project, GROUP, "started", data2);
        }
    }

    @Nullable
    static Triple<String, String, PluginInfo> getKeyGroupPluginToLog(@NotNull TemplateImpl template) {
        String groupName;
        String key = template.getKey();
        if (LiveTemplateRunLogger.isCreatedProgrammatically(key, groupName = template.getGroupName())) {
            return null;
        }
        PluginInfo plugin = TemplateSettings.getInstance().findPluginForPredefinedTemplate(template);
        if (plugin == null) {
            key = "user.defined.template";
            groupName = "user.defined.group";
        } else if (!plugin.isSafeToReport()) {
            key = "custom.plugin.template";
            groupName = "custom.plugin.group";
        }
        return new Triple((Object)key, (Object)groupName, (Object)plugin);
    }

    @Nullable
    static FeatureUsageData createTemplateData(@NotNull TemplateImpl template, @NotNull Language language) {
        Triple<String, String, PluginInfo> keyGroupPluginToLog = LiveTemplateRunLogger.getKeyGroupPluginToLog(template);
        if (keyGroupPluginToLog == null) {
            return null;
        }
        FeatureUsageData data2 = new FeatureUsageData().addLanguage(language).addData("group", (String)keyGroupPluginToLog.getSecond());
        PluginInfo plugin = (PluginInfo)keyGroupPluginToLog.getThird();
        if (plugin != null) {
            data2.addPluginInfo(plugin);
        }
        data2.addData("key", (String)keyGroupPluginToLog.getFirst());
        data2.addData("changedByUser", TemplateSettings.getInstance().differsFromDefault(template));
        return data2;
    }

    private static boolean isCreatedProgrammatically(String key, String groupName) {
        return StringUtil.isEmpty((String)key) || StringUtil.isEmpty((String)groupName);
    }

    public static class LiveTemplateValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "live_template".equals(ruleId) || "live_template_group".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            String key = this.getEventDataField(context, "key");
            String group = this.getEventDataField(context, "group");
            if (key == null || group == null || !LiveTemplateValidator.isKeyOrGroup(data2, key, group)) {
                return ValidationResultType.REJECTED;
            }
            return LiveTemplateValidator.validateKeyGroup(key, group);
        }

        @NotNull
        public static ValidationResultType validateKeyGroup(String key, Object group) {
            if (group == null) {
                return ValidationResultType.REJECTED;
            }
            if ("user.defined.template".equals(key) && "user.defined.group".equals(group)) {
                return ValidationResultType.ACCEPTED;
            }
            if ("custom.plugin.template".equals(key) && "custom.plugin.group".equals(group)) {
                return ValidationResultType.ACCEPTED;
            }
            try {
                PluginInfo info;
                TemplateImpl template = TemplateSettings.getInstance().getTemplate(key, group.toString());
                if (template != null && (info = TemplateSettings.getInstance().findPluginForPredefinedTemplate(template)) != null && info.isSafeToReport()) {
                    return ValidationResultType.ACCEPTED;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ValidationResultType.REJECTED;
        }

        private static boolean isKeyOrGroup(@NotNull String data2, @NotNull String key, @NotNull String group) {
            return StringUtil.equals((CharSequence)data2, (CharSequence)key) || StringUtil.equals((CharSequence)data2, (CharSequence)group);
        }
    }
}

