/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class LiveTemplateLookupElementImpl
extends LiveTemplateLookupElement {
    private final TemplateImpl myTemplate;

    public LiveTemplateLookupElementImpl(@NotNull TemplateImpl template, boolean sudden) {
        super(template.getKey(), StringUtil.notNullize((String)template.getDescription()), sudden, LiveTemplateCompletionContributor.shouldShowAllTemplates());
        this.myTemplate = template;
    }

    @Override
    @NotNull
    public String getLookupString() {
        return this.myTemplate.getKey();
    }

    @NotNull
    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    @Override
    public char getTemplateShortcut() {
        return TemplateSettings.getInstance().getShortcutChar(this.myTemplate);
    }

    public void handleInsert(@NotNull InsertionContext context) {
        LiveTemplateLookupElementImpl.startTemplate(context, this.myTemplate);
    }

    public static void startTemplate(InsertionContext context, @NotNull Template template) {
        context.getDocument().deleteString(context.getStartOffset(), context.getTailOffset());
        context.setAddCompletionChar(false);
        TemplateManager.getInstance(context.getProject()).startTemplate(context.getEditor(), template);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LiveTemplateLookupElementImpl element2 = (LiveTemplateLookupElementImpl)((Object)o);
        return Objects.equals(this.myTemplate, element2.myTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.myTemplate);
    }
}

