/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.openapi.util.TextRange;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocPreviewUtil {
    private static final TIntHashSet ALLOWED_LINK_SEPARATORS = new TIntHashSet();
    private static final Comparator<String> REPLACEMENTS_COMPARATOR;

    private DocPreviewUtil() {
    }

    @NotNull
    public static String buildPreview(@NotNull String header2, @Nullable String qName, @Nullable String fullText) {
        if (fullText == null) {
            return header2;
        }
        HashMap<String, String> links = new HashMap<String, String>();
        DocPreviewUtil.process(fullText, new LinksCollector(links));
        HashMap toAdd = new HashMap();
        for (Map.Entry entry : links.entrySet()) {
            String longName;
            String shortName = DocPreviewUtil.parseShortName((String)entry.getKey());
            if (shortName != null) {
                toAdd.put(shortName, entry.getValue());
            }
            if ((longName = DocPreviewUtil.parseLongName((String)entry.getKey(), (String)entry.getValue())) == null) continue;
            toAdd.put(longName, entry.getValue());
        }
        links.putAll(toAdd);
        if (qName != null) {
            links.put(qName, "psi_element://" + qName);
        }
        ArrayList<TextRange> modifiedRanges = new ArrayList<TextRange>();
        ArrayList sortedReplacements = new ArrayList(links.keySet());
        sortedReplacements.sort(REPLACEMENTS_COMPARATOR);
        StringBuilder buffer = new StringBuilder(header2);
        DocPreviewUtil.replace(buffer, "\n", "<br/>", modifiedRanges);
        for (String replaceFrom : sortedReplacements) {
            DocPreviewUtil.replace(buffer, replaceFrom, String.format("<a href=\"%s\">%s</a>", links.get(replaceFrom), replaceFrom), modifiedRanges);
        }
        return buffer.toString();
    }

    @Nullable
    private static String parseShortName(@NotNull String name) {
        int i2 = name.lastIndexOf(46);
        return i2 > 0 && i2 < name.length() - 1 ? name.substring(i2 + 1) : null;
    }

    @Nullable
    private static String parseLongName(@NotNull String shortName, @NotNull String address) {
        String pureAddress = address;
        int i2 = pureAddress.lastIndexOf("//");
        if (i2 > 0 && i2 < pureAddress.length() - 2) {
            pureAddress = pureAddress.substring(i2 + 2);
        }
        return pureAddress.equals(shortName) || !pureAddress.endsWith(shortName) ? null : pureAddress;
    }

    private static void replace(@NotNull StringBuilder text, @NotNull String replaceFrom, @NotNull String replaceTo, @NotNull List<TextRange> readOnlyChanges) {
        if (replaceFrom.isEmpty()) {
            return;
        }
        int i2 = text.indexOf(replaceFrom);
        while (i2 >= 0) {
            int end = i2 + replaceFrom.length();
            if (!DocPreviewUtil.intersects(readOnlyChanges, i2, end) && ("\n".equals(replaceFrom) || (end >= text.length() || ALLOWED_LINK_SEPARATORS.contains((int)text.charAt(end))) && (i2 <= 0 || ALLOWED_LINK_SEPARATORS.contains((int)text.charAt(i2 - 1))))) {
                text.replace(i2, end, replaceTo);
                int diff = replaceTo.length() - replaceFrom.length();
                for (int j = 0; j < readOnlyChanges.size(); ++j) {
                    TextRange range2 = readOnlyChanges.get(j);
                    if (range2.getStartOffset() < end) continue;
                    readOnlyChanges.set(j, range2.shiftRight(diff));
                }
                readOnlyChanges.add(new TextRange(i2, i2 + replaceTo.length()));
            }
            i2 = text.indexOf(replaceFrom, i2 + 1);
        }
    }

    private static boolean intersects(@NotNull List<? extends TextRange> ranges, int start2, int end) {
        for (TextRange textRange : ranges) {
            if (!textRange.intersectsStrict(start2, end)) continue;
            return true;
        }
        return false;
    }

    private static int process(@NotNull String text, @NotNull Callback callback2) {
        int i2;
        State state = State.TEXT;
        int dataStartOffset = 0;
        int tagNameStartOffset = 0;
        String tagName = null;
        block5: for (i2 = 0; i2 < text.length(); ++i2) {
            char c = text.charAt(i2);
            switch (state) {
                case TEXT: {
                    if (c != '<') continue block5;
                    if (i2 > dataStartOffset && !callback2.onText(text.substring(dataStartOffset, i2).replace("&nbsp;", " "))) {
                        return dataStartOffset;
                    }
                    dataStartOffset = i2;
                    if (i2 < text.length() - 1 && text.charAt(i2 + 1) == '/') {
                        state = State.INSIDE_CLOSE_TAG;
                        tagNameStartOffset = ++i2 + 1;
                        continue block5;
                    }
                    state = State.INSIDE_OPEN_TAG;
                    tagNameStartOffset = i2 + 1;
                    continue block5;
                }
                case INSIDE_OPEN_TAG: {
                    if (c == ' ') {
                        tagName = text.substring(tagNameStartOffset, i2);
                        continue block5;
                    }
                    if (c == '/') {
                        if (i2 >= text.length() - 1 || text.charAt(i2 + 1) != '>') continue block5;
                        if (tagName == null) {
                            tagName = text.substring(tagNameStartOffset, i2);
                        }
                        if (!callback2.onStandaloneTag(tagName, text.substring(dataStartOffset, i2 + 2))) {
                            return dataStartOffset;
                        }
                        tagName = null;
                        state = State.TEXT;
                        dataStartOffset = ++i2 + 1;
                        continue block5;
                    }
                    if (c != '>') continue block5;
                    if (tagName == null) {
                        tagName = text.substring(tagNameStartOffset, i2);
                    }
                    if (!callback2.onOpenTag(tagName, text.substring(dataStartOffset, i2 + 1))) {
                        return dataStartOffset;
                    }
                    tagName = null;
                    state = State.TEXT;
                    dataStartOffset = i2 + 1;
                    continue block5;
                }
                case INSIDE_CLOSE_TAG: {
                    if (c != '>') continue block5;
                    if (tagName == null) {
                        tagName = text.substring(tagNameStartOffset, i2);
                    }
                    if (!callback2.onCloseTag(tagName, text.substring(dataStartOffset, i2 + 1))) {
                        return dataStartOffset;
                    }
                    tagName = null;
                    state = State.TEXT;
                    dataStartOffset = i2 + 1;
                }
            }
        }
        if (dataStartOffset < text.length()) {
            callback2.onText(text.substring(dataStartOffset).replace("&nbsp;", " "));
        }
        return i2;
    }

    static {
        ALLOWED_LINK_SEPARATORS.add(44);
        ALLOWED_LINK_SEPARATORS.add(32);
        ALLOWED_LINK_SEPARATORS.add(46);
        ALLOWED_LINK_SEPARATORS.add(59);
        ALLOWED_LINK_SEPARATORS.add(38);
        ALLOWED_LINK_SEPARATORS.add(9);
        ALLOWED_LINK_SEPARATORS.add(10);
        ALLOWED_LINK_SEPARATORS.add(91);
        ALLOWED_LINK_SEPARATORS.add(93);
        ALLOWED_LINK_SEPARATORS.add(40);
        ALLOWED_LINK_SEPARATORS.add(41);
        ALLOWED_LINK_SEPARATORS.add(60);
        ALLOWED_LINK_SEPARATORS.add(62);
        REPLACEMENTS_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(@NotNull String o1, @NotNull String o2) {
                String shortName2;
                String shortName1 = this.extractShortName(o1);
                if (!shortName1.equals(shortName2 = this.extractShortName(o2))) {
                    return shortName1.compareTo(shortName2);
                }
                if (o1.endsWith(o2)) {
                    return -1;
                }
                if (o2.endsWith(o1)) {
                    return 1;
                }
                return o1.compareTo(o2);
            }

            private String extractShortName(@NotNull String s) {
                int i2 = s.lastIndexOf(46);
                return i2 > 0 && i2 < s.length() - 1 ? s.substring(i2 + 1) : s;
            }
        };
    }

    private static class LinksCollector
    implements Callback {
        private static final Pattern HREF_PATTERN = Pattern.compile("href=[\"']([^\"']+)");
        @NotNull
        private final Map<String, String> myLinks;
        private String myHref;

        LinksCollector(@NotNull Map<String, String> links) {
            this.myLinks = links;
        }

        @Override
        public boolean onOpenTag(@NotNull String name, @NotNull String text) {
            if (!"a".equals(name)) {
                return true;
            }
            Matcher matcher = HREF_PATTERN.matcher(text);
            if (matcher.find()) {
                this.myHref = matcher.group(1);
            }
            return true;
        }

        @Override
        public boolean onCloseTag(@NotNull String name, @NotNull String text) {
            if ("a".equals(name)) {
                this.myHref = null;
            }
            return true;
        }

        @Override
        public boolean onStandaloneTag(@NotNull String name, @NotNull String text) {
            return true;
        }

        @Override
        public boolean onText(@NotNull String text) {
            if (this.myHref != null) {
                this.myLinks.put(text, this.myHref);
                this.myHref = null;
            }
            return true;
        }
    }

    private static interface Callback {
        public boolean onOpenTag(@NotNull String var1, @NotNull String var2);

        public boolean onCloseTag(@NotNull String var1, @NotNull String var2);

        public boolean onStandaloneTag(@NotNull String var1, @NotNull String var2);

        public boolean onText(@NotNull String var1);
    }

    private static enum State {
        TEXT,
        INSIDE_OPEN_TAG,
        INSIDE_CLOSE_TAG;

    }
}

