/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GenericListComponentUpdater;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Ref;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BackgroundUpdaterTaskBase<T>
extends Task.Backgroundable {
    protected JBPopup myPopup;
    private GenericListComponentUpdater<T> myUpdater;
    private Ref<? extends UsageView> myUsageView;
    private final Collection<T> myData;
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final Object lock = new Object();
    private volatile boolean myCanceled;
    private volatile boolean myFinished;
    private volatile ProgressIndicator myIndicator;

    public BackgroundUpdaterTaskBase(@Nullable Project project, @NotNull String title, @Nullable Comparator<T> comparator2) {
        super(project, title);
        this.myData = comparator2 == null ? new SmartList() : new TreeSet<T>(comparator2);
    }

    public GenericListComponentUpdater<T> getUpdater() {
        return this.myUpdater;
    }

    public void init(@NotNull JBPopup popup2, @NotNull GenericListComponentUpdater<T> updater2, @NotNull Ref<? extends UsageView> usageView) {
        this.myPopup = popup2;
        this.myUpdater = updater2;
        this.myUsageView = usageView;
    }

    public abstract String getCaption(int var1);

    @Nullable
    protected abstract Usage createUsage(T var1);

    protected void replaceModel(@NotNull List<? extends T> data2) {
        this.myUpdater.replaceModel(data2);
    }

    protected void paintBusy(boolean paintBusy) {
        this.myUpdater.paintBusy(paintBusy);
    }

    private boolean setCanceled() {
        boolean canceled = this.myCanceled;
        this.myCanceled = true;
        return canceled;
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean updateComponent(@NotNull T element2, @Nullable Comparator comparator2) {
        if (this.tryAppendUsage(element2)) {
            return true;
        }
        if (this.myCanceled) {
            return false;
        }
        if (this.myPopup.isDisposed()) {
            return false;
        }
        ModalityState modalityState = ModalityState.stateForComponent((Component)this.myPopup.getContent());
        Object object = this.lock;
        synchronized (object) {
            if (this.myData.contains(element2)) {
                return true;
            }
            this.myData.add(element2);
            if (comparator2 != null && this.myData instanceof List) {
                ((List)this.myData).sort(comparator2);
            }
        }
        this.myAlarm.addRequest(() -> {
            this.myAlarm.cancelAllRequests();
            this.refreshModelImmediately();
        }, 200, modalityState);
        return true;
    }

    private boolean tryAppendUsage(@NotNull T element2) {
        UsageView view = (UsageView)this.myUsageView.get();
        if (view != null && !((UsageViewImpl)view).isDisposed()) {
            Usage usage = this.createUsage(element2);
            if (usage == null) {
                return false;
            }
            ApplicationManager.getApplication().runReadAction(() -> view.appendUsage(usage));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateComponent(@NotNull T element2) {
        if (this.tryAppendUsage(element2)) {
            return true;
        }
        if (this.myCanceled) {
            return false;
        }
        if (this.myPopup.isDisposed()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.myData.add(element2)) {
                return true;
            }
        }
        this.myAlarm.addRequest(() -> {
            this.myAlarm.cancelAllRequests();
            this.refreshModelImmediately();
        }, 200, ModalityState.stateForComponent((Component)this.myPopup.getContent()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshModelImmediately() {
        ArrayList<T> data2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myCanceled) {
            return;
        }
        if (this.myPopup.isDisposed()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            data2 = new ArrayList<T>(this.myData);
        }
        this.replaceModel(data2);
        this.myPopup.setCaption(this.getCaption(this.getCurrentSize()));
        this.myPopup.pack(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.myData.size();
        }
    }

    public void run(@NotNull ProgressIndicator indicator) {
        this.paintBusy(true);
        this.myIndicator = indicator;
    }

    public void onSuccess() {
        this.myFinished = true;
        this.refreshModelImmediately();
        this.paintBusy(false);
    }

    public void onFinished() {
        this.myAlarm.cancelAllRequests();
        this.myFinished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected T getTheOnlyOneElement() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myData.size() == 1) {
                return this.myData.iterator().next();
            }
        }
        return null;
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    public boolean cancelTask() {
        ProgressIndicator indicator = this.myIndicator;
        if (indicator != null) {
            indicator.cancel();
        }
        return this.setCanceled();
    }
}

