/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import org.jetbrains.annotations.NotNull;

public class BackspaceHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public BackspaceHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
        LookupImpl lookup2 = (LookupImpl)LookupManager.getActiveLookup(editor);
        if (lookup2 == null) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        int hideOffset = lookup2.getLookupStart();
        int originalStart = lookup2.getLookupOriginalStart();
        if (originalStart >= 0 && originalStart <= hideOffset) {
            hideOffset = originalStart - 1;
        }
        BackspaceHandler.truncatePrefix(dataContext, lookup2, this.myOriginalHandler, hideOffset, caret);
    }

    static void truncatePrefix(DataContext dataContext, LookupImpl lookup2, EditorActionHandler handler2, int hideOffset, Caret caret) {
        Editor editor = lookup2.getEditor();
        if (!lookup2.performGuardedChange(() -> handler2.execute(editor, caret, dataContext))) {
            return;
        }
        CompletionProgressIndicator process2 = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        lookup2.truncatePrefix(process2 == null || !process2.isAutopopupCompletion(), hideOffset);
    }
}

