/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class ResourceTextDescriptor
implements TextDescriptor {
    private final ClassLoader myLoader;
    private final String myResourcePath;

    ResourceTextDescriptor(ClassLoader loader, @NotNull String resourcePath) {
        this.myLoader = loader;
        this.myResourcePath = resourcePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceTextDescriptor resource = (ResourceTextDescriptor)o;
        return Objects.equals(this.myLoader, resource.myLoader) && Objects.equals(this.myResourcePath, resource.myResourcePath);
    }

    public int hashCode() {
        return Objects.hash(this.myLoader, this.myResourcePath);
    }

    @Override
    @NotNull
    public String getText() throws IOException {
        InputStream stream = this.myLoader.getResourceAsStream(this.myResourcePath);
        if (stream == null) {
            throw new IOException("Resource not found: " + this.myResourcePath);
        }
        return ResourceUtil.loadText((InputStream)stream);
    }

    @Override
    @NotNull
    public String getFileName() {
        return StringUtil.trimEnd((String)this.myResourcePath.substring(this.myResourcePath.lastIndexOf(47) + 1), (String)".template");
    }
}

