/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

final class IntentionsOptionsTopHitProvider
implements OptionsSearchTopHitProvider.ApplicationLevelProvider {
    IntentionsOptionsTopHitProvider() {
    }

    @Override
    @NotNull
    public String getId() {
        return "intentions";
    }

    @Override
    public boolean preloadNeeded() {
        Application application = ApplicationManager.getApplication();
        return !(application instanceof ApplicationImpl) || ((ApplicationImpl)application).isLightEditMode();
    }

    @Override
    @NotNull
    public Collection<OptionDescription> getOptions() {
        IntentionManagerSettings settings = IntentionManagerSettings.getInstance();
        ArrayList<Option> options2 = new ArrayList<Option>();
        for (IntentionActionMetaData data2 : settings.getMetaData()) {
            options2.add(new Option(settings, data2));
        }
        return Collections.unmodifiableCollection(options2);
    }

    private static final class Option
    extends BooleanOptionDescription {
        private final IntentionManagerSettings mySettings;
        private final IntentionActionMetaData myMetaData;

        private Option(@NotNull IntentionManagerSettings settings, IntentionActionMetaData data2) {
            super(Option.getOptionName(data2), "preferences.intentionPowerPack");
            this.mySettings = settings;
            this.myMetaData = data2;
        }

        public boolean isOptionEnabled() {
            return this.mySettings.isEnabled(this.myMetaData);
        }

        public void setOptionState(boolean enabled) {
            this.mySettings.setEnabled(this.myMetaData, enabled);
        }

        private static String getOptionName(@NotNull IntentionActionMetaData data2) {
            StringBuilder sb = new StringBuilder();
            for (String category : data2.myCategory) {
                sb.append(category).append(": ");
            }
            return sb.append(data2.getFamily()).toString();
        }
    }
}

