/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerImpl;
import com.intellij.codeInsight.intention.impl.config.IntentionSettingsConfigurable;
import com.intellij.codeInsight.intention.impl.config.IntentionsOptionsTopHitProvider;
import com.intellij.ide.ui.TopHitCache;
import com.intellij.ide.ui.search.SearchableOptionContributor;
import com.intellij.ide.ui.search.SearchableOptionProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.WeakInterner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="IntentionManagerSettings", storages={@Storage(value="intentionSettings.xml")})
public final class IntentionManagerSettings
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(IntentionManagerSettings.class);
    private final Set<String> myIgnoredActions = Collections.synchronizedSet(new LinkedHashSet());
    private final Map<MetaDataKey, IntentionActionMetaData> myMetaData;
    private final Map<IntentionActionBean, MetaDataKey> myExtensionMapping;
    @NonNls
    private static final String IGNORE_ACTION_TAG = "ignoreAction";
    @NonNls
    private static final String NAME_ATT = "name";
    private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");

    public IntentionManagerSettings() {
        int size = IntentionManagerImpl.EP_INTENTION_ACTIONS.getPoint().size();
        this.myMetaData = new LinkedHashMap<MetaDataKey, IntentionActionMetaData>(size);
        this.myExtensionMapping = new HashMap<IntentionActionBean, MetaDataKey>(size);
        IntentionManagerImpl.EP_INTENTION_ACTIONS.forEachExtensionSafe(extension -> this.registerMetaDataForEp((IntentionActionBean)extension));
        IntentionManagerImpl.EP_INTENTION_ACTIONS.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<IntentionActionBean>(){

            public void extensionAdded(@NotNull IntentionActionBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                IntentionManagerSettings.this.registerMetaDataForEp(extension);
                TopHitCache topHitCache = (TopHitCache)ApplicationManager.getApplication().getServiceIfCreated(TopHitCache.class);
                if (topHitCache != null) {
                    topHitCache.invalidateCachedOptions(IntentionsOptionsTopHitProvider.class);
                }
            }

            public void extensionRemoved(@NotNull IntentionActionBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                String[] categories = extension.getCategories();
                if (categories == null) {
                    return;
                }
                IntentionManagerSettings.this.unregisterMetaDataForEP(extension);
                TopHitCache topHitCache = (TopHitCache)ApplicationManager.getApplication().getServiceIfCreated(TopHitCache.class);
                if (topHitCache != null) {
                    topHitCache.invalidateCachedOptions(IntentionsOptionsTopHitProvider.class);
                }
            }
        }, false, (Disposable)ApplicationManager.getApplication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMetaDataForEp(@NotNull IntentionActionBean extension) {
        String[] categories = extension.getCategories();
        if (categories == null) {
            return;
        }
        IntentionActionWrapper instance = new IntentionActionWrapper(extension);
        String descriptionDirectoryName = extension.getDescriptionDirectoryName();
        if (descriptionDirectoryName == null) {
            descriptionDirectoryName = instance.getDescriptionDirectoryName();
        }
        try {
            IntentionActionMetaData metaData = new IntentionActionMetaData(instance, extension.getLoaderForClass(), categories, descriptionDirectoryName);
            MetaDataKey key = new MetaDataKey(metaData.myCategory, metaData.getFamily());
            IntentionManagerSettings intentionManagerSettings = this;
            synchronized (intentionManagerSettings) {
                this.myMetaData.put(key, metaData);
                this.myExtensionMapping.put(extension, key);
            }
        }
        catch (ExtensionNotApplicableException extensionNotApplicableException) {
            // empty catch block
        }
    }

    @NotNull
    public static IntentionManagerSettings getInstance() {
        return (IntentionManagerSettings)ServiceManager.getService(IntentionManagerSettings.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerIntentionMetaData(@NotNull IntentionAction intentionAction, String @NotNull [] category, @NotNull String descriptionDirectoryName) {
        IntentionActionMetaData metaData = new IntentionActionMetaData(intentionAction, IntentionManagerSettings.getClassLoader(intentionAction), category, descriptionDirectoryName);
        MetaDataKey key = new MetaDataKey(metaData.myCategory, metaData.getFamily());
        IntentionManagerSettings intentionManagerSettings = this;
        synchronized (intentionManagerSettings) {
            this.myMetaData.put(key, metaData);
        }
    }

    private static ClassLoader getClassLoader(@NotNull IntentionAction intentionAction) {
        return intentionAction instanceof IntentionActionWrapper ? ((IntentionActionWrapper)intentionAction).getImplementationClassLoader() : intentionAction.getClass().getClassLoader();
    }

    public boolean isShowLightBulb(@NotNull IntentionAction action2) {
        return !this.myIgnoredActions.contains(action2.getFamilyName());
    }

    public void loadState(@NotNull Element element2) {
        this.myIgnoredActions.clear();
        for (Element e : element2.getChildren(IGNORE_ACTION_TAG)) {
            this.myIgnoredActions.add(e.getAttributeValue(NAME_ATT));
        }
    }

    public Element getState() {
        Element element2 = new Element("state");
        for (String name : this.myIgnoredActions) {
            element2.addContent(new Element(IGNORE_ACTION_TAG).setAttribute(NAME_ATT, name));
        }
        return element2;
    }

    @NotNull
    public synchronized List<IntentionActionMetaData> getMetaData() {
        return new ArrayList<IntentionActionMetaData>(this.myMetaData.values());
    }

    public boolean isEnabled(@NotNull IntentionActionMetaData metaData) {
        return !this.myIgnoredActions.contains(IntentionManagerSettings.getFamilyName(metaData));
    }

    private static String getFamilyName(@NotNull IntentionActionMetaData metaData) {
        return StringUtil.join((String[])metaData.myCategory, (String)"/") + "/" + metaData.getAction().getFamilyName();
    }

    private static String getFamilyName(@NotNull IntentionAction action2) {
        return action2 instanceof IntentionActionWrapper ? ((IntentionActionWrapper)action2).getFullFamilyName() : action2.getFamilyName();
    }

    public void setEnabled(@NotNull IntentionActionMetaData metaData, boolean enabled) {
        if (enabled) {
            this.myIgnoredActions.remove(IntentionManagerSettings.getFamilyName(metaData));
        } else {
            this.myIgnoredActions.add(IntentionManagerSettings.getFamilyName(metaData));
        }
    }

    public boolean isEnabled(@NotNull IntentionAction action2) {
        return !this.myIgnoredActions.contains(IntentionManagerSettings.getFamilyName(action2));
    }

    public void setEnabled(@NotNull IntentionAction action2, boolean enabled) {
        if (enabled) {
            this.myIgnoredActions.remove(IntentionManagerSettings.getFamilyName(action2));
        } else {
            this.myIgnoredActions.add(IntentionManagerSettings.getFamilyName(action2));
        }
    }

    private static void processMetaData(@NotNull IntentionActionMetaData metaData, @NotNull SearchableOptionProcessor processor2) {
        try {
            String descriptionText = StringUtil.toLowerCase((String)metaData.getDescription().getText());
            descriptionText = HTML_PATTERN.matcher(descriptionText).replaceAll(" ");
            String displayName = IntentionSettingsConfigurable.getDisplayNameText();
            String configurableId = "preferences.intentionPowerPack";
            String family = metaData.getFamily();
            processor2.addOptions(descriptionText, family, family, configurableId, displayName, false);
            processor2.addOptions(family, family, family, configurableId, displayName, true);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    synchronized void unregisterMetaData(@NotNull IntentionAction intentionAction) {
        for (Map.Entry<MetaDataKey, IntentionActionMetaData> entry : this.myMetaData.entrySet()) {
            if (entry.getValue().getAction() != intentionAction) continue;
            this.myMetaData.remove((Object)entry.getKey());
            break;
        }
    }

    private synchronized void unregisterMetaDataForEP(IntentionActionBean extension) {
        MetaDataKey key = this.myExtensionMapping.remove(extension);
        if (key != null) {
            this.myMetaData.remove((Object)key);
        }
    }

    private static final class IntentionSearchableOptionContributor
    extends SearchableOptionContributor {
        private IntentionSearchableOptionContributor() {
        }

        public void processOptions(@NotNull SearchableOptionProcessor processor2) {
            for (IntentionActionMetaData metaData : IntentionManagerSettings.getInstance().getMetaData()) {
                IntentionManagerSettings.processMetaData(metaData, processor2);
            }
        }
    }

    private static final class MetaDataKey
    extends Pair<String, String> {
        private static final Interner<String> ourInterner = WeakInterner.createWeakInterner();

        private MetaDataKey(String @NotNull [] categoryNames, @NotNull String familyName) {
            super((Object)StringUtil.join((String[])categoryNames, (String)":"), ourInterner.intern((Object)familyName));
        }
    }
}

