/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntentionActionWrapper
implements IntentionAction,
ShortcutProvider,
IntentionActionDelegate,
PossiblyDumbAware,
Comparable<IntentionAction> {
    private final IntentionActionBean myExtension;
    private String myFullFamilyName;
    private String myFamilyName;

    public IntentionActionWrapper(@NotNull IntentionActionBean extension) {
        this.myExtension = extension;
    }

    @NotNull
    public String getDescriptionDirectoryName() {
        return IntentionActionWrapper.getDescriptionDirectoryName(this.getImplementationClassName());
    }

    @NotNull
    static String getDescriptionDirectoryName(@NotNull String fqn) {
        return fqn.substring(fqn.lastIndexOf(46) + 1).replaceAll("\\$", "");
    }

    @NotNull
    public String getText() {
        return this.getDelegate().getText();
    }

    @NotNull
    public String getFamilyName() {
        String result2 = this.myFamilyName;
        if (result2 == null) {
            this.myFamilyName = result2 = this.getDelegate().getFamilyName();
        }
        return result2;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        return this.getDelegate().isAvailable(project, editor, file2);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        this.getDelegate().invoke(project, editor, file2);
    }

    public boolean startInWriteAction() {
        return this.getDelegate().startInWriteAction();
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target2) {
        return this.getDelegate().getFileModifierForPreview(target2);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        return this.getDelegate().getElementToMakeWritable(file2);
    }

    @NotNull
    public String getFullFamilyName() {
        String result2 = this.myFullFamilyName;
        if (result2 == null) {
            String[] myCategories = this.myExtension.getCategories();
            result2 = myCategories != null ? StringUtil.join((String[])myCategories, (String)"/") + "/" + this.getFamilyName() : this.getFamilyName();
            this.myFullFamilyName = result2;
        }
        return result2;
    }

    public boolean isDumbAware() {
        return DumbService.isDumbAware((Object)this.getDelegate());
    }

    @NotNull
    public IntentionAction getDelegate() {
        return (IntentionAction)this.myExtension.getInstance();
    }

    @NotNull
    public String getImplementationClassName() {
        return this.myExtension.className;
    }

    @NotNull
    ClassLoader getImplementationClassLoader() {
        return this.myExtension.getLoaderForClass();
    }

    public String toString() {
        String text;
        try {
            text = this.getText();
        }
        catch (PsiInvalidElementAccessException e) {
            text = e.getMessage();
        }
        return "Intention: (" + this.getDelegate().getClass() + "): '" + text + "'";
    }

    public boolean equals(Object obj) {
        return super.equals(obj) || this.getDelegate().equals(obj);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        IntentionAction delegate = this.getDelegate();
        return delegate instanceof ShortcutProvider ? ((ShortcutProvider)delegate).getShortcut() : null;
    }

    @Override
    public int compareTo(@NotNull IntentionAction other) {
        if (other instanceof IntentionActionWrapper) {
            IntentionAction action1 = this.getDelegate();
            IntentionAction action2 = ((IntentionActionWrapper)other).getDelegate();
            if (action1 instanceof Comparable && action2 instanceof Comparable) {
                return ((Comparable)action1).compareTo(action2);
            }
        }
        return 0;
    }
}

