/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionActionWithTextCaching
implements Comparable<IntentionActionWithTextCaching>,
PossiblyDumbAware,
ShortcutProvider,
IntentionActionDelegate {
    private static final Logger LOG = Logger.getInstance(IntentionActionWithTextCaching.class);
    private final List<IntentionAction> myOptionIntentions = new ArrayList<IntentionAction>();
    private final List<IntentionAction> myOptionErrorFixes = new ArrayList<IntentionAction>();
    private final List<IntentionAction> myOptionInspectionFixes = new ArrayList<IntentionAction>();
    private final String myText;
    private final IntentionAction myAction;
    private final String myDisplayName;
    private final Icon myIcon;

    IntentionActionWithTextCaching(@NotNull IntentionAction action2) {
        this(action2, action2.getText(), null, (__1, __2) -> {});
    }

    IntentionActionWithTextCaching(@NotNull HighlightInfo.IntentionActionDescriptor descriptor2, @NotNull BiConsumer<? super IntentionActionWithTextCaching, ? super IntentionAction> markInvoked) {
        this(descriptor2.getAction(), descriptor2.getDisplayName(), descriptor2.getIcon(), markInvoked);
    }

    private IntentionActionWithTextCaching(@NotNull IntentionAction action2, String displayName, @Nullable Icon icon2, @NotNull BiConsumer<? super IntentionActionWithTextCaching, ? super IntentionAction> markInvoked) {
        this.myIcon = icon2;
        this.myText = action2.getText();
        LOG.assertTrue(this.myText != null, (Object)("action " + action2.getClass() + " text returned null"));
        this.myAction = new MyIntentionAction(action2, markInvoked);
        this.myDisplayName = displayName;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    void addIntention(@NotNull IntentionAction action2) {
        this.myOptionIntentions.add(action2);
    }

    void addErrorFix(@NotNull IntentionAction action2) {
        this.myOptionErrorFixes.add(action2);
    }

    void addInspectionFix(@NotNull IntentionAction action2) {
        this.myOptionInspectionFixes.add(action2);
    }

    @NotNull
    public IntentionAction getAction() {
        return this.myAction;
    }

    @NotNull
    List<IntentionAction> getOptionIntentions() {
        return this.myOptionIntentions;
    }

    @NotNull
    List<IntentionAction> getOptionErrorFixes() {
        return this.myOptionErrorFixes;
    }

    @NotNull
    List<IntentionAction> getOptionInspectionFixes() {
        return this.myOptionInspectionFixes;
    }

    @NotNull
    public List<IntentionAction> getOptionActions() {
        return ContainerUtil.concat((List[])new List[]{this.myOptionIntentions, this.myOptionErrorFixes, this.myOptionInspectionFixes});
    }

    String getToolName() {
        return this.myDisplayName;
    }

    @NotNull
    public String toString() {
        return this.getText();
    }

    @Override
    public int compareTo(@NotNull IntentionActionWithTextCaching other) {
        if (this.myAction instanceof Comparable) {
            return ((Comparable)this.myAction).compareTo(other.getAction());
        }
        if (other.getAction() instanceof Comparable) {
            return -((Comparable)other.getAction()).compareTo(this.myAction);
        }
        return Comparing.compare((Comparable)((Object)this.getText()), (Comparable)((Object)other.getText()));
    }

    Icon getIcon() {
        return this.myIcon;
    }

    public boolean isDumbAware() {
        return DumbService.isDumbAware((Object)this.myAction);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        return this.myAction instanceof ShortcutProvider ? ((ShortcutProvider)this.myAction).getShortcut() : null;
    }

    @NotNull
    public IntentionAction getDelegate() {
        return this.getAction();
    }

    private class MyIntentionAction
    implements IntentionAction,
    IntentionActionDelegate,
    Comparable<MyIntentionAction>,
    ShortcutProvider,
    PossiblyDumbAware {
        private final IntentionAction myAction;
        @NotNull
        private final BiConsumer<? super IntentionActionWithTextCaching, ? super IntentionAction> myMarkInvoked;

        MyIntentionAction(@NotNull IntentionAction action2, BiConsumer<? super IntentionActionWithTextCaching, ? super IntentionAction> markInvoked) {
            this.myAction = action2;
            this.myMarkInvoked = markInvoked;
        }

        public boolean isDumbAware() {
            return DumbService.isDumbAware((Object)this.myAction);
        }

        @Nls
        @NotNull
        public String getText() {
            return this.myAction.getText();
        }

        public String toString() {
            return this.getDelegate().getClass() + ": " + this.getDelegate();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return this.myAction.getFamilyName();
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
            return this.myAction.isAvailable(project, editor, file2);
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
            this.myAction.invoke(project, editor, file2);
            this.myMarkInvoked.accept(IntentionActionWithTextCaching.this, (IntentionAction)this.myAction);
        }

        public boolean startInWriteAction() {
            return this.myAction.startInWriteAction();
        }

        @NotNull
        public IntentionAction getDelegate() {
            return this.myAction;
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target2) {
            return this.myAction.getFileModifierForPreview(target2);
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            return this.myAction.getElementToMakeWritable(currentFile);
        }

        @Nullable
        public ShortcutSet getShortcut() {
            return this.myAction instanceof ShortcutProvider ? ((ShortcutProvider)this.myAction).getShortcut() : null;
        }

        @Override
        public int compareTo(@NotNull MyIntentionAction other) {
            if (this.myAction instanceof Comparable) {
                return ((Comparable)this.myAction).compareTo(other.getDelegate());
            }
            if (other.getDelegate() instanceof Comparable) {
                return -((Comparable)other.getDelegate()).compareTo(this.myAction);
            }
            return Comparing.compare((Comparable)((Object)this.getText()), (Comparable)((Object)other.getText()));
        }
    }
}

