/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionGroup;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedIntentions {
    private static final Logger LOG = Logger.getInstance(CachedIntentions.class);
    private final Set<IntentionActionWithTextCaching> myIntentions = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
    private final Set<IntentionActionWithTextCaching> myErrorFixes = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
    private final Set<IntentionActionWithTextCaching> myInspectionFixes = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
    private final Set<IntentionActionWithTextCaching> myGutters = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
    private final Set<IntentionActionWithTextCaching> myNotifications = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
    private int myOffset;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final Project myProject;
    private static final TObjectHashingStrategy<IntentionActionWithTextCaching> ACTION_TEXT_AND_CLASS_EQUALS = new TObjectHashingStrategy<IntentionActionWithTextCaching>(){

        public int computeHashCode(IntentionActionWithTextCaching object) {
            return object.getText().hashCode();
        }

        public boolean equals(IntentionActionWithTextCaching o1, IntentionActionWithTextCaching o2) {
            return this.getActionClass(o1) == this.getActionClass(o2) && o1.getText().equals(o2.getText());
        }

        private Class<? extends IntentionAction> getActionClass(IntentionActionWithTextCaching o1) {
            return IntentionActionDelegate.unwrap((IntentionAction)o1.getAction()).getClass();
        }
    };

    public CachedIntentions(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor) {
        this.myProject = project;
        this.myFile = file2;
        this.myEditor = editor;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getIntentions() {
        return this.myIntentions;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getErrorFixes() {
        return this.myErrorFixes;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getInspectionFixes() {
        return this.myInspectionFixes;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getGutters() {
        return this.myGutters;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getNotifications() {
        return this.myNotifications;
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public PsiFile getFile() {
        return this.myFile;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public int getOffset() {
        return this.myOffset;
    }

    @NotNull
    public static CachedIntentions create(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        CachedIntentions res2 = new CachedIntentions(project, file2, editor);
        res2.wrapAndUpdateActions(intentions, false);
        return res2;
    }

    @NotNull
    public static CachedIntentions createAndUpdateActions(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        CachedIntentions res2 = new CachedIntentions(project, file2, editor);
        res2.wrapAndUpdateActions(intentions, true);
        return res2;
    }

    public boolean wrapAndUpdateActions(@NotNull ShowIntentionsPass.IntentionsInfo newInfo, boolean callUpdate) {
        this.myOffset = newInfo.getOffset();
        boolean changed2 = this.wrapActionsTo(newInfo.errorFixesToShow, this.myErrorFixes, callUpdate);
        changed2 |= this.wrapActionsTo(newInfo.inspectionFixesToShow, this.myInspectionFixes, callUpdate);
        changed2 |= this.wrapActionsTo(newInfo.intentionsToShow, this.myIntentions, callUpdate);
        changed2 |= this.wrapActionsTo(newInfo.guttersToShow, this.myGutters, callUpdate);
        return changed2 |= this.wrapActionsTo(newInfo.notificationActionsToShow, this.myNotifications, callUpdate);
    }

    public boolean addActions(@NotNull ShowIntentionsPass.IntentionsInfo info) {
        boolean changed2 = this.addActionsTo(info.errorFixesToShow, this.myErrorFixes);
        changed2 |= this.addActionsTo(info.inspectionFixesToShow, this.myInspectionFixes);
        changed2 |= this.addActionsTo(info.intentionsToShow, this.myIntentions);
        changed2 |= this.addActionsTo(info.guttersToShow, this.myGutters);
        return changed2 |= this.addActionsTo(info.notificationActionsToShow, this.myNotifications);
    }

    private boolean addActionsTo(@NotNull List<? extends HighlightInfo.IntentionActionDescriptor> newDescriptors, @NotNull Set<? super IntentionActionWithTextCaching> cachedActions) {
        boolean changed2 = false;
        for (HighlightInfo.IntentionActionDescriptor intentionActionDescriptor : newDescriptors) {
            changed2 |= cachedActions.add(this.wrapAction(intentionActionDescriptor, (PsiElement)this.myFile, this.myFile, this.myEditor));
        }
        return changed2;
    }

    private boolean wrapActionsTo(@NotNull List<? extends HighlightInfo.IntentionActionDescriptor> newDescriptors, @NotNull Set<IntentionActionWithTextCaching> cachedActions, boolean shouldCallIsAvailable) {
        Editor injectedEditor;
        PsiFile injectedFile;
        PsiElement element2;
        PsiFile hostElement;
        int n;
        if (cachedActions.isEmpty() && newDescriptors.isEmpty()) {
            return false;
        }
        boolean changed2 = false;
        if (this.myEditor == null) {
            LOG.assertTrue(!shouldCallIsAvailable);
            for (HighlightInfo.IntentionActionDescriptor intentionActionDescriptor : newDescriptors) {
                changed2 |= cachedActions.add(this.wrapAction(intentionActionDescriptor, (PsiElement)this.myFile, this.myFile, null));
            }
            return changed2;
        }
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        int n2 = n = caretOffset > 0 && caretOffset == this.myFile.getTextLength() ? caretOffset - 1 : caretOffset;
        if (this.myFile instanceof PsiCompiledElement) {
            PsiFile element22;
            hostElement = element22 = this.myFile;
        } else if (PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument())) {
            FileViewProvider viewProvider = this.myFile.getViewProvider();
            element2 = viewProvider.findElementAt(n, viewProvider.getBaseLanguage());
            hostElement = element2;
        } else {
            hostElement = this.myFile.getViewProvider().findElementAt(n, this.myFile.getLanguage());
            element2 = InjectedLanguageUtil.findElementAtNoCommit(this.myFile, n);
        }
        if (element2 == null || element2 == hostElement) {
            injectedFile = this.myFile;
            injectedEditor = this.myEditor;
        } else {
            injectedFile = element2.getContainingFile();
            injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(this.myEditor, injectedFile);
        }
        if (shouldCallIsAvailable) {
            Iterator<IntentionActionWithTextCaching> iterator2 = cachedActions.iterator();
            while (iterator2.hasNext()) {
                IntentionActionWithTextCaching cachedAction = iterator2.next();
                IntentionAction intentionAction = cachedAction.getAction();
                Pair<PsiFile, Editor> applicableIn = ShowIntentionActionsHandler.chooseBetweenHostAndInjected(this.myFile, this.myEditor, injectedFile, (PairProcessor<? super PsiFile, ? super Editor>)((PairProcessor)(f, e) -> ShowIntentionActionsHandler.availableFor(f, e, action2)));
                if (applicableIn != null) continue;
                iterator2.remove();
                changed2 = true;
            }
        }
        THashSet wrappedNew = new THashSet(newDescriptors.size(), ACTION_TEXT_AND_CLASS_EQUALS);
        for (HighlightInfo.IntentionActionDescriptor intentionActionDescriptor : newDescriptors) {
            IntentionActionWithTextCaching cachedAction;
            IntentionAction action3 = intentionActionDescriptor.getAction();
            if (element2 != null && element2 != hostElement && (!shouldCallIsAvailable || ShowIntentionActionsHandler.availableFor(injectedFile, injectedEditor, action3))) {
                cachedAction = this.wrapAction(intentionActionDescriptor, element2, injectedFile, injectedEditor);
                wrappedNew.add(cachedAction);
                changed2 |= cachedActions.add(cachedAction);
                continue;
            }
            if (hostElement == null || shouldCallIsAvailable && !ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, action3)) continue;
            cachedAction = this.wrapAction(intentionActionDescriptor, (PsiElement)hostElement, this.myFile, this.myEditor);
            wrappedNew.add(cachedAction);
            changed2 |= cachedActions.add(cachedAction);
        }
        Iterator<IntentionActionWithTextCaching> iterator3 = cachedActions.iterator();
        while (iterator3.hasNext()) {
            IntentionActionWithTextCaching intentionActionWithTextCaching = iterator3.next();
            if (wrappedNew.contains(intentionActionWithTextCaching)) continue;
            iterator3.remove();
            changed2 = true;
        }
        return changed2;
    }

    @NotNull
    IntentionActionWithTextCaching wrapAction(@NotNull HighlightInfo.IntentionActionDescriptor descriptor2, @NotNull PsiElement element2, @NotNull PsiFile containingFile, @Nullable Editor containingEditor) {
        IntentionActionWithTextCaching cachedAction = new IntentionActionWithTextCaching(descriptor2, (cached, action2) -> {
            if (action2 instanceof QuickFixWrapper) {
                this.removeActionFromCached((IntentionActionWithTextCaching)cached);
                this.markInvoked((IntentionAction)action2);
            }
        });
        List<IntentionAction> options2 = descriptor2.getOptions(element2, containingEditor);
        if (options2 == null) {
            return cachedAction;
        }
        for (IntentionAction option2 : options2) {
            boolean isInspectionFix;
            Pair<PsiFile, Editor> availableIn;
            Editor editor = (Editor)ObjectUtils.chooseNotNull((Object)this.myEditor, (Object)containingEditor);
            if (editor == null || (availableIn = ShowIntentionActionsHandler.chooseBetweenHostAndInjected(this.myFile, editor, containingFile, (PairProcessor<? super PsiFile, ? super Editor>)((PairProcessor)(f, e) -> ShowIntentionActionsHandler.availableFor(f, e, option2)))) == null) continue;
            IntentionActionWithTextCaching textCaching = new IntentionActionWithTextCaching(option2);
            boolean isErrorFix = this.myErrorFixes.contains(textCaching);
            if (isErrorFix) {
                cachedAction.addErrorFix(option2);
            }
            if (isInspectionFix = this.myInspectionFixes.contains(textCaching)) {
                cachedAction.addInspectionFix(option2);
                continue;
            }
            cachedAction.addIntention(option2);
        }
        return cachedAction;
    }

    private void markInvoked(@NotNull IntentionAction action2) {
        if (this.myEditor != null) {
            ShowIntentionsPass.markActionInvoked(this.myFile.getProject(), this.myEditor, action2);
        }
    }

    private void removeActionFromCached(@NotNull IntentionActionWithTextCaching action2) {
        this.myErrorFixes.remove(action2);
        this.myGutters.remove(action2);
        this.myInspectionFixes.remove(action2);
        this.myIntentions.remove(action2);
        this.myNotifications.remove(action2);
    }

    @NotNull
    public List<IntentionActionWithTextCaching> getAllActions() {
        List<IntentionActionWithTextCaching> result2 = new ArrayList<IntentionActionWithTextCaching>(this.myErrorFixes);
        result2.addAll(this.myInspectionFixes);
        result2.addAll(this.myIntentions);
        result2.addAll(this.myGutters);
        result2.addAll(this.myNotifications);
        result2 = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(result2);
        result2.sort((o1, o2) -> {
            int weight2;
            int weight1 = this.getWeight((IntentionActionWithTextCaching)o1);
            if (weight1 != (weight2 = this.getWeight((IntentionActionWithTextCaching)o2))) {
                return weight2 - weight1;
            }
            return o1.compareTo((IntentionActionWithTextCaching)o2);
        });
        return result2;
    }

    private int getWeight(@NotNull IntentionActionWithTextCaching action2) {
        IntentionAction a = action2.getAction();
        int group = this.getGroup(action2).getPriority();
        while (a instanceof IntentionActionDelegate) {
            a = ((IntentionActionDelegate)a).getDelegate();
        }
        if (a instanceof PriorityAction) {
            return group + CachedIntentions.getPriorityWeight(((PriorityAction)a).getPriority());
        }
        if (a instanceof SuppressIntentionActionFromFix && ((SuppressIntentionActionFromFix)a).isShouldBeAppliedToInjectionHost() == ThreeState.NO) {
            return group - 1;
        }
        return group;
    }

    private static int getPriorityWeight(PriorityAction.Priority priority) {
        switch (priority) {
            case TOP: {
                return 20;
            }
            case HIGH: {
                return 3;
            }
            case LOW: {
                return -3;
            }
        }
        return 0;
    }

    @NotNull
    public IntentionGroup getGroup(@NotNull IntentionActionWithTextCaching action2) {
        if (this.myErrorFixes.contains(action2)) {
            return IntentionGroup.ERROR;
        }
        if (this.myInspectionFixes.contains(action2)) {
            return IntentionGroup.INSPECTION;
        }
        if (this.myNotifications.contains(action2)) {
            return IntentionGroup.NOTIFICATION;
        }
        if (this.myGutters.contains(action2)) {
            return IntentionGroup.GUTTER;
        }
        if (action2.getAction() instanceof EmptyIntentionAction) {
            return IntentionGroup.EMPTY_ACTION;
        }
        return IntentionGroup.OTHER;
    }

    @NotNull
    public Icon getIcon(@NotNull IntentionActionWithTextCaching value2) {
        Icon icon2;
        if (value2.getIcon() != null) {
            return value2.getIcon();
        }
        IntentionAction action2 = value2.getAction();
        while (action2 instanceof IntentionActionDelegate) {
            action2 = ((IntentionActionDelegate)action2).getDelegate();
        }
        IntentionAction iconable = action2;
        if (action2 instanceof QuickFixWrapper) {
            iconable = ((QuickFixWrapper)action2).getFix();
        }
        if (iconable instanceof Iconable && (icon2 = ((Iconable)iconable).getIcon(0)) != null) {
            return icon2;
        }
        if (IntentionManagerSettings.getInstance().isShowLightBulb(action2)) {
            return this.myErrorFixes.contains(value2) ? AllIcons.Actions.QuickfixBulb : (this.myInspectionFixes.contains(value2) ? AllIcons.Actions.IntentionBulb : AllIcons.Actions.RealIntentionBulb);
        }
        if (this.myErrorFixes.contains(value2)) {
            return AllIcons.Actions.QuickfixOffBulb;
        }
        return IconLoader.getDisabledIcon((Icon)AllIcons.Actions.RealIntentionBulb);
    }

    public boolean showBulb() {
        return ContainerUtil.exists(this.getAllActions(), info -> IntentionManagerSettings.getInstance().isShowLightBulb(info.getAction()));
    }

    public String toString() {
        return "CachedIntentions{myIntentions=" + this.myIntentions + ", myErrorFixes=" + this.myErrorFixes + ", myInspectionFixes=" + this.myInspectionFixes + ", myGutters=" + this.myGutters + ", myNotifications=" + this.myNotifications + '}';
    }
}

