/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.generation.AutoIndentLinesHandler;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoIndentLinesAction
extends BaseCodeInsightAction
implements DumbAware {
    @Override
    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext, @NotNull Project project, boolean forUpdate) {
        Editor editor = this.getBaseEditor(dataContext, project);
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile psiFile = documentManager.getCachedPsiFile(document);
        if (psiFile == null) {
            return editor;
        }
        if (!forUpdate) {
            documentManager.commitAllDocuments();
        }
        int startLineOffset = DocumentUtil.getLineStartOffset(editor.getSelectionModel().getSelectionStart(), document);
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, psiFile, startLineOffset);
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new AutoIndentLinesHandler();
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        FileType fileType = file2.getFileType();
        return fileType instanceof LanguageFileType && LanguageFormatting.INSTANCE.forContext(((LanguageFileType)fileType).getLanguage(), (PsiElement)file2) != null;
    }
}

