/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.actions.BaseFoldingHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpandAllRegionsAction
extends EditorAction {
    public ExpandAllRegionsAction() {
        super((EditorActionHandler)new BaseFoldingHandler(){

            public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
                Project project = editor.getProject();
                assert (project != null);
                FoldingModel foldingModel = editor.getFoldingModel();
                CodeFoldingManager codeFoldingManager = CodeFoldingManager.getInstance(project);
                List<FoldRegion> regions = this.getFoldRegionsForSelection(editor, caret);
                ArrayList expandedRegions = new ArrayList();
                foldingModel.runBatchFoldingOperation(() -> {
                    for (FoldRegion region : regions) {
                        Boolean collapsedByDefault = codeFoldingManager.isCollapsedByDefault(region);
                        if (region.isExpanded() || region.shouldNeverExpand() || collapsedByDefault != null && collapsedByDefault.booleanValue()) continue;
                        region.setExpanded(true);
                        expandedRegions.add(region);
                    }
                });
                for (FoldRegion expandedRegion : expandedRegions) {
                    FoldRegion collapsedRegion = foldingModel.getCollapsedRegionAtOffset(expandedRegion.getStartOffset());
                    if (collapsedRegion != null && collapsedRegion.shouldNeverExpand()) continue;
                    return;
                }
                foldingModel.runBatchFoldingOperation(() -> {
                    for (FoldRegion region : regions) {
                        region.setExpanded(true);
                    }
                });
            }
        });
    }
}

