/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollapseExpandDocCommentsHandler
implements CodeInsightActionHandler {
    private static final Key<Boolean> DOC_COMMENT_MARK = Key.create((String)"explicit.fold.region.doc.comment.mark");
    private final boolean myExpand;

    public static void setDocCommentMark(@NotNull FoldRegion region, boolean value2) {
        region.putUserData(DOC_COMMENT_MARK, (Object)value2);
    }

    public CollapseExpandDocCommentsHandler(boolean isExpand) {
        this.myExpand = isExpand;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(project);
        foldingManager.updateFoldRegions(editor);
        FoldRegion[] allFoldRegions = editor.getFoldingModel().getAllFoldRegions();
        Runnable processor2 = () -> {
            for (FoldRegion region : allFoldRegions) {
                PsiElement element2 = EditorFoldingInfo.get(editor).getPsiElement(region);
                if (!(element2 instanceof PsiDocCommentBase) && !Boolean.TRUE.equals(region.getUserData(DOC_COMMENT_MARK)) && !CollapseExpandDocCommentsHandler.hasAllowedTokenType(editor, region, element2)) continue;
                region.setExpanded(this.myExpand);
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(processor2);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return null;
    }

    private static boolean hasAllowedTokenType(@NotNull Editor editor, @NotNull FoldRegion region, @Nullable PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(element2.getLanguage());
        if (!(editor instanceof EditorEx) || !(commenter instanceof CodeDocumentationAwareCommenter)) {
            return false;
        }
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(region.getStartOffset());
        if (iterator2.atEnd()) {
            return false;
        }
        return ((CodeDocumentationAwareCommenter)commenter).getDocumentationCommentTokenType() == iterator2.getTokenType();
    }
}

