/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.WordSelectioner;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LineCommentSelectioner
extends WordSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        if (e instanceof PsiComment) {
            Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(e.getLanguage());
            if (!(commenter instanceof CodeDocumentationAwareCommenter)) {
                return true;
            }
            return !((CodeDocumentationAwareCommenter)commenter).isDocumentationComment((PsiComment)e);
        }
        return false;
    }

    @Override
    public List<TextRange> select(@NotNull PsiElement element2, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        PsiElement e;
        List<TextRange> result2 = super.select(element2, editorText, cursorOffset, editor);
        assert (result2 != null);
        PsiElement firstComment = element2;
        for (e = element2; e != null; e = e.getPrevSibling()) {
            if (e instanceof PsiComment) {
                firstComment = e;
                continue;
            }
            if (!(e instanceof PsiWhiteSpace)) break;
        }
        PsiElement lastComment = element2;
        for (e = element2; e != null; e = e.getNextSibling()) {
            if (e instanceof PsiComment) {
                lastComment = e;
                continue;
            }
            if (!(e instanceof PsiWhiteSpace)) break;
        }
        result2.addAll(LineCommentSelectioner.expandToWholeLine(editorText, new TextRange(firstComment.getTextRange().getStartOffset(), lastComment.getTextRange().getEndOffset())));
        return result2;
    }
}

