/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandlerEP;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.highlighting.NontrivialBraceMatcher;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageQuoteHandling;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DefaultRawTypedHandler;
import com.intellij.openapi.editor.impl.TypedActionImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedHandler
extends TypedActionHandlerBase {
    private static final Set<Character> COMPLEX_CHARS = ContainerUtil.set((Object[])new Character[]{Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('\"'), Character.valueOf('\'')});
    private static final Logger LOG = Logger.getInstance(TypedHandler.class);
    private static final KeyedExtensionCollector<QuoteHandler, String> quoteHandlers = new KeyedExtensionCollector(QuoteHandlerEP.EP_NAME);
    private static final Map<Class<? extends Language>, QuoteHandler> ourBaseLanguageQuoteHandlers = new HashMap<Class<? extends Language>, QuoteHandler>();

    public TypedHandler(TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    @Nullable
    public static QuoteHandler getQuoteHandler(@NotNull PsiFile file2, @NotNull Editor editor) {
        FileType fileFileType;
        FileType fileType = TypedHandler.getFileType(file2, editor);
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandlerForType(fileType);
        if (quoteHandler == null && (fileFileType = file2.getFileType()) != fileType) {
            quoteHandler = TypedHandler.getQuoteHandlerForType(fileFileType);
        }
        if (quoteHandler == null) {
            return TypedHandler.getLanguageQuoteHandler(file2.getViewProvider().getBaseLanguage());
        }
        return quoteHandler;
    }

    public static QuoteHandler getLanguageQuoteHandler(Language baseLanguage) {
        for (Map.Entry<Class<? extends Language>, QuoteHandler> entry : ourBaseLanguageQuoteHandlers.entrySet()) {
            if (!entry.getKey().isInstance(baseLanguage)) continue;
            return entry.getValue();
        }
        return (QuoteHandler)LanguageQuoteHandling.INSTANCE.forLanguage(baseLanguage);
    }

    @NotNull
    static FileType getFileType(@NotNull PsiFile file2, @NotNull Editor editor) {
        LanguageFileType associatedFileType;
        FileType fileType = file2.getFileType();
        Language language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)file2.getProject());
        if (language != null && language != PlainTextLanguage.INSTANCE && (associatedFileType = language.getAssociatedFileType()) != null) {
            fileType = associatedFileType;
        }
        return fileType;
    }

    public static void registerBaseLanguageQuoteHandler(@NotNull Class<? extends Language> languageClass, @NotNull QuoteHandler quoteHandler) {
        ourBaseLanguageQuoteHandlers.put(languageClass, quoteHandler);
    }

    public static QuoteHandler getQuoteHandlerForType(@NotNull FileType fileType) {
        return (QuoteHandler)ContainerUtil.getFirstItem((List)quoteHandlers.forKey((Object)fileType.getName()));
    }

    @Deprecated
    public static void registerQuoteHandler(@NotNull FileType fileType, @NotNull QuoteHandler quoteHandler) {
        quoteHandlers.addExplicitExtension((Object)fileType.getName(), (Object)quoteHandler);
    }

    @Override
    public void beforeExecute(@NotNull Editor editor, char c, @NotNull DataContext context, @NotNull ActionPlan plan) {
        if (COMPLEX_CHARS.contains(Character.valueOf(c)) || Character.isSurrogate(c)) {
            return;
        }
        for (TypedHandlerDelegate delegate : TypedHandlerDelegate.EP_NAME.getExtensionList()) {
            if (delegate.isImmediatePaintingEnabled(editor, c, context)) continue;
            return;
        }
        if (editor.isInsertMode()) {
            int offset = plan.getCaretOffset();
            plan.replace(offset, offset, String.valueOf(c));
        }
        super.beforeExecute(editor, c, context, plan);
    }

    public void execute(@NotNull Editor originalEditor, char charTyped, @NotNull DataContext dataContext) {
        PsiFile originalFile;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null || (originalFile = PsiUtilBase.getPsiFileInEditor((Editor)originalEditor, (Project)project)) == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(originalEditor, charTyped, dataContext);
            }
            return;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)originalEditor)) {
            return;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        Document originalDocument = originalEditor.getDocument();
        originalEditor.getCaretModel().runForEachCaret(caret -> {
            boolean handled;
            Editor editor;
            PsiFile file2;
            if (psiDocumentManager.isDocumentBlockedByPsi(originalDocument)) {
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(originalDocument);
            }
            PsiFile psiFile = file2 = (editor = TypedHandler.injectedEditorIfCharTypedIsSignificant(charTyped, originalEditor, originalFile)) == originalEditor ? originalFile : Objects.requireNonNull(psiDocumentManager.getPsiFile(editor.getDocument()));
            if (caret == originalEditor.getCaretModel().getPrimaryCaret() && !(handled = TypedHandler.callDelegates(delegate -> delegate.checkAutoPopup(charTyped, project, editor, file2)))) {
                TypedHandler.autoPopupCompletion(editor, charTyped, project, file2);
                TypedHandler.autoPopupParameterInfo(editor, charTyped, project, file2);
            }
            if (!editor.isInsertMode()) {
                TypedHandler.type(originalEditor, project, charTyped);
                return;
            }
            if (TypedHandler.callDelegates(delegate -> delegate.beforeSelectionRemoved(charTyped, project, editor, file2))) {
                return;
            }
            EditorModificationUtil.deleteSelectedText((Editor)editor);
            FileType fileType = TypedHandler.getFileType(file2, editor);
            if (TypedHandler.callDelegates(delegate -> delegate.beforeCharTyped(charTyped, project, editor, file2, fileType))) {
                return;
            }
            if (')' == charTyped || ']' == charTyped || '}' == charTyped ? FileTypes.PLAIN_TEXT != fileType && TypedHandler.handleRParen(editor, fileType, charTyped) : ('\"' == charTyped || '\'' == charTyped || '`' == charTyped) && TypedHandler.handleQuote(editor, project, charTyped, file2)) {
                return;
            }
            long modificationStampBeforeTyping = editor.getDocument().getModificationStamp();
            TypedHandler.type(originalEditor, project, charTyped);
            AutoHardWrapHandler.getInstance().wrapLineIfNecessary(originalEditor, dataContext, modificationStampBeforeTyping);
            if (editor.isDisposed()) {
                return;
            }
            if (('(' == charTyped || '[' == charTyped || '{' == charTyped) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && fileType != FileTypes.PLAIN_TEXT) {
                TypedHandler.handleAfterLParen(editor, fileType, charTyped);
            } else if ('}' == charTyped) {
                TypedHandler.indentClosingBrace(project, editor);
            } else if (')' == charTyped) {
                TypedHandler.indentClosingParenth(project, editor);
            }
            if (TypedHandler.callDelegates(delegate -> delegate.charTyped(charTyped, project, editor, file2))) {
                return;
            }
            if ('{' == charTyped) {
                TypedHandler.indentOpenedBrace(project, editor);
            } else if ('(' == charTyped) {
                TypedHandler.indentOpenedParenth(project, editor);
            }
        });
    }

    private static boolean callDelegates(Function<TypedHandlerDelegate, TypedHandlerDelegate.Result> action2) {
        for (TypedHandlerDelegate delegate : TypedHandlerDelegate.EP_NAME.getExtensionList()) {
            TypedHandlerDelegate.Result result2 = action2.apply(delegate);
            if (result2 == TypedHandlerDelegate.Result.STOP) {
                return true;
            }
            if (result2 != TypedHandlerDelegate.Result.DEFAULT) continue;
            break;
        }
        return false;
    }

    private static void type(Editor editor, Project project, char charTyped) {
        CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message((String)"typing.in.editor.command.name", (Object[])new Object[0]));
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)String.valueOf(charTyped), (boolean)true, (boolean)true);
        ((UndoManagerImpl)UndoManager.getInstance((Project)project)).addDocumentAsAffected(editor.getDocument());
    }

    private static void autoPopupParameterInfo(@NotNull Editor editor, char charTyped, @NotNull Project project, @NotNull PsiFile file2) {
        if (!(charTyped != '(' && charTyped != ',' || TypedHandler.isInsideStringLiteral(editor, file2))) {
            AutoPopupController.getInstance(project).autoPopupParameterInfo(editor, null);
        }
    }

    public static void autoPopupCompletion(@NotNull Editor editor, char charTyped, @NotNull Project project, @NotNull PsiFile file2) {
        if (charTyped == '.' || TypedHandler.isAutoPopup(editor, file2, charTyped)) {
            AutoPopupController.getInstance(project).autoPopupMemberLookup(editor, null);
        }
    }

    public static void commitDocumentIfCurrentCaretIsNotTheFirstOne(@NotNull Editor editor, @NotNull Project project) {
        if (ContainerUtil.getFirstItem((List)editor.getCaretModel().getAllCarets()) != editor.getCaretModel().getCurrentCaret()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        }
    }

    private static boolean isAutoPopup(@NotNull Editor editor, @NotNull PsiFile file2, char charTyped) {
        PsiElement element2;
        int offset = editor.getCaretModel().getOffset() - 1;
        if (offset >= 0 && (element2 = file2.findElementAt(offset)) != null) {
            for (CompletionContributor contributor : CompletionContributor.forLanguageHonorDumbness((Language)element2.getLanguage(), (Project)file2.getProject())) {
                if (!contributor.invokeAutoPopup(element2, charTyped)) continue;
                LOG.debug(contributor + " requested completion autopopup when typing '" + charTyped + "'");
                return true;
            }
        }
        return false;
    }

    private static boolean isInsideStringLiteral(@NotNull Editor editor, @NotNull PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element2 = file2.findElementAt(offset);
        if (element2 == null) {
            return false;
        }
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element2.getLanguage());
        if (definition != null) {
            ASTNode parentNode;
            TokenSet stringLiteralElements = definition.getStringLiteralElements();
            ASTNode node = element2.getNode();
            if (node == null) {
                return false;
            }
            IElementType elementType = node.getElementType();
            if (stringLiteralElements.contains(elementType)) {
                return true;
            }
            PsiElement parent = element2.getParent();
            if (parent != null && (parentNode = parent.getNode()) != null && stringLiteralElements.contains(parentNode.getElementType())) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static Editor injectedEditorIfCharTypedIsSignificant(char charTyped, @NotNull Editor editor, @NotNull PsiFile oldFile) {
        return TypedHandler.injectedEditorIfCharTypedIsSignificant((int)charTyped, editor, oldFile);
    }

    @NotNull
    public static Editor injectedEditorIfCharTypedIsSignificant(int charTyped, @NotNull Editor editor, @NotNull PsiFile oldFile) {
        int offset = editor.getCaretModel().getOffset();
        List injected = InjectedLanguageManager.getInstance((Project)oldFile.getProject()).getCachedInjectedDocumentsInRange(oldFile, (TextRange)ProperTextRange.create((int)offset, (int)offset));
        for (DocumentWindow documentWindow : injected) {
            PsiFile injectedFile;
            if (!documentWindow.isValid() || !documentWindow.containsRange(offset, offset) || (injectedFile = PsiDocumentManager.getInstance((Project)oldFile.getProject()).getPsiFile((Document)documentWindow)) == null) continue;
            Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
            TextRange hostRange = documentWindow.getHostRange(offset);
            CharSequence sequence = editor.getDocument().getCharsSequence();
            if ((sequence.length() <= offset || charTyped == Character.codePointAt(sequence, offset)) && (hostRange == null || !hostRange.contains(offset))) continue;
            return injectedEditor;
        }
        return editor;
    }

    private static void handleAfterLParen(@NotNull Editor editor, @NotNull FileType fileType, char lparenChar) {
        boolean matched;
        int lparenOffset;
        boolean atEndOfDocument;
        int offset = editor.getCaretModel().getOffset();
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        boolean bl = atEndOfDocument = offset == editor.getDocument().getTextLength();
        if (!atEndOfDocument) {
            iterator2.retreat();
        }
        if (iterator2.atEnd()) {
            return;
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        if (iterator2.atEnd()) {
            return;
        }
        IElementType braceTokenType = iterator2.getTokenType();
        CharSequence fileText = editor.getDocument().getCharsSequence();
        if (!braceMatcher.isLBraceToken(iterator2, fileText, fileType)) {
            return;
        }
        if (!iterator2.atEnd()) {
            iterator2.advance();
            if (!iterator2.atEnd() && !BraceMatchingUtil.isPairedBracesAllowedBeforeTypeInFileType(braceTokenType, iterator2.getTokenType(), fileType)) {
                return;
            }
            iterator2.retreat();
        }
        if ((lparenOffset = BraceMatchingUtil.findLeftmostLParen(iterator2, braceTokenType, fileText, fileType)) < 0) {
            lparenOffset = 0;
        }
        if (!(matched = BraceMatchingUtil.matchBrace(fileText, fileType, iterator2 = ((EditorEx)editor).getHighlighter().createIterator(lparenOffset), true, true))) {
            String text;
            if (lparenChar == '(') {
                text = ")";
            } else if (lparenChar == '[') {
                text = "]";
            } else if (lparenChar == '<') {
                text = ">";
            } else if (lparenChar == '{') {
                text = "}";
            } else {
                throw new AssertionError((Object)("Unknown char " + lparenChar));
            }
            editor.getDocument().insertString(offset, (CharSequence)text);
            TabOutScopesTracker.getInstance().registerEmptyScope(editor, offset);
        }
    }

    public static boolean handleRParen(@NotNull Editor editor, @NotNull FileType fileType, char charTyped) {
        boolean matched;
        CharSequence text;
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator2.atEnd()) {
            return false;
        }
        if (iterator2.getEnd() - iterator2.getStart() != 1 || editor.getDocument().getCharsSequence().charAt(iterator2.getStart()) != charTyped) {
            return false;
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        if (!braceMatcher.isRBraceToken(iterator2, text = editor.getDocument().getCharsSequence(), fileType)) {
            return false;
        }
        IElementType tokenType = iterator2.getTokenType();
        iterator2.retreat();
        IElementType lparenTokenType = braceMatcher.getOppositeBraceTokenType(tokenType);
        int lparenthOffset = BraceMatchingUtil.findLeftmostLParen(iterator2, lparenTokenType, text, fileType);
        if (lparenthOffset < 0) {
            if (braceMatcher instanceof NontrivialBraceMatcher) {
                for (IElementType t : ((NontrivialBraceMatcher)braceMatcher).getOppositeBraceTokenTypes(tokenType)) {
                    if (t != lparenTokenType && (lparenthOffset = BraceMatchingUtil.findLeftmostLParen(iterator2, t, text, fileType)) >= 0) break;
                }
            }
            if (lparenthOffset < 0) {
                return false;
            }
        }
        if (!(matched = BraceMatchingUtil.matchBrace(text, fileType, iterator2 = ((EditorEx)editor).getHighlighter().createIterator(lparenthOffset), true, true))) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        return true;
    }

    private static boolean handleQuote(@NotNull Editor editor, Project project, char quote, @NotNull PsiFile file2) {
        CharSequence closingQuote;
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            return false;
        }
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandler(file2, editor);
        if (quoteHandler == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        int length = document.getTextLength();
        if (TypedHandler.isTypingEscapeQuote(editor, quoteHandler, offset)) {
            return false;
        }
        if (offset < length && chars.charAt(offset) == quote && TypedHandler.isClosingQuote(editor, quoteHandler, offset)) {
            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
            return true;
        }
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (!iterator2.atEnd()) {
            IElementType tokenType = iterator2.getTokenType();
            if (quoteHandler instanceof JavaLikeQuoteHandler) {
                try {
                    if (!((JavaLikeQuoteHandler)quoteHandler).isAppropriateElementTypeForLiteral(tokenType)) {
                        return false;
                    }
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
        }
        TypedHandler.type(editor, project, quote);
        offset = editor.getCaretModel().getOffset();
        if (quoteHandler instanceof MultiCharQuoteHandler && (closingQuote = TypedHandler.getClosingQuote(editor, (MultiCharQuoteHandler)quoteHandler, offset)) != null && TypedHandler.hasNonClosedLiterals(editor, quoteHandler, offset - 1) && (offset == document.getTextLength() || !Character.isUnicodeIdentifierPart(document.getCharsSequence().charAt(offset)))) {
            ((MultiCharQuoteHandler)quoteHandler).insertClosingQuote(editor, offset, file2, closingQuote);
            return true;
        }
        if (offset > 0 && TypedHandler.isOpeningQuote(editor, quoteHandler, offset - 1) && TypedHandler.hasNonClosedLiterals(editor, quoteHandler, offset - 1) && (offset == document.getTextLength() || !Character.isUnicodeIdentifierPart(document.getCharsSequence().charAt(offset)))) {
            document.insertString(offset, (CharSequence)String.valueOf(quote));
            TabOutScopesTracker.getInstance().registerEmptyScope(editor, offset);
        }
        return true;
    }

    private static boolean isClosingQuote(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator2.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isClosingQuote(iterator2, offset);
    }

    @Nullable
    private static CharSequence getClosingQuote(@NotNull Editor editor, @NotNull MultiCharQuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator2.atEnd()) {
            LOG.assertTrue(false);
            return null;
        }
        return quoteHandler.getClosingQuote(iterator2, offset);
    }

    private static boolean isOpeningQuote(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator2.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isOpeningQuote(iterator2, offset);
    }

    private static boolean hasNonClosedLiterals(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator2.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.hasNonClosedLiteral(editor, iterator2, offset);
    }

    private static boolean isTypingEscapeQuote(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        if (offset == 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        int offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)"\\");
        int slashCount = offset - 1 - offset1;
        return slashCount % 2 != 0 && TypedHandler.isInsideLiteral(editor, quoteHandler, offset);
    }

    private static boolean isInsideLiteral(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        if (offset == 0) {
            return false;
        }
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset - 1);
        if (iterator2.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isInsideLiteral(iterator2);
    }

    private static void indentClosingBrace(@NotNull Project project, @NotNull Editor editor) {
        TypedHandler.indentBrace(project, editor, '}');
    }

    public static void indentOpenedBrace(@NotNull Project project, @NotNull Editor editor) {
        TypedHandler.indentBrace(project, editor, '{');
    }

    private static void indentOpenedParenth(@NotNull Project project, @NotNull Editor editor) {
        TypedHandler.indentBrace(project, editor, '(');
    }

    private static void indentClosingParenth(@NotNull Project project, @NotNull Editor editor) {
        TypedHandler.indentBrace(project, editor, ')');
    }

    private static void indentBrace(@NotNull Project project, @NotNull Editor editor, char braceChar) {
        int offset = editor.getCaretModel().getOffset() - 1;
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        if (offset < 0 || chars.charAt(offset) != braceChar) {
            return;
        }
        int spaceStart = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
        if (spaceStart < 0 || chars.charAt(spaceStart) == '\n' || chars.charAt(spaceStart) == '\r') {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.commitDocument(document);
            PsiFile file2 = documentManager.getPsiFile(document);
            if (file2 == null || !file2.isWritable()) {
                return;
            }
            PsiElement element2 = file2.findElementAt(offset);
            if (element2 == null) {
                return;
            }
            EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
            HighlighterIterator iterator2 = highlighter.createIterator(offset);
            FileType fileType = file2.getFileType();
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
            boolean rBraceToken = braceMatcher.isRBraceToken(iterator2, chars, fileType);
            boolean isBrace = braceMatcher.isLBraceToken(iterator2, chars, fileType) || rBraceToken;
            int lBraceOffset = -1;
            if (CodeInsightSettings.getInstance().REFORMAT_BLOCK_ON_RBRACE && rBraceToken && braceMatcher.isStructuralBrace(iterator2, chars, fileType) && offset > 0) {
                lBraceOffset = BraceMatchingUtil.findLeftLParen(highlighter.createIterator(offset - 1), braceMatcher.getOppositeBraceTokenType(iterator2.getTokenType()), editor.getDocument().getCharsSequence(), fileType);
            }
            if (element2.getNode() != null && isBrace) {
                DefaultRawTypedHandler handler2 = ((TypedActionImpl)TypedAction.getInstance()).getDefaultRawTypedHandler();
                handler2.beginUndoablePostProcessing();
                int finalLBraceOffset = lBraceOffset;
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        int newOffset;
                        if (finalLBraceOffset != -1) {
                            RangeMarker marker = document.createRangeMarker(offset, offset + 1);
                            CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)file2, finalLBraceOffset, offset, true);
                            newOffset = marker.getStartOffset();
                            marker.dispose();
                        } else {
                            newOffset = CodeStyleManager.getInstance((Project)project).adjustLineIndent(file2, offset);
                        }
                        editor.getCaretModel().moveToOffset(newOffset + 1);
                        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        editor.getSelectionModel().removeSelection();
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                });
            }
        }
    }
}

