/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.quickFix.AbstractCreateFileFix;
import com.intellij.codeInsight.daemon.quickFix.NewFileLocation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFilePathFix
extends AbstractCreateFileFix {
    private final String myText;
    @Nullable
    private Supplier<String> myFileTextSupplier;

    public CreateFilePathFix(@NotNull PsiElement psiElement, @NotNull NewFileLocation newFileLocation, @Nullable String fileText, @NotNull String fixLocaleKey) {
        super(psiElement, newFileLocation, fixLocaleKey);
        this.myText = fileText;
        this.myIsAvailable = !FileTypeManager.getInstance().getFileTypeByFileName(this.myNewFileName).isBinary();
        this.myIsAvailableTimeStamp = System.currentTimeMillis();
    }

    public CreateFilePathFix(@NotNull PsiElement psiElement, @NotNull NewFileLocation newFileLocation) {
        this(psiElement, newFileLocation, null, "create.file.text");
    }

    public CreateFilePathFix(@NotNull PsiElement psiElement, @NotNull NewFileLocation newFileLocation, @NotNull Supplier<String> fileTextSupplier) {
        this(psiElement, newFileLocation, null, "create.file.text");
        this.myFileTextSupplier = fileTextSupplier;
    }

    private void createFile(@NotNull Project project, @NotNull PsiDirectory currentDirectory, @NotNull String fileName) throws IncorrectOperationException {
        String newFileName = fileName;
        String newDirectories = null;
        if (fileName.contains("/")) {
            int pos = fileName.lastIndexOf(47);
            newFileName = fileName.substring(pos + 1);
            newDirectories = fileName.substring(0, pos);
        }
        PsiDirectory directory = currentDirectory;
        if (newDirectories != null) {
            try {
                VfsUtil.createDirectoryIfMissing((VirtualFile)currentDirectory.getVirtualFile(), newDirectories);
                VirtualFile vfsDir = VfsUtil.findRelativeFile((VirtualFile)currentDirectory.getVirtualFile(), (String[])ArrayUtilRt.toStringArray((Collection)StringUtil.split((String)newDirectories, (String)"/")));
                if (vfsDir == null) {
                    Logger.getInstance(AbstractCreateFileFix.class).warn("Unable to find relative file" + currentDirectory.getVirtualFile().getPath());
                    return;
                }
                directory = currentDirectory.getManager().findDirectory(vfsDir);
                if (directory == null) {
                    throw new IOException("Couldn't create directory '" + newDirectories + "'");
                }
            }
            catch (IOException e) {
                throw new IncorrectOperationException(e.getMessage());
            }
        }
        PsiFile newFile = directory.createFile(newFileName);
        String text = this.getFileText();
        if (text != null) {
            FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(newFileName);
            PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("_" + newFileName, type, (CharSequence)text);
            PsiElement psiElement = CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
            text = psiElement.getText();
        }
        this.openFile(project, directory, newFile, text);
    }

    protected void openFile(@NotNull Project project, PsiDirectory directory, PsiFile newFile, String text) {
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)directory.getProject());
        FileEditor[] fileEditors = editorManager.openFile(newFile.getVirtualFile(), true);
        if (text != null) {
            for (FileEditor fileEditor : fileEditors) {
                if (!(fileEditor instanceof TextEditor)) continue;
                Document document = ((TextEditor)fileEditor).getEditor().getDocument();
                document.setText((CharSequence)text);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                break;
            }
        }
    }

    @Nullable
    protected String getFileText() {
        if (this.myFileTextSupplier != null) {
            return this.myFileTextSupplier.get();
        }
        return this.myText;
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)this.myKey, (Object[])new Object[]{this.myNewFileName});
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"create.file.family", (Object[])new Object[0]);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        return null;
    }

    @Override
    protected void apply(@NotNull Project project, @NotNull PsiDirectory targetDirectory, @Nullable Editor editor) throws IncorrectOperationException {
        this.createFile(project, targetDirectory, this.myNewFileName);
    }
}

