/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.quickFix.AbstractCreateFileFix;
import com.intellij.codeInsight.daemon.quickFix.NewFileLocation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateDirectoryPathFix
extends AbstractCreateFileFix {
    public CreateDirectoryPathFix(@NotNull PsiElement psiElement, @NotNull NewFileLocation newFileLocation, @NotNull String fixLocaleKey) {
        super(psiElement, newFileLocation, fixLocaleKey);
        this.myIsAvailable = true;
        this.myIsAvailableTimeStamp = System.currentTimeMillis();
    }

    public CreateDirectoryPathFix(@NotNull PsiElement psiElement, @NotNull NewFileLocation newFileLocation) {
        this(psiElement, newFileLocation, "create.directory.text");
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)this.myKey, (Object[])new Object[]{this.myNewFileName});
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"create.directory.family", (Object[])new Object[0]);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        return null;
    }

    @Override
    protected void apply(@NotNull Project project, @NotNull PsiDirectory targetDirectory, @Nullable Editor editor) throws IncorrectOperationException {
        targetDirectory.createSubdirectory(this.myNewFileName);
    }
}

