/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowErrorDescriptionHandler;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.NotNull;

public class ShowErrorDescriptionAction
extends BaseCodeInsightAction
implements DumbAware {
    private boolean myRequestFocus = false;

    public ShowErrorDescriptionAction() {
        this.setEnabledInModalContext(true);
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new ShowErrorDescriptionHandler(this.myRequestFocus);
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        return DaemonCodeAnalyzer.getInstance((Project)project).isHighlightingAvailable(file2) && ShowErrorDescriptionAction.isEnabled(project, editor);
    }

    private static boolean isEnabled(Project project, Editor editor) {
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
        HighlightInfo info = ((DaemonCodeAnalyzerImpl)codeAnalyzer).findHighlightByOffset(editor.getDocument(), editor.getCaretModel().getOffset(), false);
        return info != null && info.getDescription() != null;
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        super.beforeActionPerformedUpdate(e);
        this.myRequestFocus = ScreenReader.isActive() && e.getInputEvent() instanceof KeyEvent;
    }
}

