/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressableTextEditorHighlightingPass
extends TextEditorHighlightingPass {
    private volatile boolean myFinished;
    private volatile long myProgressLimit;
    private final AtomicLong myProgressCount = new AtomicLong();
    private volatile long myNextChunkThreshold;
    private final String myPresentableName;
    protected final PsiFile myFile;
    @Nullable
    private final Editor myEditor;
    @NotNull
    final TextRange myRestrictRange;
    @NotNull
    final HighlightInfoProcessor myHighlightInfoProcessor;
    HighlightingSession myHighlightingSession;

    protected ProgressableTextEditorHighlightingPass(@NotNull Project project, @NotNull Document document, @NotNull String presentableName, @Nullable PsiFile file2, @Nullable Editor editor, @NotNull TextRange restrictRange, boolean runIntentionPassAfter, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        super(project, document, runIntentionPassAfter);
        this.myPresentableName = presentableName;
        this.myFile = file2;
        this.myEditor = editor;
        this.myRestrictRange = restrictRange;
        this.myHighlightInfoProcessor = highlightInfoProcessor;
    }

    @Override
    protected boolean isValid() {
        return super.isValid() && (this.myFile == null || this.myFile.isValid());
    }

    private void sessionFinished() {
        this.advanceProgress(Math.max(1L, this.myProgressLimit - this.myProgressCount.get()));
    }

    @Override
    public final void doCollectInformation(@NotNull ProgressIndicator progress2) {
        GlobalInspectionContextBase.assertUnderDaemonProgress();
        this.myFinished = false;
        if (this.myFile != null) {
            DaemonProgressIndicator daemonProgressIndicator = (DaemonProgressIndicator)ProgressWrapper.unwrapAll(progress2);
            this.myHighlightingSession = HighlightingSessionImpl.getOrCreateHighlightingSession(this.myFile, daemonProgressIndicator, this.getColorsScheme());
        }
        try {
            this.collectInformationWithProgress(progress2);
        }
        finally {
            if (this.myFile != null) {
                this.sessionFinished();
            }
        }
    }

    protected abstract void collectInformationWithProgress(@NotNull ProgressIndicator var1);

    @Override
    public final void doApplyInformationToEditor() {
        this.myFinished = true;
        this.applyInformationWithProgress();
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        daemonCodeAnalyzer.getFileStatusMap().markFileUpToDate(this.myDocument, this.getId());
    }

    protected abstract void applyInformationWithProgress();

    public double getProgress() {
        long progressLimit = this.getProgressLimit();
        if (progressLimit == 0L) {
            return -1.0;
        }
        long progressCount = this.getProgressCount();
        return progressCount > progressLimit ? 1.0 : (double)progressCount / (double)progressLimit;
    }

    private long getProgressLimit() {
        return this.myProgressLimit;
    }

    private long getProgressCount() {
        return this.myProgressCount.get();
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    @Nullable(value="null means do not show progress")
    @Nls
    protected @Nullable(value="null means do not show progress") @Nls String getPresentableName() {
        return this.myPresentableName;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    public void setProgressLimit(long limit) {
        this.myProgressLimit = limit;
        this.myNextChunkThreshold = Math.max(1L, limit / 100L);
    }

    public void advanceProgress(long delta) {
        long current2;
        if (this.myHighlightingSession != null && (current2 = this.myProgressCount.addAndGet(delta)) >= this.myNextChunkThreshold) {
            double progress2 = this.getProgress();
            this.myNextChunkThreshold += Math.max(1L, this.myProgressLimit / 100L);
            this.myHighlightInfoProcessor.progressIsAdvanced(this.myHighlightingSession, this.getEditor(), progress2);
        }
    }

    static class EmptyPass
    extends TextEditorHighlightingPass {
        EmptyPass(@NotNull Project project, @NotNull Document document) {
            super(project, document, false);
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress2) {
        }

        @Override
        public void doApplyInformationToEditor() {
            FileStatusMap statusMap = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap();
            statusMap.markFileUpToDate(this.getDocument(), this.getId());
        }
    }
}

