/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ProblemDescriptorWithReporterName;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.RedundantSuppressInspection;
import com.intellij.codeInspection.RedundantSuppressionDetector;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.PluginException;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalInspectionsPass
extends ProgressableTextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(LocalInspectionsPass.class);
    public static final TextRange EMPTY_PRIORITY_RANGE = TextRange.EMPTY_RANGE;
    private static final Predicate<PsiFile> SHOULD_INSPECT_FILTER = file2 -> HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)file2);
    private final TextRange myPriorityRange;
    private final boolean myIgnoreSuppressed;
    private final ConcurrentMap<PsiFile, List<InspectionResult>> result = new ConcurrentHashMap<PsiFile, List<InspectionResult>>();
    private volatile List<HighlightInfo> myInfos = Collections.emptyList();
    private final String myShortcutText;
    private final SeverityRegistrar mySeverityRegistrar;
    private final InspectionProfileWrapper myProfileWrapper;
    private final Map<String, Set<PsiElement>> mySuppressedElements = new ConcurrentHashMap<String, Set<PsiElement>>();
    private final boolean myInspectInjectedPsi;
    private static final Set<String> ourToolsWithInformationProblems = new HashSet<String>();
    private static final TextAttributes NONEMPTY_TEXT_ATTRIBUTES = new TextAttributes(){

        public boolean isEmpty() {
            return false;
        }
    };
    private final Map<TextRange, RangeMarker> ranges2markersCache = new THashMap();
    private final InjectedLanguageManager ilManager = InjectedLanguageManager.getInstance((Project)this.myProject);
    private final List<HighlightInfo> infos = new ArrayList<HighlightInfo>(2);
    private final PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
    private final Set<Pair<TextRange, String>> emptyActionRegistered = Collections.synchronizedSet(new THashSet());
    private static final Interner<String> tooltips = Interner.createWeakInterner();

    public LocalInspectionsPass(@NotNull PsiFile file2, @NotNull Document document, int startOffset, int endOffset, @NotNull TextRange priorityRange, boolean ignoreSuppressed, @NotNull HighlightInfoProcessor highlightInfoProcessor, boolean inspectInjectedPsi) {
        super(file2.getProject(), document, LocalInspectionsPass.getPresentableNameText(), file2, null, new TextRange(startOffset, endOffset), true, highlightInfoProcessor);
        assert (file2.isPhysical()) : "can't inspect non-physical file: " + file2 + "; " + file2.getVirtualFile();
        this.myPriorityRange = priorityRange;
        this.myIgnoreSuppressed = ignoreSuppressed;
        this.setId(7);
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 != null) {
            Keymap keymap2 = keymapManager2.getActiveKeymap();
            this.myShortcutText = "(" + KeymapUtil.getShortcutsText((Shortcut[])keymap2.getShortcuts("ShowErrorDescription")) + ")";
        } else {
            this.myShortcutText = "";
        }
        InspectionProfileImpl profileToUse = ProjectInspectionProfileManager.getInstance(this.myProject).getCurrentProfile();
        Function custom = (Function)file2.getUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY);
        InspectionProfileWrapper inspectionProfileWrapper = this.myProfileWrapper = custom == null ? new InspectionProfileWrapper(profileToUse) : (InspectionProfileWrapper)custom.apply(profileToUse);
        assert (this.myProfileWrapper != null);
        this.mySeverityRegistrar = this.myProfileWrapper.getProfileManager().getSeverityRegistrar();
        this.myInspectInjectedPsi = inspectInjectedPsi;
        this.setProgressLimit(600L);
    }

    @NotNull
    private PsiFile getFile() {
        return this.myFile;
    }

    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress2) {
        try {
            if (!HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)this.getFile())) {
                return;
            }
            this.inspect(this.getInspectionTools(this.myProfileWrapper), InspectionManager.getInstance((Project)this.myProject), true, progress2);
        }
        finally {
            this.disposeDescriptors();
        }
    }

    private void disposeDescriptors() {
        this.result.clear();
    }

    public void doInspectInBatch(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionManager iManager, @NotNull List<? extends LocalInspectionToolWrapper> toolWrappers) {
        ProgressIndicator progress2 = ProgressManager.getInstance().getProgressIndicator();
        this.inspect(new ArrayList<LocalInspectionToolWrapper>(toolWrappers), iManager, false, progress2);
        this.addDescriptorsFromInjectedResults(context);
        List resultList = (List)this.result.get(this.getFile());
        if (resultList == null) {
            return;
        }
        for (InspectionResult inspectionResult : resultList) {
            LocalInspectionToolWrapper toolWrapper = inspectionResult.tool;
            String shortName = toolWrapper.getShortName();
            for (ProblemDescriptor descriptor2 : inspectionResult.foundProblems) {
                if (descriptor2.getHighlightType() == ProblemHighlightType.INFORMATION) {
                    if (!ourToolsWithInformationProblems.add(shortName)) continue;
                    LOG.error("Tool #" + shortName + " registers INFORMATION level problem in batch mode on " + this.getFile() + ". INFORMATION level 'warnings' are invisible in the editor and should not become visible in batch mode. Moreover, cause INFORMATION level fixes act more like intention actions, they could e.g. change semantics and thus should not be suggested for batch transformations");
                    continue;
                }
                this.addDescriptors(toolWrapper, descriptor2, context);
            }
        }
    }

    private void addDescriptors(@NotNull LocalInspectionToolWrapper toolWrapper, @NotNull ProblemDescriptor descriptor2, @NotNull GlobalInspectionContextImpl context) {
        InspectionToolPresentation toolPresentation = context.getPresentation(toolWrapper);
        BatchModeDescriptorsUtil.addProblemDescriptors(Collections.singletonList(descriptor2), toolPresentation, this.myIgnoreSuppressed, context, (LocalInspectionTool)toolWrapper.getTool());
    }

    private void addDescriptorsFromInjectedResults(@NotNull GlobalInspectionContextImpl context) {
        for (Map.Entry entry : this.result.entrySet()) {
            PsiFile file2 = (PsiFile)entry.getKey();
            if (file2 == this.getFile()) continue;
            List resultList = (List)entry.getValue();
            for (InspectionResult inspectionResult : resultList) {
                LocalInspectionToolWrapper toolWrapper = inspectionResult.tool;
                for (ProblemDescriptor descriptor2 : inspectionResult.foundProblems) {
                    PsiElement psiElement = descriptor2.getPsiElement();
                    if (psiElement == null || ((LocalInspectionTool)toolWrapper.getTool()).isSuppressedFor(psiElement)) continue;
                    this.addDescriptors(toolWrapper, descriptor2, context);
                }
            }
        }
    }

    private void inspect(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator progress2) {
        if (toolWrappers.isEmpty()) {
            return;
        }
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(this.myFile, this.myRestrictRange, this.myPriorityRange, SHOULD_INSPECT_FILTER, (Processor<? super Divider.DividedElements>)new CommonProcessors.CollectProcessor(allDivided));
        List inside = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> d.inside));
        List outside = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> ContainerUtil.concat(d.outside, d.parents)));
        this.setProgressLimit((long)toolWrappers.size() * 2L);
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(this.getFile(), this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset());
        List<InspectionContext> init2 = this.visitPriorityElementsAndInit(InspectionEngine.filterToolsApplicableByLanguage(toolWrappers, InspectionEngine.calcElementDialectIds(inside, outside)), iManager, isOnTheFly, progress2, inside, session2);
        Set<PsiFile> alreadyVisitedInjected = this.inspectInjectedPsi(inside, isOnTheFly, progress2, iManager, true, toolWrappers, Collections.emptySet());
        this.visitRestElementsAndCleanup(progress2, outside, session2, init2);
        this.inspectInjectedPsi(outside, isOnTheFly, progress2, iManager, false, toolWrappers, alreadyVisitedInjected);
        ProgressManager.checkCanceled();
        this.myInfos = new ArrayList<HighlightInfo>();
        this.addHighlightsFromResults(this.myInfos);
        if (isOnTheFly) {
            this.highlightRedundantSuppressions(toolWrappers, iManager, inside, outside);
        }
    }

    private void highlightRedundantSuppressions(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull InspectionManager iManager, @NotNull List<? extends PsiElement> inside, @NotNull List<? extends PsiElement> outside) {
        HighlightDisplayKey key = HighlightDisplayKey.find((String)"RedundantSuppression");
        InspectionProfile inspectionProfile = this.myProfileWrapper.getInspectionProfile();
        if (key != null && inspectionProfile.isToolEnabled(key, (PsiElement)this.getFile())) {
            InspectionToolWrapper toolWrapper = inspectionProfile.getInspectionTool("RedundantSuppression", (PsiElement)this.getFile());
            Language fileLanguage = this.getFile().getLanguage();
            InspectionSuppressor suppressor = (InspectionSuppressor)LanguageInspectionSuppressors.INSTANCE.forLanguage(fileLanguage);
            if (suppressor instanceof RedundantSuppressionDetector) {
                if (toolWrappers.stream().anyMatch(LocalInspectionToolWrapper::runForWholeFile)) {
                    return;
                }
                HashSet<String> activeTools = new HashSet<String>();
                for (LocalInspectionToolWrapper localInspectionToolWrapper : toolWrappers) {
                    if (localInspectionToolWrapper.isUnfair() || !localInspectionToolWrapper.isApplicable(fileLanguage)) continue;
                    activeTools.add(localInspectionToolWrapper.getID());
                    ContainerUtil.addIfNotNull(activeTools, (Object)localInspectionToolWrapper.getAlternativeID());
                    InspectionElementsMerger elementsMerger = InspectionElementsMerger.getMerger((String)localInspectionToolWrapper.getShortName());
                    if (elementsMerger == null) continue;
                    activeTools.addAll(Arrays.asList(elementsMerger.getSuppressIds()));
                }
                LocalInspectionTool localTool = ((RedundantSuppressInspection)toolWrapper.getTool()).createLocalTool((RedundantSuppressionDetector)suppressor, this.mySuppressedElements, activeTools);
                ProblemsHolder problemsHolder = new ProblemsHolder(iManager, this.getFile(), true);
                PsiElementVisitor visitor = localTool.buildVisitor(problemsHolder, true);
                InspectionEngine.acceptElements(inside, visitor);
                InspectionEngine.acceptElements(outside, visitor);
                HighlightSeverity severity = this.myProfileWrapper.getErrorLevel(key, (PsiElement)this.getFile()).getSeverity();
                for (ProblemDescriptor descriptor2 : problemsHolder.getResults()) {
                    ProgressManager.checkCanceled();
                    PsiElement element2 = descriptor2.getPsiElement();
                    if (element2 == null) continue;
                    Document thisDocument = this.documentManager.getDocument(this.getFile());
                    this.createHighlightsForDescriptor(this.myInfos, this.emptyActionRegistered, this.ilManager, this.getFile(), thisDocument, new LocalInspectionToolWrapper(localTool), severity, descriptor2, element2, false);
                }
            }
        }
    }

    @NotNull
    private List<InspectionContext> visitPriorityElementsAndInit(@NotNull List<? extends LocalInspectionToolWrapper> wrappers, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator, @NotNull List<? extends PsiElement> elements2, @NotNull LocalInspectionToolSession session2) {
        ArrayList<InspectionContext> init2 = new ArrayList<InspectionContext>();
        PsiFile file2 = session2.getFile();
        Processor processor2 = toolWrapper -> (Boolean)AstLoadingFilter.disallowTreeLoading(() -> (Boolean)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file2, () -> {
            this.runToolOnElements((LocalInspectionToolWrapper)((Object)toolWrapper), iManager, isOnTheFly, indicator, elements2, session2, (List<? super InspectionContext>)init2);
            return true;
        }));
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(wrappers, indicator, processor2)) {
            throw new ProcessCanceledException();
        }
        return init2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runToolOnElements(final @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull InspectionManager iManager, boolean isOnTheFly, final @NotNull ProgressIndicator indicator, @NotNull List<? extends PsiElement> elements2, @NotNull LocalInspectionToolSession session2, @NotNull List<? super InspectionContext> init2) {
        ProgressManager.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LocalInspectionTool tool = (LocalInspectionTool)toolWrapper.getTool();
        final boolean[] applyIncrementally = new boolean[]{isOnTheFly};
        ProblemsHolder holder = new ProblemsHolder(iManager, this.getFile(), isOnTheFly){

            public void registerProblem(@NotNull ProblemDescriptor descriptor2) {
                super.registerProblem(descriptor2);
                if (applyIncrementally[0]) {
                    LocalInspectionsPass.this.addDescriptorIncrementally(descriptor2, toolWrapper, indicator);
                }
            }
        };
        PsiElementVisitor visitor = InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, session2, elements2);
        if (visitor != PsiElementVisitor.EMPTY_VISITOR) {
            List<? super InspectionContext> list2 = init2;
            synchronized (list2) {
                init2.add(new InspectionContext(toolWrapper, holder, holder.getResultCount(), visitor));
            }
        }
        this.advanceProgress(1L);
        if (holder.hasResults()) {
            this.appendDescriptors(this.getFile(), holder.getResults(), toolWrapper);
        }
        applyIncrementally[0] = false;
    }

    private void visitRestElementsAndCleanup(@NotNull ProgressIndicator indicator, @NotNull List<? extends PsiElement> elements2, @NotNull LocalInspectionToolSession session2, @NotNull List<? extends InspectionContext> init2) {
        Processor processor2 = context -> {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().assertReadAccessAllowed();
            AstLoadingFilter.disallowTreeLoading(() -> InspectionEngine.acceptElements(elements2, ((InspectionContext)context).visitor));
            this.advanceProgress(1L);
            ((LocalInspectionTool)((InspectionContext)context).tool.getTool()).inspectionFinished(session2, ((InspectionContext)context).holder);
            if (((InspectionContext)context).holder.hasResults()) {
                List allProblems = ((InspectionContext)context).holder.getResults();
                List restProblems = allProblems.subList(((InspectionContext)context).problemsSize, allProblems.size());
                this.appendDescriptors(this.getFile(), restProblems, ((InspectionContext)context).tool);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(init2, indicator, processor2)) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    private Set<PsiFile> inspectInjectedPsi(@NotNull List<? extends PsiElement> elements2, boolean onTheFly, @NotNull ProgressIndicator indicator, @NotNull InspectionManager iManager, boolean inVisibleRange, @NotNull List<? extends LocalInspectionToolWrapper> wrappers, @NotNull Set<? extends PsiFile> alreadyVisitedInjected) {
        if (!this.myInspectInjectedPsi) {
            return Collections.emptySet();
        }
        THashSet injected = new THashSet();
        for (PsiElement psiElement : elements2) {
            PsiFile containingFile = this.getFile();
            InjectedLanguageManager.getInstance((Project)containingFile.getProject()).enumerateEx(psiElement, containingFile, false, (arg_0, arg_1) -> LocalInspectionsPass.lambda$inspectInjectedPsi$8((Set)injected, arg_0, arg_1));
        }
        injected.removeAll(alreadyVisitedInjected);
        if (!injected.isEmpty()) {
            Processor processor2 = injectedPsi -> {
                this.doInspectInjectedPsi((PsiFile)injectedPsi, onTheFly, indicator, iManager, inVisibleRange, wrappers);
                return true;
            };
            if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(injected), indicator, processor2)) {
                throw new ProcessCanceledException();
            }
        }
        return injected;
    }

    @Nullable
    private HighlightInfo highlightInfoFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightInfoType highlightInfoType, @NotNull String message, @Nullable String toolTip, @NotNull PsiElement psiElement, @NotNull List<IntentionAction> quickFixes, @NotNull String toolID) {
        TextRange textRange = ((ProblemDescriptorBase)problemDescriptor).getTextRange();
        if (textRange == null) {
            return null;
        }
        boolean isFileLevel = psiElement instanceof PsiFile && textRange.equals((Object)psiElement.getTextRange());
        HighlightSeverity severity = highlightInfoType.getSeverity(psiElement);
        TextAttributesKey attributesKey = ((ProblemDescriptorBase)problemDescriptor).getEnforcedTextAttributes();
        TextAttributes attributes = attributesKey == null || this.getColorsScheme() == null ? this.mySeverityRegistrar.getTextAttributesBySeverity(severity) : this.getColorsScheme().getAttributes(attributesKey);
        HighlightInfo.Builder b = HighlightInfo.newHighlightInfo(highlightInfoType).range(psiElement, textRange.getStartOffset(), textRange.getEndOffset()).description(message).severity(severity).inspectionToolId(toolID);
        if (toolTip != null) {
            b.escapedToolTip(toolTip);
        }
        if (HighlightSeverity.INFORMATION.equals((Object)severity) && attributes == null && toolTip == null && !quickFixes.isEmpty()) {
            attributes = NONEMPTY_TEXT_ATTRIBUTES;
        }
        if (attributes != null) {
            b.textAttributes(attributes);
        }
        if (problemDescriptor.isAfterEndOfLine()) {
            b.endOfLine();
        }
        if (isFileLevel) {
            b.fileLevelAnnotation();
        }
        if (problemDescriptor.getProblemGroup() != null) {
            b.problemGroup(problemDescriptor.getProblemGroup());
        }
        return b.create();
    }

    private void addDescriptorIncrementally(@NotNull ProblemDescriptor descriptor2, @NotNull LocalInspectionToolWrapper tool, @NotNull ProgressIndicator indicator) {
        if (this.myIgnoreSuppressed) {
            LocalInspectionToolWrapper toolWrapper = tool;
            PsiElement psiElement = descriptor2.getPsiElement();
            if (descriptor2 instanceof ProblemDescriptorWithReporterName) {
                String reportingToolName = ((ProblemDescriptorWithReporterName)descriptor2).getReportingToolName();
                toolWrapper = (LocalInspectionToolWrapper)this.myProfileWrapper.getInspectionTool(reportingToolName, psiElement);
            }
            if (((LocalInspectionTool)toolWrapper.getTool()).isSuppressedFor(psiElement)) {
                this.registerSuppressedElements(psiElement, toolWrapper.getID(), toolWrapper.getAlternativeID());
                return;
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            PsiElement psiElement = descriptor2.getPsiElement();
            if (psiElement == null) {
                return;
            }
            PsiFile file2 = psiElement.getContainingFile();
            Document thisDocument = this.documentManager.getDocument(file2);
            HighlightSeverity severity = this.myProfileWrapper.getErrorLevel(tool.getDisplayKey(), (PsiElement)file2).getSeverity();
            this.infos.clear();
            this.createHighlightsForDescriptor(this.infos, this.emptyActionRegistered, this.ilManager, file2, thisDocument, tool, severity, descriptor2, psiElement);
            for (HighlightInfo info : this.infos) {
                EditorColorsScheme colorsScheme = this.getColorsScheme();
                UpdateHighlightersUtil.addHighlighterToEditorIncrementally(this.myProject, this.myDocument, this.getFile(), this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), info, colorsScheme, this.getId(), this.ranges2markersCache);
            }
        }, __ -> this.myProject.isDisposed() || indicator.isCanceled());
    }

    private void appendDescriptors(@NotNull PsiFile file2, @NotNull List<? extends ProblemDescriptor> descriptors, @NotNull LocalInspectionToolWrapper tool) {
        for (ProblemDescriptor problemDescriptor : descriptors) {
            if (problemDescriptor != null) continue;
            LOG.error("null descriptor. all descriptors(" + descriptors.size() + "): " + descriptors + "; file: " + file2 + " (" + file2.getVirtualFile() + "); tool: " + (Object)((Object)tool));
        }
        InspectionResult result2 = new InspectionResult(tool, descriptors);
        this.appendResult(file2, result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendResult(@NotNull PsiFile file2, @NotNull InspectionResult result2) {
        List resultList = (List)this.result.get(file2);
        if (resultList == null) {
            resultList = (List)ConcurrencyUtil.cacheOrGet(this.result, (Object)file2, new ArrayList());
        }
        List list2 = resultList;
        synchronized (list2) {
            resultList.add(result2);
        }
    }

    @Override
    protected void applyInformationWithProgress() {
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), this.myInfos, this.getColorsScheme(), this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHighlightsFromResults(@NotNull List<? super HighlightInfo> outInfos) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        InjectedLanguageManager ilManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        THashSet emptyActionRegistered = new THashSet();
        for (Map.Entry entry : this.result.entrySet()) {
            List resultList;
            ProgressManager.checkCanceled();
            PsiFile file2 = (PsiFile)entry.getKey();
            Document documentRange = documentManager.getDocument(file2);
            if (documentRange == null) continue;
            List list2 = resultList = (List)entry.getValue();
            synchronized (list2) {
                for (InspectionResult inspectionResult : resultList) {
                    ProgressManager.checkCanceled();
                    LocalInspectionToolWrapper tool = inspectionResult.tool;
                    HighlightSeverity severity = this.myProfileWrapper.getErrorLevel(tool.getDisplayKey(), (PsiElement)file2).getSeverity();
                    for (ProblemDescriptor descriptor2 : inspectionResult.foundProblems) {
                        ProgressManager.checkCanceled();
                        PsiElement element2 = descriptor2.getPsiElement();
                        if (element2 == null) continue;
                        this.createHighlightsForDescriptor(outInfos, (Set<? super Pair<TextRange, String>>)emptyActionRegistered, ilManager, file2, documentRange, tool, severity, descriptor2, element2, this.myIgnoreSuppressed);
                    }
                }
            }
        }
    }

    private void createHighlightsForDescriptor(@NotNull List<? super HighlightInfo> outInfos, @NotNull Set<? super Pair<TextRange, String>> emptyActionRegistered, @NotNull InjectedLanguageManager ilManager, @NotNull PsiFile file2, @NotNull Document documentRange, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull HighlightSeverity severity, @NotNull ProblemDescriptor descriptor2, @NotNull PsiElement element2, boolean ignoreSuppressed) {
        if (descriptor2 instanceof ProblemDescriptorWithReporterName) {
            String reportingToolName = ((ProblemDescriptorWithReporterName)descriptor2).getReportingToolName();
            InspectionToolWrapper<?, ?> reportingTool = this.myProfileWrapper.getInspectionTool(reportingToolName, element2);
            LOG.assertTrue(reportingTool instanceof LocalInspectionToolWrapper, (Object)reportingToolName);
            toolWrapper = (LocalInspectionToolWrapper)reportingTool;
            severity = this.myProfileWrapper.getErrorLevel(HighlightDisplayKey.find((String)reportingToolName), (PsiElement)file2).getSeverity();
        }
        LocalInspectionTool tool = (LocalInspectionTool)toolWrapper.getTool();
        if (ignoreSuppressed && tool.isSuppressedFor(element2)) {
            this.registerSuppressedElements(element2, toolWrapper.getID(), toolWrapper.getAlternativeID());
            return;
        }
        this.createHighlightsForDescriptor(outInfos, emptyActionRegistered, ilManager, file2, documentRange, toolWrapper, severity, descriptor2, element2);
    }

    private void createHighlightsForDescriptor(@NotNull List<? super HighlightInfo> outInfos, @NotNull Set<? super Pair<TextRange, String>> emptyActionRegistered, @NotNull InjectedLanguageManager ilManager, @NotNull PsiFile file2, @NotNull Document documentRange, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull HighlightSeverity severity, @NotNull ProblemDescriptor descriptor2, @NotNull PsiElement element2) {
        boolean isOutsideInjected;
        List<IntentionAction> fixes;
        HighlightInfo info;
        HighlightInfoType level = ProblemDescriptorUtil.highlightTypeFromDescriptor(descriptor2, severity, this.mySeverityRegistrar);
        String message = ProblemDescriptorUtil.renderDescriptionMessage((CommonProblemDescriptor)descriptor2, element2);
        ProblemGroup problemGroup = descriptor2.getProblemGroup();
        String problemName = problemGroup != null ? problemGroup.getProblemName() : null;
        String shortName = problemName != null ? problemName : toolWrapper.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        InspectionProfile inspectionProfile = this.myProfileWrapper.getInspectionProfile();
        if (!inspectionProfile.isToolEnabled(key, (PsiElement)this.getFile())) {
            return;
        }
        InspectionHighlightInfoType type = new InspectionHighlightInfoType(level, element2);
        String plainMessage = message.startsWith("<html>") ? StringUtil.unescapeXmlEntities((String)XmlStringUtil.stripHtml((String)message).replaceAll("<[^>]*>", "")) : message;
        String link = "";
        if (LocalInspectionsPass.showToolDescription(toolWrapper)) {
            link = " <a href=\"#inspection/" + shortName + "\"" + (StartupUiUtil.isUnderDarcula() ? " color=\"7AB4C9\" " : "") + ">" + DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]) + "</a> " + this.myShortcutText;
        }
        String tooltip = null;
        if (descriptor2.showTooltip()) {
            tooltip = (String)tooltips.intern((Object)XmlStringUtil.wrapInHtml((CharSequence)((message.startsWith("<html>") ? XmlStringUtil.stripHtml((String)message) : XmlStringUtil.escapeString((String)message)) + link)));
        }
        if ((info = this.highlightInfoFromDescriptor(descriptor2, type, plainMessage, tooltip, element2, fixes = LocalInspectionsPass.getQuickFixes(key, descriptor2, emptyActionRegistered), key.getID())) == null) {
            return;
        }
        LocalInspectionsPass.registerQuickFixes(info, fixes, shortName);
        PsiFile context = this.getTopLevelFileInBaseLanguage(element2);
        PsiFile myContext = this.getTopLevelFileInBaseLanguage((PsiElement)this.getFile());
        if (context != this.getFile()) {
            String errorMessage = "Reported element " + element2 + " is not from the file '" + file2.getVirtualFile().getPath() + "' the inspection '" + shortName + "' (" + ((LocalInspectionTool)toolWrapper.getTool()).getClass() + ") was invoked for. Message: '" + descriptor2 + "'.\nElement containing file: " + context + "\nInspection invoked for file: " + myContext + "\n";
            PluginException.logPluginError((Logger)LOG, (String)errorMessage, null, ((LocalInspectionTool)toolWrapper.getTool()).getClass());
        }
        boolean bl = isOutsideInjected = !this.myInspectInjectedPsi || file2 == this.getFile();
        if (isOutsideInjected) {
            outInfos.add(info);
            return;
        }
        LocalInspectionsPass.injectToHost(outInfos, ilManager, file2, documentRange, element2, fixes, info, shortName);
    }

    private void registerSuppressedElements(@NotNull PsiElement element2, String id2, String alternativeID) {
        this.mySuppressedElements.computeIfAbsent(id2, shortName -> new HashSet()).add(element2);
        if (alternativeID != null) {
            this.mySuppressedElements.computeIfAbsent(alternativeID, shortName -> new HashSet()).add(element2);
        }
    }

    private static void injectToHost(@NotNull List<? super HighlightInfo> outInfos, @NotNull InjectedLanguageManager ilManager, @NotNull PsiFile file2, @NotNull Document documentRange, @NotNull PsiElement element2, @NotNull List<? extends IntentionAction> fixes, @NotNull HighlightInfo info, String shortName) {
        List editables = ilManager.intersectWithAllEditableFragments(file2, new TextRange(info.startOffset, info.endOffset));
        for (TextRange editable : editables) {
            String toolTip;
            TextRange hostRange = ((DocumentWindow)documentRange).injectedToHost(editable);
            int start2 = hostRange.getStartOffset();
            int end = hostRange.getEndOffset();
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(info.type).range(element2, start2, end);
            String description = info.getDescription();
            if (description != null) {
                builder2.description(description);
            }
            if ((toolTip = info.getToolTip()) != null) {
                builder2.escapedToolTip(toolTip);
            }
            HighlightInfo patched = builder2.createUnconditionally();
            if (patched.startOffset == patched.endOffset && info.startOffset != info.endOffset) continue;
            patched.setFromInjection(true);
            LocalInspectionsPass.registerQuickFixes(patched, fixes, shortName);
            outInfos.add(patched);
        }
    }

    private PsiFile getTopLevelFileInBaseLanguage(@NotNull PsiElement element2) {
        PsiFile file2 = InjectedLanguageManager.getInstance((Project)this.myProject).getTopLevelFile(element2);
        FileViewProvider viewProvider = file2.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    private static boolean showToolDescription(@NotNull LocalInspectionToolWrapper tool) {
        String staticDescription = tool.getStaticDescription();
        return staticDescription == null || !staticDescription.isEmpty();
    }

    private static void registerQuickFixes(@NotNull HighlightInfo highlightInfo, @NotNull List<? extends IntentionAction> quickFixes, String shortName) {
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        for (IntentionAction intentionAction : quickFixes) {
            QuickFixAction.registerQuickFixAction(highlightInfo, intentionAction, key);
        }
    }

    @NotNull
    private static List<IntentionAction> getQuickFixes(@NotNull HighlightDisplayKey key, @NotNull ProblemDescriptor descriptor2, @NotNull Set<? super Pair<TextRange, String>> emptyActionRegistered) {
        HintAction hintAction;
        SmartList result2 = new SmartList();
        boolean needEmptyAction = true;
        Object[] fixes = descriptor2.getFixes();
        if (fixes != null && fixes.length != 0) {
            for (int k = 0; k < fixes.length; ++k) {
                QuickFix fix = fixes[k];
                if (fix == null) {
                    throw new IllegalStateException("Inspection " + key + " returns null quick fix in its descriptor: " + descriptor2 + "; array: " + Arrays.toString(fixes));
                }
                result2.add(QuickFixWrapper.wrap(descriptor2, k));
                needEmptyAction = false;
            }
        }
        HintAction hintAction2 = hintAction = descriptor2 instanceof ProblemDescriptorImpl ? ((ProblemDescriptorImpl)descriptor2).getHintAction() : null;
        if (hintAction != null) {
            result2.add(hintAction);
            needEmptyAction = false;
        }
        if (((ProblemDescriptorBase)descriptor2).getEnforcedTextAttributes() != null) {
            needEmptyAction = false;
        }
        if (needEmptyAction && emptyActionRegistered.add((Pair<TextRange, String>)Pair.create((Object)((ProblemDescriptorBase)descriptor2).getTextRange(), (Object)key.toString()))) {
            String displayNameByKey = HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)key);
            LOG.assertTrue(displayNameByKey != null, (Object)key.toString());
            EmptyIntentionAction emptyIntentionAction = new EmptyIntentionAction(displayNameByKey);
            result2.add(emptyIntentionAction);
        }
        return result2;
    }

    private static void getElementsAndDialectsFrom(@NotNull PsiFile file2, final @NotNull List<? super PsiElement> outElements, @NotNull Set<? super String> outDialects) {
        FileViewProvider viewProvider = file2.getViewProvider();
        SmartHashSet processedLanguages = new SmartHashSet();
        PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor((Set)processedLanguages, outDialects){
            final /* synthetic */ Set val$processedLanguages;
            final /* synthetic */ Set val$outDialects;
            {
                this.val$processedLanguages = set;
                this.val$outDialects = set2;
            }

            public void visitElement(@NotNull PsiElement element2) {
                ProgressManager.checkCanceled();
                for (PsiElement child2 = element2.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
                    outElements.add(child2);
                    child2.accept((PsiElementVisitor)this);
                    LocalInspectionsPass.appendDialects(child2, this.val$processedLanguages, this.val$outDialects);
                }
            }
        };
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (psiRoot == null || !HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect((PsiElement)psiRoot)) continue;
            outElements.add((PsiElement)psiRoot);
            psiRoot.accept((PsiElementVisitor)visitor);
            LocalInspectionsPass.appendDialects((PsiElement)psiRoot, (Set<? super Language>)processedLanguages, outDialects);
        }
    }

    private static void appendDialects(@NotNull PsiElement element2, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        Language language = element2.getLanguage();
        outDialectIds.add(language.getID());
        if (outProcessedLanguages.add((Language)language)) {
            for (Language dialect : language.getDialects()) {
                outDialectIds.add(dialect.getID());
            }
        }
    }

    @NotNull
    List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile) {
        List toolWrappers = profile.getInspectionProfile().getInspectionTools((PsiElement)this.getFile());
        InspectionProfileWrapper.checkInspectionsDuplicates(toolWrappers);
        ArrayList<LocalInspectionToolWrapper> enabled = new ArrayList<LocalInspectionToolWrapper>();
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            LocalInspectionToolWrapper wrapper2;
            HighlightDisplayKey key;
            ProgressManager.checkCanceled();
            if (toolWrapper instanceof LocalInspectionToolWrapper && !this.isAcceptableLocalTool((LocalInspectionToolWrapper)toolWrapper) || !profile.isToolEnabled(key = toolWrapper.getDisplayKey(), (PsiElement)this.getFile()) || HighlightDisplayLevel.DO_NOT_SHOW.equals(profile.getErrorLevel(key, (PsiElement)this.getFile()))) continue;
            if (toolWrapper instanceof LocalInspectionToolWrapper) {
                wrapper2 = (LocalInspectionToolWrapper)toolWrapper;
            } else {
                wrapper2 = ((GlobalInspectionToolWrapper)toolWrapper).getSharedLocalInspectionToolWrapper();
                if (wrapper2 == null || !this.isAcceptableLocalTool(wrapper2)) continue;
            }
            String language = wrapper2.getLanguage();
            if (language != null && Language.findLanguageByID((String)language) == null || this.myIgnoreSuppressed && ((LocalInspectionTool)wrapper2.getTool()).isSuppressedFor((PsiElement)this.getFile())) continue;
            enabled.add(wrapper2);
        }
        return enabled;
    }

    protected boolean isAcceptableLocalTool(@NotNull LocalInspectionToolWrapper wrapper2) {
        return true;
    }

    private void doInspectInjectedPsi(@NotNull PsiFile injectedPsi, boolean isOnTheFly, @NotNull ProgressIndicator indicator, @NotNull InspectionManager iManager, boolean inVisibleRange, @NotNull List<? extends LocalInspectionToolWrapper> wrappers) {
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)injectedPsi.getProject()).getInjectionHost((PsiElement)injectedPsi);
        ArrayList elements2 = new ArrayList();
        SmartHashSet elementDialectIds = new SmartHashSet();
        LocalInspectionsPass.getElementsAndDialectsFrom(injectedPsi, elements2, (Set<? super String>)elementDialectIds);
        if (elements2.isEmpty()) {
            return;
        }
        List<LocalInspectionToolWrapper> applicableTools = InspectionEngine.filterToolsApplicableByLanguage(wrappers, (Set<String>)elementDialectIds);
        for (LocalInspectionToolWrapper wrapper2 : applicableTools) {
            ProgressManager.checkCanceled();
            LocalInspectionTool tool = (LocalInspectionTool)wrapper2.getTool();
            ProblemsHolder holder = new ProblemsHolder(iManager, injectedPsi, isOnTheFly, (PsiElement)host, tool, wrapper2, isOnTheFly, inVisibleRange, indicator){
                final /* synthetic */ PsiElement val$host;
                final /* synthetic */ LocalInspectionTool val$tool;
                final /* synthetic */ LocalInspectionToolWrapper val$wrapper;
                final /* synthetic */ boolean val$isOnTheFly;
                final /* synthetic */ boolean val$inVisibleRange;
                final /* synthetic */ ProgressIndicator val$indicator;
                {
                    this.val$host = psiElement;
                    this.val$tool = localInspectionTool;
                    this.val$wrapper = localInspectionToolWrapper;
                    this.val$isOnTheFly = bl;
                    this.val$inVisibleRange = bl2;
                    this.val$indicator = progressIndicator2;
                    super(x0, x1, x2);
                }

                public void registerProblem(@NotNull ProblemDescriptor descriptor2) {
                    if (this.val$host != null && LocalInspectionsPass.this.myIgnoreSuppressed && this.val$tool.isSuppressedFor(this.val$host)) {
                        LocalInspectionsPass.this.registerSuppressedElements(this.val$host, this.val$wrapper.getID(), this.val$wrapper.getAlternativeID());
                        return;
                    }
                    super.registerProblem(descriptor2);
                    if (this.val$isOnTheFly && this.val$inVisibleRange) {
                        LocalInspectionsPass.this.addDescriptorIncrementally(descriptor2, this.val$wrapper, this.val$indicator);
                    }
                }
            };
            LocalInspectionToolSession injSession = new LocalInspectionToolSession(injectedPsi, 0, injectedPsi.getTextLength());
            InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, injSession, elements2);
            tool.inspectionFinished(injSession, holder);
            List problems2 = holder.getResults();
            if (problems2.isEmpty()) continue;
            this.appendDescriptors(injectedPsi, problems2, wrapper2);
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        return this.myInfos;
    }

    private static String getPresentableNameText() {
        return DaemonBundle.message((String)"pass.inspection", (Object[])new Object[0]);
    }

    private static /* synthetic */ void lambda$inspectInjectedPsi$8(Set injected, PsiFile injectedPsi, List places) {
        injected.add(injectedPsi);
    }

    public static class InspectionHighlightInfoType
    extends HighlightInfoType.HighlightInfoTypeImpl {
        InspectionHighlightInfoType(@NotNull HighlightInfoType level, @NotNull PsiElement element2) {
            super(level.getSeverity(element2), level.getAttributesKey());
        }
    }

    private static class InspectionContext {
        @NotNull
        private final LocalInspectionToolWrapper tool;
        @NotNull
        private final ProblemsHolder holder;
        private final int problemsSize;
        @NotNull
        private final PsiElementVisitor visitor;

        private InspectionContext(@NotNull LocalInspectionToolWrapper tool, @NotNull ProblemsHolder holder, int problemsSize, @NotNull PsiElementVisitor visitor) {
            this.tool = tool;
            this.holder = holder;
            this.problemsSize = problemsSize;
            this.visitor = visitor;
        }
    }

    private static class InspectionResult {
        @NotNull
        private final LocalInspectionToolWrapper tool;
        @NotNull
        private final List<? extends ProblemDescriptor> foundProblems;

        private InspectionResult(@NotNull LocalInspectionToolWrapper tool, @NotNull List<? extends ProblemDescriptor> foundProblems) {
            this.tool = tool;
            this.foundProblems = new ArrayList<ProblemDescriptor>(foundProblems);
        }
    }
}

