/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.analytics.AndroidStudioAnalytics;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightRangeExtension;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.search.PsiTodoSearchHelperImpl;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.NotNullProducer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.Stack;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralHighlightingPass
extends ProgressableTextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(GeneralHighlightingPass.class);
    private static final Key<Boolean> HAS_ERROR_ELEMENT = Key.create((String)"HAS_ERROR_ELEMENT");
    static final Predicate<PsiFile> SHOULD_HIGHLIGHT_FILTER = file2 -> HighlightingLevelManager.getInstance(file2.getProject()).shouldHighlight((PsiElement)file2);
    private static final Random RESTART_DAEMON_RANDOM = new Random();
    final boolean myUpdateAll;
    final ProperTextRange myPriorityRange;
    final List<HighlightInfo> myHighlights = new ArrayList<HighlightInfo>();
    protected volatile boolean myHasErrorElement;
    private volatile boolean myErrorFound;
    final EditorColorsScheme myGlobalScheme;
    private volatile NotNullProducer<HighlightVisitor[]> myHighlightVisitorProducer = this::cloneHighlightVisitors;
    private static final Key<AtomicInteger> HIGHLIGHT_VISITOR_INSTANCE_COUNT = new Key("HIGHLIGHT_VISITOR_INSTANCE_COUNT");
    public static final int POST_UPDATE_ALL = 5;
    private static final AtomicInteger RESTART_REQUESTS = new AtomicInteger();

    public GeneralHighlightingPass(@NotNull Project project, @NotNull PsiFile file2, @NotNull Document document, int startOffset, int endOffset, boolean updateAll, @NotNull ProperTextRange priorityRange, @Nullable Editor editor, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        super(project, document, GeneralHighlightingPass.getPresentableNameText(), file2, editor, TextRange.create((int)startOffset, (int)endOffset), true, highlightInfoProcessor);
        this.myUpdateAll = updateAll;
        this.myPriorityRange = priorityRange;
        PsiUtilCore.ensureValid((PsiElement)file2);
        boolean wholeFileHighlighting = this.isWholeFileHighlighting();
        this.myHasErrorElement = !wholeFileHighlighting && Boolean.TRUE.equals(this.getFile().getUserData(HAS_ERROR_ELEMENT));
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        FileStatusMap fileStatusMap = daemonCodeAnalyzer.getFileStatusMap();
        this.myErrorFound = !wholeFileHighlighting && fileStatusMap.wasErrorFound(this.getDocument());
        this.setProgressLimit(document.getTextLength() / 2);
        this.myGlobalScheme = editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme();
    }

    @NotNull
    private PsiFile getFile() {
        return this.myFile;
    }

    private HighlightVisitor @NotNull [] cloneHighlightVisitors() {
        int oldCount = this.incVisitorUsageCount(1);
        HighlightVisitor[] highlightVisitors = (HighlightVisitor[])HighlightVisitor.EP_HIGHLIGHT_VISITOR.getExtensions((AreaInstance)this.myProject);
        if (oldCount != 0) {
            HighlightVisitor[] clones = new HighlightVisitor[highlightVisitors.length];
            for (int i2 = 0; i2 < highlightVisitors.length; ++i2) {
                HighlightVisitor highlightVisitor = highlightVisitors[i2];
                HighlightVisitor cloned = highlightVisitor.clone();
                assert (cloned.getClass() == highlightVisitor.getClass()) : highlightVisitor.getClass() + ".clone() must return a copy of " + highlightVisitor.getClass() + "; but got: " + cloned + " of " + cloned.getClass();
                clones[i2] = cloned;
            }
            highlightVisitors = clones;
        }
        return highlightVisitors;
    }

    private HighlightVisitor @NotNull [] filterVisitors(HighlightVisitor @NotNull [] highlightVisitors, @NotNull PsiFile psiFile) {
        ArrayList<HighlightVisitor> visitors = new ArrayList<HighlightVisitor>(highlightVisitors.length);
        List<HighlightVisitor> list2 = Arrays.asList(highlightVisitors);
        for (HighlightVisitor visitor : DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(list2)) {
            if (visitor instanceof RainbowVisitor && !RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)this.getColorsScheme(), psiFile.getLanguage()) || !visitor.suitableForFile(psiFile)) continue;
            visitors.add(visitor);
        }
        if (visitors.isEmpty()) {
            LOG.error("No visitors registered. list=" + list2 + "; all visitors are:" + HighlightVisitor.EP_HIGHLIGHT_VISITOR.getExtensionList((AreaInstance)this.myProject));
        }
        return visitors.toArray(new HighlightVisitor[0]);
    }

    void setHighlightVisitorProducer(@NotNull NotNullProducer<HighlightVisitor[]> highlightVisitorProducer) {
        this.myHighlightVisitorProducer = highlightVisitorProducer;
    }

    HighlightVisitor @NotNull [] getHighlightVisitors(@NotNull PsiFile psiFile) {
        return this.filterVisitors((HighlightVisitor[])this.myHighlightVisitorProducer.produce(), psiFile);
    }

    int incVisitorUsageCount(int delta) {
        AtomicInteger count = (AtomicInteger)this.myProject.getUserData(HIGHLIGHT_VISITOR_INSTANCE_COUNT);
        if (count == null) {
            count = (AtomicInteger)((UserDataHolderEx)this.myProject).putUserDataIfAbsent(HIGHLIGHT_VISITOR_INSTANCE_COUNT, (Object)new AtomicInteger(0));
        }
        int old = count.getAndAdd(delta);
        assert (old + delta >= 0) : old + ";" + delta;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress2) {
        long start2 = System.nanoTime();
        ArrayList outsideResult = new ArrayList(100);
        ArrayList<HighlightInfo> insideResult = new ArrayList<HighlightInfo>(100);
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        HighlightVisitor[] filteredVisitors = this.getHighlightVisitors(this.getFile());
        try {
            boolean success;
            ArrayList dividedElements = new ArrayList();
            Divider.divideInsideAndOutsideAllRoots(this.getFile(), this.myRestrictRange, (TextRange)this.myPriorityRange, SHOULD_HIGHLIGHT_FILTER, (Processor<? super Divider.DividedElements>)new CommonProcessors.CollectProcessor(dividedElements));
            List allInsideElements = ContainerUtil.concat((Iterable)ContainerUtil.map(dividedElements, dividedForRoot -> {
                List<PsiElement> inside = dividedForRoot.inside;
                PsiElement lastInside = (PsiElement)ContainerUtil.getLastItem(inside);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? inside.subList(0, inside.size() - 1) : inside;
            }));
            List allInsideRanges = ContainerUtil.concat((Iterable)ContainerUtil.map(dividedElements, dividedForRoot -> {
                List<ProperTextRange> insideRanges = dividedForRoot.insideRanges;
                PsiElement lastInside = (PsiElement)ContainerUtil.getLastItem(dividedForRoot.inside);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? insideRanges.subList(0, insideRanges.size() - 1) : insideRanges;
            }));
            List allOutsideElements = ContainerUtil.concat((Iterable)ContainerUtil.map(dividedElements, dividedForRoot -> {
                List outside = dividedForRoot.outside;
                PsiElement lastInside = (PsiElement)ContainerUtil.getLastItem(dividedForRoot.inside);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? ContainerUtil.append(outside, (Object[])new PsiElement[]{lastInside}) : outside;
            }));
            List allOutsideRanges = ContainerUtil.concat((Iterable)ContainerUtil.map(dividedElements, dividedForRoot -> {
                List outsideRanges = dividedForRoot.outsideRanges;
                PsiElement lastInside = (PsiElement)ContainerUtil.getLastItem(dividedForRoot.inside);
                ProperTextRange lastInsideRange = (ProperTextRange)ContainerUtil.getLastItem(dividedForRoot.insideRanges);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? ContainerUtil.append(outsideRanges, (Object[])new ProperTextRange[]{lastInsideRange}) : outsideRanges;
            }));
            this.setProgressLimit(allInsideElements.size() + allOutsideElements.size());
            boolean forceHighlightParents = this.forceHighlightParents();
            if (!this.isDumbMode() && this.getEditor() != null) {
                GeneralHighlightingPass.highlightTodos(this.getFile(), this.getDocument().getCharsSequence(), this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), this.myPriorityRange, insideResult, outsideResult);
            }
            if (success = this.collectHighlights(allInsideElements, allInsideRanges, allOutsideElements, allOutsideRanges, filteredVisitors, insideResult, outsideResult, forceHighlightParents)) {
                this.myHighlightInfoProcessor.highlightsOutsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), outsideResult, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
                if (this.myUpdateAll) {
                    daemonCodeAnalyzer.getFileStatusMap().setErrorFoundFlag(this.myProject, this.getDocument(), this.myErrorFound);
                }
                long latencyMs = (System.nanoTime() - start2) / 1000000L;
                AndroidStudioAnalytics.getInstance().recordHighlightingLatency(this.getDocument(), latencyMs);
            } else {
                GeneralHighlightingPass.cancelAndRestartDaemonLater(progress2, this.myProject);
            }
        }
        finally {
            this.incVisitorUsageCount(-1);
            this.myHighlights.addAll(insideResult);
            this.myHighlights.addAll(outsideResult);
        }
    }

    private boolean isWholeFileHighlighting() {
        return this.myUpdateAll && this.myRestrictRange.equalsToRange(0, this.getDocument().getTextLength());
    }

    @Override
    protected void applyInformationWithProgress() {
        this.getFile().putUserData(HAS_ERROR_ELEMENT, (Object)this.myHasErrorElement);
        if (this.myUpdateAll) {
            ((HighlightingSessionImpl)this.myHighlightingSession).applyInEDT(this::reportErrorsToWolf);
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        return new ArrayList<HighlightInfo>(this.myHighlights);
    }

    private boolean collectHighlights(@NotNull List<? extends PsiElement> elements1, @NotNull List<? extends ProperTextRange> ranges1, @NotNull List<? extends PsiElement> elements2, @NotNull List<? extends ProperTextRange> ranges2, HighlightVisitor @NotNull [] visitors, @NotNull List<HighlightInfo> insideResult, @NotNull List<? super HighlightInfo> outsideResult, boolean forceHighlightParents) {
        THashSet skipParentsSet = new THashSet();
        HighlightInfoHolder holder = this.createInfoHolder(this.getFile());
        int chunkSize = Math.max(1, (elements1.size() + elements2.size()) / 100);
        boolean success = this.analyzeByVisitors(visitors, holder, 0, () -> this.lambda$collectHighlights$5(elements1, ranges1, chunkSize, (Set)skipParentsSet, holder, insideResult, outsideResult, forceHighlightParents, visitors, elements2, ranges2));
        ArrayList<HighlightInfo> postInfos = new ArrayList<HighlightInfo>(holder.size());
        for (int j = 0; j < holder.size(); ++j) {
            HighlightInfo info = holder.get(j);
            postInfos.add(info);
        }
        this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), postInfos, this.getFile().getTextRange(), this.getFile().getTextRange(), 5);
        return success;
    }

    private boolean analyzeByVisitors(HighlightVisitor @NotNull [] visitors, @NotNull HighlightInfoHolder holder, int i2, @NotNull Runnable action2) {
        boolean[] success = new boolean[]{true};
        if (i2 == visitors.length) {
            action2.run();
        } else if (!visitors[i2].analyze(this.getFile(), this.myUpdateAll, holder, () -> {
            success[0] = this.analyzeByVisitors(visitors, holder, i2 + 1, action2);
        })) {
            success[0] = false;
        }
        return success[0];
    }

    private void runVisitors(@NotNull List<? extends PsiElement> elements2, @NotNull List<? extends ProperTextRange> ranges, int chunkSize, @NotNull Set<? super PsiElement> skipParentsSet, @NotNull HighlightInfoHolder holder, @NotNull List<? super HighlightInfo> insideResult, @NotNull List<? super HighlightInfo> outsideResult, boolean forceHighlightParents, HighlightVisitor @NotNull [] visitors, @NotNull Stack<TextRange> nestedRange, @NotNull Stack<List<HighlightInfo>> nestedInfos) {
        boolean failed = false;
        int nextLimit = chunkSize;
        for (int i2 = 0; i2 < elements2.size(); ++i2) {
            PsiElement element2 = elements2.get(i2);
            ProgressManager.checkCanceled();
            PsiElement parent = element2.getParent();
            if (element2 != this.getFile() && !skipParentsSet.isEmpty() && element2.getFirstChild() != null && skipParentsSet.contains(element2) && parent != null) {
                skipParentsSet.add((PsiElement)parent);
                continue;
            }
            boolean isErrorElement = element2 instanceof PsiErrorElement;
            if (isErrorElement) {
                this.myHasErrorElement = true;
            }
            for (HighlightVisitor visitor : visitors) {
                try {
                    visitor.visit(element2);
                    holder.queueToUpdateIncrementally();
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!failed) {
                        LOG.error("In file: " + this.myFile.getViewProvider().getVirtualFile(), (Throwable)e);
                    }
                    failed = true;
                }
            }
            if (i2 == nextLimit) {
                this.advanceProgress(chunkSize);
                nextLimit = i2 + chunkSize;
            }
            TextRange elementRange = (TextRange)ranges.get(i2);
            List<HighlightInfo> infosForThisRange = holder.size() == 0 ? null : new ArrayList(holder.size());
            for (int j = 0; j < holder.size(); ++j) {
                boolean isError;
                HighlightInfo info = holder.get(j);
                if (!this.myRestrictRange.contains((Segment)info)) continue;
                List<? super HighlightInfo> result2 = this.myPriorityRange.containsRange(info.getStartOffset(), info.getEndOffset()) && !(element2 instanceof PsiFile) ? insideResult : outsideResult;
                result2.add(info);
                boolean bl = isError = info.getSeverity() == HighlightSeverity.ERROR;
                if (isError) {
                    if (!forceHighlightParents && parent != null) {
                        skipParentsSet.add((PsiElement)parent);
                    }
                    this.myErrorFound = true;
                }
                info.setBijective(elementRange.equalsToRange(info.startOffset, info.endOffset) || isErrorElement);
                infosForThisRange.add(info);
            }
            holder.clear();
            while (!nestedRange.isEmpty() && elementRange.contains((TextRange)nestedRange.peek())) {
                TextRange oldRange = (TextRange)nestedRange.pop();
                List oldInfos = (List)nestedInfos.pop();
                if (!elementRange.equals((Object)oldRange)) continue;
                if (infosForThisRange == null) {
                    infosForThisRange = oldInfos;
                    continue;
                }
                if (oldInfos == null) continue;
                infosForThisRange.addAll(oldInfos);
            }
            nestedRange.push((Object)elementRange);
            nestedInfos.push(infosForThisRange);
            if (parent != null && GeneralHighlightingPass.hasSameRangeAsParent(parent, element2)) continue;
            this.myHighlightInfoProcessor.allHighlightsForRangeAreProduced(this.myHighlightingSession, elementRange, infosForThisRange);
        }
        this.advanceProgress(elements2.size() - (nextLimit - chunkSize));
    }

    private static boolean hasSameRangeAsParent(@NotNull PsiElement parent, @NotNull PsiElement element2) {
        return element2.getStartOffsetInParent() == 0 && element2.getTextLength() == parent.getTextLength();
    }

    static boolean isRestartPending() {
        return RESTART_REQUESTS.get() > 0;
    }

    private static void cancelAndRestartDaemonLater(@NotNull ProgressIndicator progress2, @NotNull Project project) throws ProcessCanceledException {
        RESTART_REQUESTS.incrementAndGet();
        progress2.cancel();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            RESTART_REQUESTS.decrementAndGet();
            if (!project.isDisposed()) {
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }
        } else {
            int delay = RESTART_DAEMON_RANDOM.nextInt(100);
            EdtExecutorService.getScheduledExecutorInstance().schedule(() -> {
                RESTART_REQUESTS.decrementAndGet();
                if (!project.isDisposed()) {
                    DaemonCodeAnalyzer.getInstance((Project)project).restart();
                }
            }, (long)delay, TimeUnit.MILLISECONDS);
        }
        throw new ProcessCanceledException();
    }

    private boolean forceHighlightParents() {
        boolean forceHighlightParents = false;
        for (HighlightRangeExtension extension : HighlightRangeExtension.EP_NAME.getExtensionList()) {
            if (!extension.isForceHighlightParents(this.getFile())) continue;
            forceHighlightParents = true;
            break;
        }
        return forceHighlightParents;
    }

    @NotNull
    protected HighlightInfoHolder createInfoHolder(@NotNull PsiFile file2) {
        HighlightInfoFilter[] filters = (HighlightInfoFilter[])HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensions();
        final EditorColorsScheme actualScheme = this.getColorsScheme() == null ? EditorColorsManager.getInstance().getGlobalScheme() : this.getColorsScheme();
        return new HighlightInfoHolder(file2, filters){
            int queued;

            @Override
            @NotNull
            public TextAttributesScheme getColorsScheme() {
                return actualScheme;
            }

            @Override
            public void queueToUpdateIncrementally() {
                for (int i2 = this.queued; i2 < this.size(); ++i2) {
                    HighlightInfo info = this.get(i2);
                    GeneralHighlightingPass.this.queueInfoToUpdateIncrementally(info);
                }
                this.queued = this.size();
            }

            @Override
            public void clear() {
                super.clear();
                this.queued = 0;
            }
        };
    }

    protected void queueInfoToUpdateIncrementally(@NotNull HighlightInfo info) {
        int group = info.getGroup() == 0 ? 4 : info.getGroup();
        this.myHighlightInfoProcessor.infoIsAvailable(this.myHighlightingSession, info, (TextRange)this.myPriorityRange, this.myRestrictRange, group);
    }

    static void highlightTodos(@NotNull PsiFile file2, @NotNull CharSequence text, int startOffset, int endOffset, @NotNull ProperTextRange priorityRange, @NotNull Collection<? super HighlightInfo> insideResult, @NotNull Collection<? super HighlightInfo> outsideResult) {
        PsiTodoSearchHelper helper = PsiTodoSearchHelper.SERVICE.getInstance((Project)file2.getProject());
        if (helper == null || !GeneralHighlightingPass.shouldHighlightTodos(helper, file2)) {
            return;
        }
        TodoItem[] todoItems = helper.findTodoItems(file2, startOffset, endOffset);
        if (todoItems.length == 0) {
            return;
        }
        for (TodoItem todoItem : todoItems) {
            ProgressManager.checkCanceled();
            TextRange textRange = todoItem.getTextRange();
            List additionalRanges = todoItem.getAdditionalTextRanges();
            StringJoiner joiner = new StringJoiner("\n");
            JBIterable.of((Object)textRange).append((Iterable)additionalRanges).forEach(range2 -> joiner.add(text.subSequence(range2.getStartOffset(), range2.getEndOffset())));
            String description = joiner.toString();
            String tooltip = XmlStringUtil.escapeString((String)StringUtil.shortenPathWithEllipsis((String)description, (int)1024)).replace("\n", "<br>");
            TextAttributes attributes = todoItem.getPattern().getAttributes().getTextAttributes();
            GeneralHighlightingPass.addTodoItem(startOffset, endOffset, priorityRange, insideResult, outsideResult, attributes, description, tooltip, textRange);
            if (additionalRanges.isEmpty()) continue;
            TextAttributes attributesForAdditionalLines = attributes.clone();
            attributesForAdditionalLines.setErrorStripeColor(null);
            for (TextRange range3 : additionalRanges) {
                GeneralHighlightingPass.addTodoItem(startOffset, endOffset, priorityRange, insideResult, outsideResult, attributesForAdditionalLines, description, tooltip, range3);
            }
        }
    }

    private static void addTodoItem(int restrictStartOffset, int restrictEndOffset, @NotNull ProperTextRange priorityRange, @NotNull Collection<? super HighlightInfo> insideResult, @NotNull Collection<? super HighlightInfo> outsideResult, @NotNull TextAttributes attributes, @NotNull String description, @NotNull String tooltip, @NotNull TextRange range2) {
        if (range2.getStartOffset() >= restrictEndOffset || range2.getEndOffset() <= restrictStartOffset) {
            return;
        }
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.TODO).range(range2).textAttributes(attributes).description(description).escapedToolTip(tooltip).createUnconditionally();
        Collection<? super HighlightInfo> result2 = priorityRange.containsRange(info.getStartOffset(), info.getEndOffset()) ? insideResult : outsideResult;
        result2.add(info);
    }

    private static boolean shouldHighlightTodos(@NotNull PsiTodoSearchHelper helper, @NotNull PsiFile file2) {
        return helper instanceof PsiTodoSearchHelperImpl && ((PsiTodoSearchHelperImpl)helper).shouldHighlightInEditor(file2);
    }

    private void reportErrorsToWolf() {
        if (!this.getFile().getViewProvider().isPhysical()) {
            return;
        }
        Project project = this.getFile().getProject();
        if (!PsiManager.getInstance((Project)project).isInProject((PsiElement)this.getFile())) {
            return;
        }
        VirtualFile file2 = this.getFile().getVirtualFile();
        if (file2 == null) {
            return;
        }
        List<Problem> problems2 = GeneralHighlightingPass.convertToProblems(this.getInfos(), file2, this.myHasErrorElement);
        WolfTheProblemSolver wolf = WolfTheProblemSolver.getInstance((Project)project);
        boolean hasErrors = DaemonCodeAnalyzerEx.hasErrors(project, this.getDocument());
        if (!hasErrors || this.isWholeFileHighlighting()) {
            wolf.reportProblems(file2, problems2);
        } else {
            wolf.weHaveGotProblems(file2, problems2);
        }
    }

    @NotNull
    private static List<Problem> convertToProblems(@NotNull Collection<? extends HighlightInfo> infos, @NotNull VirtualFile file2, boolean hasErrorElement) {
        SmartList problems2 = new SmartList();
        for (HighlightInfo highlightInfo : infos) {
            if (highlightInfo.getSeverity() != HighlightSeverity.ERROR) continue;
            ProblemImpl problem = new ProblemImpl(file2, highlightInfo, hasErrorElement);
            problems2.add(problem);
        }
        return problems2;
    }

    @Override
    public String toString() {
        return super.toString() + " updateAll=" + this.myUpdateAll + " range= " + this.myRestrictRange;
    }

    private static String getPresentableNameText() {
        return AnalysisBundle.message((String)"pass.syntax", (Object[])new Object[0]);
    }

    private /* synthetic */ void lambda$collectHighlights$5(List elements1, List ranges1, int chunkSize, Set skipParentsSet, HighlightInfoHolder holder, List insideResult, List outsideResult, boolean forceHighlightParents, HighlightVisitor[] visitors, List elements2, List ranges2) {
        Stack nestedRange = new Stack();
        Stack nestedInfos = new Stack();
        this.runVisitors(elements1, ranges1, chunkSize, skipParentsSet, holder, insideResult, outsideResult, forceHighlightParents, visitors, (Stack<TextRange>)nestedRange, (Stack<List<HighlightInfo>>)nestedInfos);
        ProperTextRange priorityIntersection = this.myPriorityRange.intersection(this.myRestrictRange);
        if (!(elements1.isEmpty() && insideResult.isEmpty() || priorityIntersection == null)) {
            this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), insideResult, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
        }
        this.runVisitors(elements2, ranges2, chunkSize, skipParentsSet, holder, insideResult, outsideResult, forceHighlightParents, visitors, (Stack<TextRange>)nestedRange, (Stack<List<HighlightInfo>>)nestedInfos);
    }
}

