/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChameleonSyntaxHighlightingPass
extends GeneralHighlightingPass {
    private ChameleonSyntaxHighlightingPass(@NotNull Project project, @NotNull PsiFile file2, @NotNull Document document, @NotNull ProperTextRange restrictRange, @NotNull ProperTextRange priorityRange, @Nullable Editor editor, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        super(project, file2, document, restrictRange.getStartOffset(), restrictRange.getEndOffset(), true, priorityRange, editor, highlightInfoProcessor);
    }

    @Override
    public void collectInformationWithProgress(@NotNull ProgressIndicator progress2) {
        SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)this.myFile).filter(o -> {
            IElementType type = PsiUtilCore.getElementType((PsiElement)o);
            return type instanceof ILazyParseableElementType && !(type instanceof IFileElementType);
        });
        ArrayList lazyOutside = new ArrayList(100);
        ArrayList<PsiElement> lazyInside = new ArrayList<PsiElement>(100);
        ArrayList outside = new ArrayList(100);
        ArrayList inside = new ArrayList(100);
        for (PsiElement e : s) {
            (e.getTextRange().intersects((TextRange)this.myPriorityRange) ? lazyInside : lazyOutside).add(e);
        }
        for (PsiElement e : lazyInside) {
            this.collectHighlights(e, inside, outside, this.myPriorityRange);
        }
        this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), inside, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
        for (PsiElement e : lazyOutside) {
            this.collectHighlights(e, inside, outside, this.myPriorityRange);
        }
        this.myHighlightInfoProcessor.highlightsOutsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), outside, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
        this.myHighlights.addAll(inside);
        this.myHighlights.addAll(outside);
    }

    private void collectHighlights(@NotNull PsiElement element2, @NotNull List<? super HighlightInfo> inside, @NotNull List<? super HighlightInfo> outside, @NotNull ProperTextRange priorityRange) {
        EditorColorsScheme scheme = (EditorColorsScheme)ObjectUtils.notNull((Object)this.getColorsScheme(), (Object)EditorColorsManager.getInstance().getGlobalScheme());
        TextAttributes defaultAttrs = scheme.getAttributes(HighlighterColors.TEXT);
        Language language = (Language)ILazyParseableElementType.LANGUAGE_KEY.get((UserDataHolder)element2.getNode());
        if (language == null) {
            return;
        }
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)this.myProject, (VirtualFile)this.myFile.getVirtualFile());
        for (PsiElement token : SyntaxTraverser.psiTraverser((PsiElement)element2).traverse(TreeTraversal.LEAVES_DFS)) {
            TextAttributes forcedAttributes;
            List<? super HighlightInfo> result2;
            TextRange tr = token.getTextRange();
            if (tr.isEmpty()) continue;
            IElementType type = PsiUtilCore.getElementType((PsiElement)token);
            TextAttributesKey[] keys2 = syntaxHighlighter.getTokenHighlights(type);
            TextAttributes attributes = null;
            for (TextAttributesKey key : keys2) {
                TextAttributes attrs2 = scheme.getAttributes(key);
                if (attrs2 == null) continue;
                attributes = attributes == null ? attrs2 : TextAttributes.merge((TextAttributes)attributes, (TextAttributes)attrs2);
            }
            List<? super HighlightInfo> list2 = result2 = priorityRange.contains(tr) ? inside : outside;
            if (attributes == null || attributes.isEmpty() || attributes.equals((Object)defaultAttrs)) {
                forcedAttributes = TextAttributes.ERASE_MARKER;
            } else {
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(tr).textAttributes(TextAttributes.ERASE_MARKER).createUnconditionally();
                result2.add(info);
                forcedAttributes = new TextAttributes(attributes.getForegroundColor(), attributes.getBackgroundColor(), attributes.getEffectColor(), attributes.getEffectType(), attributes.getFontType());
            }
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(tr).textAttributes(forcedAttributes).createUnconditionally();
            result2.add(info);
        }
    }

    @Override
    protected void applyInformationWithProgress() {
    }

    @Override
    @Nullable
    protected String getPresentableName() {
        return null;
    }

    static final class Factory
    implements MainHighlightingPassFactory,
    TextEditorHighlightingPassFactoryRegistrar {
        Factory() {
        }

        @Override
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, false, -1);
        }

        @Override
        @NotNull
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
            Project project = file2.getProject();
            TextRange restrict = FileStatusMap.getDirtyTextRange(editor, 4);
            if (restrict == null) {
                return new ProgressableTextEditorHighlightingPass.EmptyPass(project, editor.getDocument());
            }
            ProperTextRange priority = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
            return new ChameleonSyntaxHighlightingPass(project, file2, editor.getDocument(), ProperTextRange.create((Segment)restrict), priority, editor, new DefaultHighlightInfoProcessor());
        }

        @Override
        @NotNull
        public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
            ProperTextRange range2 = ProperTextRange.from((int)0, (int)document.getTextLength());
            return new ChameleonSyntaxHighlightingPass(file2.getProject(), file2, document, range2, range2, null, highlightInfoProcessor);
        }
    }
}

