/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.controlflow.impl;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InstructionBaseImpl
implements Instruction {
    private final List<Instruction> myPred = new SmartList();
    private final List<Instruction> mySucc = new SmartList();
    @Nullable
    protected final PsiElement myElement;

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    public InstructionBaseImpl(@Nullable PsiElement element2) {
        this.myElement = element2;
    }

    @NotNull
    public final List<Instruction> allSucc() {
        return this.mySucc;
    }

    @NotNull
    public final List<Instruction> allPred() {
        return this.myPred;
    }

    @NotNull
    public String toString() {
        StringBuilder builder2 = new StringBuilder(this.id());
        builder2.append("(");
        for (int i2 = 0; i2 < this.mySucc.size(); ++i2) {
            if (i2 > 0) {
                builder2.append(',');
            }
            Instruction instruction = this.mySucc.get(i2);
            int num = instruction.num();
            if (instruction instanceof InstructionBaseImpl) {
                builder2.append(((InstructionBaseImpl)instruction).id());
                continue;
            }
            builder2.append(num);
        }
        builder2.append(") ").append(this.getElementPresentation());
        return builder2.toString();
    }

    @NotNull
    public String getElementPresentation() {
        return "element: " + this.myElement;
    }

    @NotNull
    protected String id() {
        return String.valueOf(this.num());
    }
}

