/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.lookup.CachingComparingClassifier;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class CompletionSorterImpl
extends CompletionSorter {
    private final List<? extends ClassifierFactory<LookupElement>> myMembers;
    private final int myHashCode;

    @ApiStatus.Internal
    public CompletionSorterImpl(List<? extends ClassifierFactory<LookupElement>> members) {
        this.myMembers = members;
        this.myHashCode = this.myMembers.hashCode();
    }

    public static ClassifierFactory<LookupElement> weighingFactory(final LookupElementWeigher weigher2) {
        String id2 = weigher2.toString();
        return new ClassifierFactory<LookupElement>(id2){

            @Override
            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new CachingComparingClassifier(next, weigher2);
            }
        };
    }

    public CompletionSorterImpl weighBefore(@NotNull String beforeId, LookupElementWeigher ... weighers) {
        if (weighers.length == 0) {
            return this;
        }
        CompletionSorterImpl result2 = this;
        for (LookupElementWeigher weigher2 : weighers) {
            result2 = result2.withClassifier(beforeId, true, CompletionSorterImpl.weighingFactory(weigher2));
        }
        return result2;
    }

    public CompletionSorterImpl weighAfter(@NotNull String afterId, LookupElementWeigher ... weighers) {
        if (weighers.length == 0) {
            return this;
        }
        CompletionSorterImpl result2 = this;
        for (int i2 = weighers.length - 1; i2 >= 0; --i2) {
            LookupElementWeigher weigher2 = weighers[i2];
            result2 = result2.withClassifier(afterId, false, CompletionSorterImpl.weighingFactory(weigher2));
        }
        return result2;
    }

    public CompletionSorterImpl weigh(LookupElementWeigher weigher2) {
        return this.withClassifier(CompletionSorterImpl.weighingFactory(weigher2));
    }

    public CompletionSorterImpl withClassifier(ClassifierFactory<LookupElement> classifierFactory) {
        return this.enhanced(classifierFactory, this.myMembers.size());
    }

    public CompletionSorterImpl withClassifier(@NotNull String anchorId, boolean beforeAnchor, ClassifierFactory<LookupElement> classifierFactory) {
        int i2 = this.idIndex(anchorId);
        return this.enhanced(classifierFactory, beforeAnchor ? Math.max(0, i2) : i2 + 1);
    }

    private CompletionSorterImpl enhanced(ClassifierFactory<LookupElement> classifierFactory, int index) {
        ArrayList<? extends ClassifierFactory<LookupElement>> copy2 = new ArrayList<ClassifierFactory<LookupElement>>(this.myMembers);
        copy2.add(index, classifierFactory);
        return new CompletionSorterImpl(copy2);
    }

    private int idIndex(String id2) {
        return ContainerUtil.indexOf(this.myMembers, factory2 -> id2.equals(factory2.getId()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompletionSorterImpl)) {
            return false;
        }
        CompletionSorterImpl that = (CompletionSorterImpl)((Object)o);
        return this.myMembers.equals(that.myMembers);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private static Classifier<LookupElement> createClassifier(int index, List<? extends ClassifierFactory<LookupElement>> components, Classifier<LookupElement> tail) {
        if (index == components.size()) {
            return tail;
        }
        return components.get(index).createClassifier(CompletionSorterImpl.createClassifier(index + 1, components, tail));
    }

    public Classifier<LookupElement> buildClassifier(Classifier<LookupElement> tail) {
        return CompletionSorterImpl.createClassifier(0, this.myMembers, tail);
    }
}

