/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.OffsetTranslator;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionUtilCoreImpl {
    @Nullable
    public static <T extends PsiElement> T getOriginalElement(@NotNull T psi) {
        return CompletionUtilCoreImpl.getOriginalElement(psi, psi.getContainingFile());
    }

    @Nullable
    public static <T extends PsiElement> T getOriginalElement(@NotNull T psi, PsiFile containingFile) {
        TextRange range2;
        if (containingFile == null || psi instanceof LightElement) {
            return psi;
        }
        PsiFile originalFile = containingFile.getOriginalFile();
        if (psi == containingFile && psi.getClass().isInstance(originalFile)) {
            return (T)originalFile;
        }
        if (originalFile != containingFile && !(originalFile instanceof PsiCompiledFile) && (range2 = psi.getTextRange()) != null) {
            Document hostDocument;
            OffsetTranslator translator;
            Integer start2 = range2.getStartOffset();
            Integer end = range2.getEndOffset();
            Document document = containingFile.getViewProvider().getDocument();
            if (document != null && (translator = (OffsetTranslator)(hostDocument = document instanceof DocumentWindow ? ((DocumentWindow)document).getDelegate() : document).getUserData(OffsetTranslator.RANGE_TRANSLATION)) != null) {
                if (document instanceof DocumentWindow) {
                    TextRange translated = ((DocumentWindow)document).injectedToHost(new TextRange(start2.intValue(), end.intValue()));
                    start2 = translated.getStartOffset();
                    end = translated.getEndOffset();
                }
                start2 = translator.translateOffset(start2);
                end = translator.translateOffset(end);
                if (start2 == null || end == null) {
                    return null;
                }
                if (document instanceof DocumentWindow) {
                    start2 = ((DocumentWindow)document).hostToInjected(start2.intValue());
                    end = ((DocumentWindow)document).hostToInjected(end.intValue());
                }
            }
            return (T)PsiTreeUtil.findElementOfClassAtRange((PsiFile)originalFile, (int)start2, (int)end, psi.getClass());
        }
        return psi;
    }

    @NotNull
    public static <T extends PsiElement> T getOriginalOrSelf(@NotNull T psi) {
        T element2 = CompletionUtilCoreImpl.getOriginalElement(psi);
        return element2 == null ? psi : element2;
    }
}

