/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.StringComboboxEditor;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;

public class ComboEditorCompletionContributor
extends CompletionContributor
implements DumbAware {
    public static final Key<Boolean> CONTINUE_RUN_COMPLETION = Key.create((String)"CONTINUE_RUN_COMPLETION");
    private static final Key<LookupElementProvider> LOOKUP_ELEMENT_PROVIDER_KEY = Key.create((String)"LOOKUP_ELEMENT_PROVIDER_KEY");

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        JComboBox comboBox2;
        if (parameters2.getInvocationCount() == 0) {
            return;
        }
        PsiFile file2 = parameters2.getOriginalFile();
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document != null && (comboBox2 = (JComboBox)document.getUserData(StringComboboxEditor.COMBO_BOX_KEY)) != null) {
            String substring = document.getText().substring(0, parameters2.getOffset());
            boolean plainPrefixMatcher = Boolean.TRUE.equals(document.getUserData(StringComboboxEditor.USE_PLAIN_PREFIX_MATCHER));
            CompletionResultSet resultSet = plainPrefixMatcher ? result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(substring)) : result2.withPrefixMatcher(substring);
            LookupElementProvider lookupElementProvider = (LookupElementProvider)LOOKUP_ELEMENT_PROVIDER_KEY.get((UserDataHolder)document, (Object)LookupElementProvider.DEFAULT);
            int count = comboBox2.getItemCount();
            for (int i2 = 0; i2 < count; ++i2) {
                Object o = comboBox2.getItemAt(i2);
                if (!(o instanceof String)) continue;
                resultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)lookupElementProvider.createLookupElement((String)o), (double)(count - i2)));
            }
            if (!Boolean.TRUE.equals(document.getUserData(CONTINUE_RUN_COMPLETION))) {
                result2.stopHere();
            }
        }
    }

    public static void installLookupElementProvider(@NotNull Document document, @NotNull LookupElementProvider provider) {
        LOOKUP_ELEMENT_PROVIDER_KEY.set((UserDataHolder)document, (Object)provider);
    }

    public static class DefaultLookupElementProvider
    implements LookupElementProvider {
        @NotNull
        public LookupElementBuilder createLookupElement(@NotNull String lookupString) {
            return LookupElementBuilder.create((String)lookupString).withInsertHandler((context, item) -> {
                Document document = context.getEditor().getDocument();
                document.deleteString(context.getEditor().getCaretModel().getOffset(), document.getTextLength());
            });
        }
    }

    public static interface LookupElementProvider {
        public static final DefaultLookupElementProvider DEFAULT = new DefaultLookupElementProvider();

        @NotNull
        public LookupElement createLookupElement(@NotNull String var1);
    }
}

