/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.ActionTracker;
import com.intellij.codeInsight.completion.AsyncCompletion;
import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionAssertions;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionInitializationContextImpl;
import com.intellij.codeInsight.completion.CompletionInitializationUtil;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.completion.StatisticsUpdate;
import com.intellij.codeInsight.completion.actions.BaseCodeCompletionAction;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.OverridingAction;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeCompletionHandlerBase {
    private static final Logger LOG = Logger.getInstance(CodeCompletionHandlerBase.class);
    private static final Key<Boolean> CARET_PROCESSED = Key.create((String)"CodeCompletionHandlerBase.caretProcessed");
    public static final Key<Boolean> DIRECT_INSERTION = Key.create((String)"CodeCompletionHandlerBase.directInsertion");
    @NotNull
    final CompletionType completionType;
    final boolean invokedExplicitly;
    final boolean synchronous;
    final boolean autopopup;
    private static int ourAutoInsertItemTimeout = 2000;

    public static CodeCompletionHandlerBase createHandler(@NotNull CompletionType completionType) {
        return CodeCompletionHandlerBase.createHandler(completionType, true, false, true);
    }

    public static CodeCompletionHandlerBase createHandler(@NotNull CompletionType completionType, boolean invokedExplicitly, boolean autopopup, boolean synchronous) {
        AnAction codeCompletionAction = ActionManager.getInstance().getAction("CodeCompletion");
        if (codeCompletionAction instanceof OverridingAction) {
            codeCompletionAction = ((ActionManagerImpl)ActionManager.getInstance()).getBaseAction((OverridingAction)codeCompletionAction);
        }
        assert (codeCompletionAction instanceof BaseCodeCompletionAction);
        BaseCodeCompletionAction baseCodeCompletionAction = (BaseCodeCompletionAction)codeCompletionAction;
        return baseCodeCompletionAction.createHandler(completionType, invokedExplicitly, autopopup, synchronous);
    }

    public CodeCompletionHandlerBase(@NotNull CompletionType completionType) {
        this(completionType, true, false, true);
    }

    public CodeCompletionHandlerBase(@NotNull CompletionType completionType, boolean invokedExplicitly, boolean autopopup, boolean synchronous) {
        this.completionType = completionType;
        this.invokedExplicitly = invokedExplicitly;
        this.autopopup = autopopup;
        this.synchronous = synchronous;
        if (autopopup) assert (!invokedExplicitly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCompletionElementSelected(@NotNull LookupElement item, char completionChar, OffsetMap offsetMap, OffsetsInFile hostOffsets, Editor editor, Integer initialOffset) {
        CompletionAssertions.WatchingInsertionContext context = null;
        try {
            StatisticsUpdate update2 = StatisticsUpdate.collectStatisticChanges(item);
            context = CodeCompletionHandlerBase.insertItemHonorBlockSelection(new ArrayList<LookupElement>(), item, completionChar, offsetMap, hostOffsets, editor, initialOffset, update2);
            update2.trackStatistics(context);
        }
        finally {
            if (context != null && context.getLaterRunnable() != null) {
                context.getLaterRunnable().run();
            }
        }
    }

    public final void invokeCompletion(Project project, Editor editor) {
        this.invokeCompletion(project, editor, 1);
    }

    public final void invokeCompletion(@NotNull Project project, @NotNull Editor editor, int time) {
        this.invokeCompletion(project, editor, time, false);
    }

    public final void invokeCompletion(@NotNull Project project, @NotNull Editor editor, int time, boolean hasModifiers) {
        CodeCompletionHandlerBase.clearCaretMarkers(editor);
        this.invokeCompletion(project, editor, time, hasModifiers, editor.getCaretModel().getPrimaryCaret());
    }

    private void invokeCompletion(@NotNull Project project, @NotNull Editor editor, int time, boolean hasModifiers, @NotNull Caret caret) {
        block10: {
            CodeCompletionHandlerBase.markCaretAsProcessed(caret);
            if (this.invokedExplicitly) {
                StatisticsUpdate.applyLastCompletionStatisticsUpdate();
            }
            CodeCompletionHandlerBase.checkNoWriteAccess();
            CompletionAssertions.checkEditorValid(editor);
            int offset = editor.getCaretModel().getOffset();
            if (editor.isViewer() || editor.getDocument().getRangeGuard(offset, offset) != null) {
                editor.getDocument().fireReadOnlyModificationAttempt();
                EditorModificationUtil.checkModificationAllowed((Editor)editor);
                return;
            }
            if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
                return;
            }
            CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
            boolean repeated = phase.indicator != null && phase.indicator.isRepeatedInvocation(this.completionType, editor);
            int newTime = phase.newCompletionStarted(time, repeated);
            if (this.invokedExplicitly) {
                time = newTime;
            }
            int invocationCount = time;
            if (CompletionServiceImpl.isPhase(CompletionPhase.InsertedSingleItem.class)) {
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            }
            CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass(), CompletionPhase.CommittingDocuments.class);
            if (invocationCount > 1 && this.completionType == CompletionType.BASIC) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.basic");
            }
            long startingTime = System.currentTimeMillis();
            Runnable initCmd = () -> {
                boolean hasValidContext;
                WriteAction.run(() -> EditorUtil.fillVirtualSpaceUntilCaret(editor));
                CompletionInitializationContextImpl context = (CompletionInitializationContextImpl)((Object)((Object)this.withTimeout(CodeCompletionHandlerBase.calcSyncTimeOut(startingTime), () -> CompletionInitializationUtil.createCompletionInitializationContext(project, editor, caret, invocationCount, this.completionType))));
                boolean bl = hasValidContext = context != null;
                if (!hasValidContext) {
                    PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Caret)caret, (Project)project);
                    context = new CompletionInitializationContextImpl(editor, caret, psiFile, this.completionType, invocationCount);
                }
                this.doComplete(context, hasModifiers, hasValidContext, startingTime);
            };
            try {
                if (this.autopopup) {
                    CommandProcessor.getInstance().runUndoTransparentAction(initCmd);
                } else {
                    CommandProcessor.getInstance().executeCommand(project, initCmd, null, null, editor.getDocument());
                }
            }
            catch (IndexNotReadyException e) {
                if (!this.invokedExplicitly) break block10;
                DumbService.getInstance((Project)project).showDumbModeNotification(CodeInsightBundle.message((String)"completion.not.available.during.indexing", (Object[])new Object[0]));
            }
        }
    }

    private static void checkNoWriteAccess() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new AssertionError((Object)"Completion should not be invoked inside write action");
        }
    }

    @NotNull
    private LookupImpl obtainLookup(Editor editor, Project project) {
        CompletionAssertions.checkEditorValid(editor);
        LookupImpl existing = (LookupImpl)LookupManager.getActiveLookup(editor);
        if (existing != null && existing.isCompletion()) {
            existing.markReused();
            if (!this.autopopup) {
                existing.setLookupFocusDegree(LookupFocusDegree.FOCUSED);
            }
            return existing;
        }
        LookupImpl lookup2 = (LookupImpl)LookupManager.getInstance(project).createLookup(editor, LookupElement.EMPTY_ARRAY, "", new LookupArranger.DefaultArranger());
        if (editor.isOneLineMode()) {
            lookup2.setCancelOnClickOutside(true);
            lookup2.setCancelOnOtherWindowOpen(true);
        }
        lookup2.setLookupFocusDegree(this.autopopup ? LookupFocusDegree.UNFOCUSED : LookupFocusDegree.FOCUSED);
        return lookup2;
    }

    private void doComplete(CompletionInitializationContextImpl initContext, boolean hasModifiers, boolean isValidContext, long startingTime) {
        OffsetsInFile hostCopyOffsets;
        Editor editor = initContext.getEditor();
        CompletionAssertions.checkEditorValid(editor);
        LookupImpl lookup2 = this.obtainLookup(editor, initContext.getProject());
        CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
        if (phase instanceof CompletionPhase.CommittingDocuments) {
            if (phase.indicator != null) {
                phase.indicator.closeAndFinish(false);
            }
            ((CompletionPhase.CommittingDocuments)phase).replaced = true;
        } else {
            CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass());
        }
        CompletionProgressIndicator indicator = new CompletionProgressIndicator(editor, initContext.getCaret(), initContext.getInvocationCount(), this, initContext.getOffsetMap(), initContext.getHostOffsets(), hasModifiers, lookup2);
        if (this.synchronous && isValidContext && (hostCopyOffsets = (OffsetsInFile)this.withTimeout(CodeCompletionHandlerBase.calcSyncTimeOut(startingTime), () -> {
            PsiDocumentManager.getInstance((Project)initContext.getProject()).commitAllDocuments();
            return CompletionInitializationUtil.insertDummyIdentifier(initContext, indicator).get();
        })) != null) {
            this.trySynchronousCompletion(initContext, hasModifiers, startingTime, indicator, hostCopyOffsets);
            return;
        }
        this.scheduleContributorsAfterAsyncCommit(initContext, indicator, hasModifiers);
    }

    private void scheduleContributorsAfterAsyncCommit(CompletionInitializationContextImpl initContext, CompletionProgressIndicator indicator, boolean hasModifiers) {
        CompletionPhase phase;
        if (this.synchronous) {
            phase = new CompletionPhase.BgCalculation(indicator);
            indicator.showLookup();
        } else {
            phase = new CompletionPhase.CommittingDocuments(indicator, InjectedLanguageUtil.getTopLevelEditor(indicator.getEditor()));
        }
        CompletionServiceImpl.setCompletionPhase(phase);
        ReadAction.nonBlocking(() -> CompletionInitializationUtil.insertDummyIdentifier(initContext, indicator)).expireWith((Disposable)phase).withDocumentsCommitted(indicator.getProject()).finishOnUiThread(ModalityState.defaultModalityState(), applyPsiChanges -> {
            OffsetsInFile hostCopyOffsets = (OffsetsInFile)applyPsiChanges.get();
            if (phase instanceof CompletionPhase.CommittingDocuments) {
                ((CompletionPhase.CommittingDocuments)phase).replaced = true;
            }
            CompletionServiceImpl.setCompletionPhase(new CompletionPhase.BgCalculation(indicator));
            this.startContributorThread(initContext, indicator, hostCopyOffsets, hasModifiers);
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void trySynchronousCompletion(CompletionInitializationContextImpl initContext, boolean hasModifiers, long startingTime, CompletionProgressIndicator indicator, OffsetsInFile hostCopyOffsets) {
        CompletionServiceImpl.setCompletionPhase(new CompletionPhase.Synchronous(indicator));
        Future<?> future2 = this.startContributorThread(initContext, indicator, hostCopyOffsets, hasModifiers);
        if (future2 == null) {
            return;
        }
        int timeout = CodeCompletionHandlerBase.calcSyncTimeOut(startingTime);
        if (indicator.blockingWaitForFinish(timeout)) {
            CodeCompletionHandlerBase.checkForExceptions(future2);
            try {
                indicator.getLookup().refreshUi(true, false);
                this.completionFinished(indicator, hasModifiers);
            }
            catch (Throwable e) {
                indicator.closeAndFinish(true);
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                LOG.error(e);
            }
            return;
        }
        CompletionServiceImpl.setCompletionPhase(new CompletionPhase.BgCalculation(indicator));
        indicator.showLookup();
    }

    @Nullable
    private Future<?> startContributorThread(CompletionInitializationContextImpl initContext, CompletionProgressIndicator indicator, OffsetsInFile hostCopyOffsets, boolean hasModifiers) {
        if (!hostCopyOffsets.getFile().isValid()) {
            this.completionFinished(indicator, hasModifiers);
            return null;
        }
        return indicator.getCompletionThreading().startThread(indicator, () -> AsyncCompletion.tryReadOrCancel(indicator, () -> {
            OffsetsInFile finalOffsets = CompletionInitializationUtil.toInjectedIfAny(initContext.getFile(), hostCopyOffsets);
            indicator.registerChildDisposable(finalOffsets::getOffsets);
            CompletionParameters parameters2 = CompletionInitializationUtil.createCompletionParameters(initContext, indicator, finalOffsets);
            parameters2.setIsTestingMode(this.isTestingMode());
            indicator.setParameters(parameters2);
            indicator.runContributors(initContext);
        }));
    }

    private static void checkForExceptions(Future<?> future2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                future2.get();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static void checkNotSync(CompletionProgressIndicator indicator, List<LookupElement> allItems) {
        if (CompletionServiceImpl.isPhase(CompletionPhase.Synchronous.class)) {
            LOG.error("sync phase survived: " + allItems + "; indicator=" + CompletionServiceImpl.getCompletionPhase().indicator + "; myIndicator=" + indicator);
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
        }
    }

    private AutoCompletionDecision shouldAutoComplete(@NotNull CompletionProgressIndicator indicator, @NotNull List<LookupElement> items, @NotNull CompletionParameters parameters2) {
        if (!this.invokedExplicitly) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        LookupElement item = items.get(0);
        if (items.size() == 1) {
            AutoCompletionPolicy policy = CodeCompletionHandlerBase.getAutocompletionPolicy(item);
            if (policy == AutoCompletionPolicy.NEVER_AUTOCOMPLETE) {
                return AutoCompletionDecision.SHOW_LOOKUP;
            }
            if (policy == AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE) {
                return AutoCompletionDecision.insertItem((LookupElement)item);
            }
            if (!indicator.getLookup().itemMatcher(item).isStartMatch(item)) {
                return AutoCompletionDecision.SHOW_LOOKUP;
            }
        }
        if (!CodeCompletionHandlerBase.isAutocompleteOnInvocation(parameters2.getCompletionType())) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        if (CodeCompletionHandlerBase.isInsideIdentifier(indicator.getOffsetMap())) {
            return AutoCompletionDecision.SHOW_LOOKUP;
        }
        if (items.size() == 1 && CodeCompletionHandlerBase.getAutocompletionPolicy(item) == AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE) {
            return AutoCompletionDecision.insertItem((LookupElement)item);
        }
        AutoCompletionContext context = new AutoCompletionContext(parameters2, items.toArray(LookupElement.EMPTY_ARRAY), indicator.getOffsetMap(), (Lookup)indicator.getLookup());
        AutoCompletionDecision resultingDecision = (AutoCompletionDecision)FileBasedIndex.getInstance().ignoreDumbMode(DumbModeAccessType.RELIABLE_DATA_ONLY, () -> {
            for (CompletionContributor contributor : CompletionContributor.forParameters((CompletionParameters)parameters2)) {
                AutoCompletionDecision decision = contributor.handleAutoCompletionPossibility(context);
                if (decision == null) continue;
                return decision;
            }
            return null;
        });
        if (resultingDecision != null) {
            return resultingDecision;
        }
        return AutoCompletionDecision.SHOW_LOOKUP;
    }

    @Nullable
    private static AutoCompletionPolicy getAutocompletionPolicy(LookupElement element2) {
        return element2.getAutoCompletionPolicy();
    }

    private static boolean isInsideIdentifier(OffsetMap offsetMap) {
        return offsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) != offsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completionFinished(CompletionProgressIndicator indicator, boolean hasModifiers) {
        List<LookupElement> items = indicator.getLookup().getItems();
        if (items.isEmpty()) {
            LookupManager.hideActiveLookup(indicator.getProject());
            Caret nextCaret = CodeCompletionHandlerBase.getNextCaretToProcess(indicator.getEditor());
            if (nextCaret != null) {
                this.invokeCompletion(indicator.getProject(), indicator.getEditor(), indicator.getInvocationCount(), hasModifiers, nextCaret);
            } else {
                indicator.handleEmptyLookup(true);
                CodeCompletionHandlerBase.checkNotSync(indicator, items);
            }
            return;
        }
        LOG.assertTrue(!indicator.isRunning(), (Object)"running");
        LOG.assertTrue(!indicator.isCanceled(), (Object)"canceled");
        try {
            AutoCompletionDecision decision;
            CompletionParameters parameters2 = indicator.getParameters();
            AutoCompletionDecision autoCompletionDecision = decision = parameters2 == null ? AutoCompletionDecision.CLOSE_LOOKUP : this.shouldAutoComplete(indicator, items, parameters2);
            if (decision == AutoCompletionDecision.SHOW_LOOKUP) {
                indicator.getLookup().setCalculating(false);
                indicator.showLookup();
                CompletionServiceImpl.setCompletionPhase(new CompletionPhase.ItemsCalculated(indicator));
            } else if (decision instanceof AutoCompletionDecision.InsertItem) {
                Runnable restorePrefix = CodeCompletionHandlerBase.rememberDocumentState(indicator.getEditor());
                LookupElement item = ((AutoCompletionDecision.InsertItem)decision).getElement();
                CommandProcessor.getInstance().executeCommand(indicator.getProject(), () -> {
                    indicator.setMergeCommand();
                    indicator.getLookup().finishLookup('\u0000', item);
                }, CodeInsightBundle.message((String)"completion.automatic.command.name", (Object[])new Object[0]), null);
                if (CompletionService.getCompletionService().getCurrentCompletion() == null && !CompletionServiceImpl.isPhase(CompletionPhase.CommittingDocuments.class)) {
                    CompletionServiceImpl.setCompletionPhase(hasModifiers ? new CompletionPhase.InsertedSingleItem(indicator, restorePrefix) : CompletionPhase.NoCompletion);
                }
            } else if (decision == AutoCompletionDecision.CLOSE_LOOKUP) {
                LookupManager.hideActiveLookup(indicator.getProject());
            }
        }
        catch (Throwable e) {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            LOG.error(e);
        }
        finally {
            CodeCompletionHandlerBase.checkNotSync(indicator, items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lookupItemSelected(CompletionProgressIndicator indicator, @NotNull LookupElement item, char completionChar, List<LookupElement> items) {
        Runnable runnable2;
        if (indicator.isAutopopupCompletion()) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.basic");
        }
        CompletionAssertions.WatchingInsertionContext context = null;
        try {
            StatisticsUpdate update2 = StatisticsUpdate.collectStatisticChanges(item);
            context = item.getUserData(DIRECT_INSERTION) != null ? CodeCompletionHandlerBase.callHandleInsert(indicator, item, completionChar) : CodeCompletionHandlerBase.insertItemHonorBlockSelection(indicator, item, completionChar, update2);
            update2.trackStatistics(context);
            runnable2 = context == null ? null : context.getLaterRunnable();
        }
        catch (Throwable throwable) {
            this.afterItemInsertion(indicator, context == null ? null : context.getLaterRunnable());
            throw throwable;
        }
        this.afterItemInsertion(indicator, runnable2);
    }

    public static CompletionAssertions.WatchingInsertionContext insertItemHonorBlockSelection(List<LookupElement> itemsAround, LookupElement item, char completionChar, OffsetMap offsetMap, OffsetsInFile hostOffset, Editor editor, Integer caretOffset, StatisticsUpdate update2) {
        int idEndOffset = CompletionUtil.calcIdEndOffset(offsetMap, editor, caretOffset);
        int idEndOffsetDelta = idEndOffset - caretOffset;
        CompletionAssertions.WatchingInsertionContext context = CodeCompletionHandlerBase.doInsertItem(hostOffset, item, completionChar, update2, editor, Objects.requireNonNull(editor.getProject()), caretOffset, offsetMap, itemsAround, idEndOffset, idEndOffsetDelta);
        if (context.shouldAddCompletionChar()) {
            WriteAction.run(() -> CodeCompletionHandlerBase.addCompletionChar(context, item));
        }
        return context;
    }

    private static CompletionAssertions.WatchingInsertionContext insertItemHonorBlockSelection(CompletionProcessEx indicator, LookupElement item, char completionChar, StatisticsUpdate update2) {
        Editor editor = indicator.getEditor();
        int caretOffset = indicator.getCaret().getOffset();
        OffsetMap offsetMap = indicator.getOffsetMap();
        Lookup lookup2 = indicator.getLookup();
        List items = lookup2 != null ? lookup2.getItems() : Collections.emptyList();
        int idEndOffset = CompletionUtil.calcIdEndOffset(offsetMap, editor, caretOffset);
        int idEndOffsetDelta = idEndOffset - caretOffset;
        CompletionAssertions.WatchingInsertionContext context = CodeCompletionHandlerBase.doInsertItem(indicator.getHostOffsets(), item, completionChar, update2, editor, indicator.getProject(), caretOffset, offsetMap, items, idEndOffset, idEndOffsetDelta);
        if (lookup2 != null) {
            update2.addSparedChars(lookup2, item, context);
        }
        if (context.shouldAddCompletionChar()) {
            WriteAction.run(() -> CodeCompletionHandlerBase.addCompletionChar(context, item));
        }
        CodeCompletionHandlerBase.checkPsiTextConsistency(indicator);
        return context;
    }

    private static CompletionAssertions.WatchingInsertionContext doInsertItem(@NotNull OffsetsInFile topLevelOffsets, LookupElement item, char completionChar, StatisticsUpdate update2, @NotNull Editor editor, @NotNull Project project, int caretOffset, OffsetMap offsetMap, List<LookupElement> items, int idEndOffset, int idEndOffsetDelta) {
        CompletionAssertions.WatchingInsertionContext context;
        if (editor.getCaretModel().supportsMultipleCarets()) {
            Ref lastContext = Ref.create();
            Editor hostEditor = InjectedLanguageUtil.getTopLevelEditor(editor);
            boolean wasInjected = hostEditor != editor;
            hostEditor.getCaretModel().runForEachCaret(caret -> {
                OffsetsInFile targetOffsets = CodeCompletionHandlerBase.findInjectedOffsetsIfAny(caret, wasInjected, topLevelOffsets, hostEditor);
                PsiFile targetFile = targetOffsets.getFile();
                Editor targetEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, targetFile);
                int targetCaretOffset = targetEditor.getCaretModel().getOffset();
                int idEnd = targetCaretOffset + idEndOffsetDelta;
                if (idEnd > targetEditor.getDocument().getTextLength()) {
                    idEnd = targetCaretOffset;
                }
                CompletionAssertions.WatchingInsertionContext currentContext = CodeCompletionHandlerBase.insertItem(items, item, completionChar, update2, targetEditor, targetFile, targetCaretOffset, idEnd, targetOffsets.getOffsets());
                lastContext.set((Object)currentContext);
            });
            context = (CompletionAssertions.WatchingInsertionContext)((Object)lastContext.get());
        } else {
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            context = CodeCompletionHandlerBase.insertItem(items, item, completionChar, update2, editor, psiFile, caretOffset, idEndOffset, offsetMap);
        }
        return context;
    }

    private static OffsetsInFile findInjectedOffsetsIfAny(@NotNull Caret caret, boolean wasInjected, @NotNull OffsetsInFile topLevelOffsets, @NotNull Editor hostEditor) {
        if (!wasInjected) {
            return topLevelOffsets;
        }
        PsiDocumentManager.getInstance((Project)topLevelOffsets.getFile().getProject()).commitDocument(hostEditor.getDocument());
        return topLevelOffsets.toInjectedIfAny(caret.getOffset());
    }

    private static void checkPsiTextConsistency(CompletionProcessEx indicator) {
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)InjectedLanguageUtil.getTopLevelEditor(indicator.getEditor()), (Project)indicator.getProject());
        if (psiFile != null && (Registry.is((String)"ide.check.stub.text.consistency") || ApplicationManager.getApplication().isUnitTestMode() && !ApplicationInfoImpl.isInStressTest())) {
            StubTextInconsistencyException.checkStubTextConsistency(psiFile);
            if (PsiDocumentManager.getInstance((Project)psiFile.getProject()).hasUncommitedDocuments()) {
                PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitAllDocuments();
                StubTextInconsistencyException.checkStubTextConsistency(psiFile);
            }
        }
    }

    public void afterItemInsertion(CompletionProgressIndicator indicator, Runnable laterRunnable) {
        if (laterRunnable != null) {
            ActionTracker tracker = new ActionTracker(indicator.getEditor(), indicator);
            Runnable wrapper2 = () -> {
                if (!(Disposer.isDisposed((Disposable)indicator) || indicator.getProject().isDisposed() || tracker.hasAnythingHappened())) {
                    laterRunnable.run();
                }
                indicator.disposeIndicator();
            };
            if (this.isTestingMode()) {
                wrapper2.run();
            } else {
                ApplicationManager.getApplication().invokeLater(wrapper2);
            }
        } else {
            indicator.disposeIndicator();
        }
    }

    private static CompletionAssertions.WatchingInsertionContext insertItem(List<LookupElement> lookupItems, LookupElement item, char completionChar, StatisticsUpdate update2, Editor editor, PsiFile psiFile, int caretOffset, int idEndOffset, OffsetMap offsetMap) {
        editor.getCaretModel().moveToOffset(caretOffset);
        CompletionAssertions.WatchingInsertionContext context = CompletionUtil.createInsertionContext(lookupItems, item, completionChar, editor, psiFile, caretOffset, idEndOffset, offsetMap);
        int initialStartOffset = Math.max(0, caretOffset - item.getLookupString().length());
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                Document document;
                if (caretOffset < idEndOffset && completionChar == '\t' && (document = editor.getDocument()).getRangeGuard(caretOffset, idEndOffset) == null) {
                    document.deleteString(caretOffset, idEndOffset);
                }
                assert (context.getStartOffset() >= 0) : "stale startOffset: was " + initialStartOffset + "; selEnd=" + caretOffset + "; idEnd=" + idEndOffset + "; file=" + psiFile;
                assert (context.getTailOffset() >= 0) : "stale tail: was " + initialStartOffset + "; selEnd=" + caretOffset + "; idEnd=" + idEndOffset + "; file=" + psiFile;
                Project project = psiFile.getProject();
                if (item.requiresCommittedDocuments()) {
                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                }
                FileBasedIndex.getInstance().ignoreDumbMode(() -> item.handleInsert((InsertionContext)context), DumbModeAccessType.RELIABLE_DATA_ONLY);
                PostprocessReformattingAspect.getInstance(project).doPostponedFormatting();
            }
            finally {
                context.stopWatching();
            }
            EditorModificationUtil.scrollToCaret((Editor)editor);
        });
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompletionAssertions.WatchingInsertionContext callHandleInsert(CompletionProgressIndicator indicator, LookupElement item, char completionChar) {
        Editor editor = indicator.getEditor();
        int caretOffset = indicator.getCaret().getOffset();
        int idEndOffset = CompletionUtil.calcIdEndOffset(indicator.getOffsetMap(), editor, indicator.getCaret().getOffset());
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)indicator.getProject());
        CompletionAssertions.WatchingInsertionContext context = CompletionUtil.createInsertionContext(indicator.getLookup().getItems(), item, completionChar, editor, psiFile, caretOffset, idEndOffset, indicator.getOffsetMap());
        try {
            item.handleInsert((InsertionContext)context);
        }
        finally {
            context.stopWatching();
        }
        return context;
    }

    public static void addCompletionChar(InsertionContext context, LookupElement item) {
        if (!context.getOffsetMap().containsOffset(InsertionContext.TAIL_OFFSET)) {
            String message = "tailOffset<0 after inserting " + item + " of " + item.getClass();
            if (context instanceof CompletionAssertions.WatchingInsertionContext) {
                message = message + "; invalidated at: " + ((CompletionAssertions.WatchingInsertionContext)context).invalidateTrace + "\n--------";
            }
            LOG.info(message);
        } else if (!CompletionAssertions.isEditorValid(context.getEditor())) {
            LOG.info("Injected editor invalidated " + context.getEditor());
        } else {
            context.getEditor().getCaretModel().moveToOffset(context.getTailOffset());
        }
        if (context.getCompletionChar() == '\r') {
            Language language = PsiUtilBase.getLanguageInEditor((Editor)context.getEditor(), (Project)context.getFile().getProject());
            if (language != null) {
                SmartEnterProcessor processor2;
                Iterator iterator2 = SmartEnterProcessors.INSTANCE.allForLanguage(language).iterator();
                while (iterator2.hasNext() && !(processor2 = (SmartEnterProcessor)iterator2.next()).processAfterCompletion(context.getEditor(), context.getFile())) {
                }
            }
        } else {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)context.getEditor().getContentComponent());
            EditorActionManager.getInstance();
            TypedAction.getInstance().getHandler().execute(context.getEditor(), context.getCompletionChar(), dataContext);
        }
    }

    private static boolean isAutocompleteOnInvocation(CompletionType type) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (type == CompletionType.SMART) {
            return settings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION;
        }
        return settings.AUTOCOMPLETE_ON_CODE_COMPLETION;
    }

    private static Runnable rememberDocumentState(Editor _editor) {
        Editor editor = InjectedLanguageUtil.getTopLevelEditor(_editor);
        String documentText = editor.getDocument().getText();
        int caret = editor.getCaretModel().getOffset();
        int selStart = editor.getSelectionModel().getSelectionStart();
        int selEnd = editor.getSelectionModel().getSelectionEnd();
        int vOffset = editor.getScrollingModel().getVerticalScrollOffset();
        int hOffset = editor.getScrollingModel().getHorizontalScrollOffset();
        return () -> {
            DocumentEx document = (DocumentEx)editor.getDocument();
            document.replaceString(0, document.getTextLength(), documentText);
            editor.getCaretModel().moveToOffset(caret);
            editor.getSelectionModel().setSelection(selStart, selEnd);
            editor.getScrollingModel().scrollHorizontally(hOffset);
            editor.getScrollingModel().scrollVertically(vOffset);
        };
    }

    private static void clearCaretMarkers(@NotNull Editor editor) {
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            caret.putUserData(CARET_PROCESSED, null);
        }
    }

    private static void markCaretAsProcessed(@NotNull Caret caret) {
        caret.putUserData(CARET_PROCESSED, (Object)Boolean.TRUE);
    }

    private static Caret getNextCaretToProcess(@NotNull Editor editor) {
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            if (caret.getUserData(CARET_PROCESSED) != null) continue;
            return caret;
        }
        return null;
    }

    @Nullable
    private <T> T withTimeout(long maxDurationMillis, @NotNull Computable<T> task2) {
        if (this.isTestingMode()) {
            return (T)task2.compute();
        }
        return ProgressIndicatorUtils.withTimeout(maxDurationMillis, task2);
    }

    private static int calcSyncTimeOut(long startTime) {
        return (int)Math.max(300L, (long)ourAutoInsertItemTimeout - (System.currentTimeMillis() - startTime));
    }

    public static void setAutoInsertTimeout(int timeout) {
        ourAutoInsertItemTimeout = timeout;
    }

    protected boolean isTestingCompletionQualityMode() {
        return false;
    }

    protected boolean isTestingMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || this.isTestingCompletionQualityMode();
    }
}

