/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInspection.HintAction;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerImpl;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptimizeImportsProcessor
extends AbstractLayoutCodeProcessor {
    @Deprecated
    public static final String COMMAND_NAME = "Optimize Imports";
    private final List<NotificationInfo> myOptimizerNotifications = new SmartList();

    public OptimizeImportsProcessor(@NotNull Project project) {
        super(project, OptimizeImportsProcessor.getCommandName(), OptimizeImportsProcessor.getProgressText(), false);
    }

    public OptimizeImportsProcessor(@NotNull Project project, Module module) {
        super(project, module, OptimizeImportsProcessor.getCommandName(), OptimizeImportsProcessor.getProgressText(), false);
    }

    public OptimizeImportsProcessor(@NotNull Project project, @NotNull PsiDirectory directory, boolean includeSubdirs) {
        super(project, directory, includeSubdirs, OptimizeImportsProcessor.getProgressText(), OptimizeImportsProcessor.getCommandName(), false);
    }

    public OptimizeImportsProcessor(@NotNull Project project, @NotNull PsiDirectory directory, boolean includeSubdirs, boolean processOnlyVcsChangedFiles) {
        super(project, directory, includeSubdirs, OptimizeImportsProcessor.getProgressText(), OptimizeImportsProcessor.getCommandName(), processOnlyVcsChangedFiles);
    }

    public OptimizeImportsProcessor(@NotNull Project project, @NotNull PsiFile file2) {
        super(project, file2, OptimizeImportsProcessor.getProgressText(), OptimizeImportsProcessor.getCommandName(), false);
    }

    public OptimizeImportsProcessor(@NotNull Project project, PsiFile @NotNull [] files2, Runnable postRunnable) {
        this(project, files2, OptimizeImportsProcessor.getCommandName(), postRunnable);
    }

    public OptimizeImportsProcessor(@NotNull Project project, PsiFile @NotNull [] files2, @NotNull String commandName, Runnable postRunnable) {
        super(project, files2, OptimizeImportsProcessor.getProgressText(), commandName, postRunnable, false);
    }

    public OptimizeImportsProcessor(@NotNull AbstractLayoutCodeProcessor processor2) {
        super(processor2, OptimizeImportsProcessor.getCommandName(), OptimizeImportsProcessor.getProgressText());
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (DumbService.isDumb((Project)file2.getProject())) {
            return OptimizeImportsProcessor.emptyTask();
        }
        List<Runnable> runnables = OptimizeImportsProcessor.collectOptimizers(file2);
        if (runnables.isEmpty()) {
            return OptimizeImportsProcessor.emptyTask();
        }
        List<HintAction> hints2 = ShowAutoImportPass.getImportHints(file2);
        return new FutureTask<Boolean>(() -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            CodeStyleManagerImpl.setSequentialProcessingAllowed(false);
            try {
                for (Runnable runnable1 : runnables) {
                    runnable1.run();
                    this.myOptimizerNotifications.add(OptimizeImportsProcessor.getNotificationInfo(runnable1));
                }
                this.putNotificationInfoIntoCollector();
                ShowAutoImportPass.fixAllImportsSilently(file2, hints2);
            }
            finally {
                CodeStyleManagerImpl.setSequentialProcessingAllowed(true);
            }
        }, true);
    }

    @NotNull
    private static FutureTask<Boolean> emptyTask() {
        return new FutureTask<Boolean>(EmptyRunnable.INSTANCE, true);
    }

    @NotNull
    static List<Runnable> collectOptimizers(@NotNull PsiFile file2) {
        Set optimizers = LanguageImportStatements.INSTANCE.forFile(file2);
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        List files2 = file2.getViewProvider().getAllFiles();
        for (ImportOptimizer optimizer : optimizers) {
            for (PsiFile psiFile : files2) {
                if (!optimizer.supports(psiFile)) continue;
                runnables.add(optimizer.processFile(psiFile));
            }
        }
        return runnables;
    }

    @NotNull
    private static NotificationInfo getNotificationInfo(@NotNull Runnable runnable2) {
        if (runnable2 instanceof ImportOptimizer.CollectingInfoRunnable) {
            String optimizerMessage = ((ImportOptimizer.CollectingInfoRunnable)runnable2).getUserNotificationInfo();
            return optimizerMessage == null ? NotificationInfo.NOTHING_CHANGED_NOTIFICATION : new NotificationInfo(optimizerMessage);
        }
        if (runnable2 == EmptyRunnable.getInstance()) {
            return NotificationInfo.NOTHING_CHANGED_NOTIFICATION;
        }
        return NotificationInfo.SOMETHING_CHANGED_WITHOUT_MESSAGE_NOTIFICATION;
    }

    private void putNotificationInfoIntoCollector() {
        LayoutCodeInfoCollector collector = this.getInfoCollector();
        if (collector == null) {
            return;
        }
        boolean atLeastOneOptimizerChangedSomething = false;
        for (NotificationInfo info : this.myOptimizerNotifications) {
            atLeastOneOptimizerChangedSomething |= info.isSomethingChanged();
            if (info.getMessage() == null) continue;
            collector.setOptimizeImportsNotification(info.getMessage());
            return;
        }
        collector.setOptimizeImportsNotification(atLeastOneOptimizerChangedSomething ? "imports optimized" : null);
    }

    @NotNull
    private static String getProgressText() {
        return CodeInsightBundle.message((String)"progress.text.optimizing.imports", (Object[])new Object[0]);
    }

    @NotNull
    public static String getCommandName() {
        return CodeInsightBundle.message((String)"process.optimize.imports", (Object[])new Object[0]);
    }

    static class NotificationInfo {
        static final NotificationInfo NOTHING_CHANGED_NOTIFICATION = new NotificationInfo(false, null);
        static final NotificationInfo SOMETHING_CHANGED_WITHOUT_MESSAGE_NOTIFICATION = new NotificationInfo(true, null);
        private final boolean mySomethingChanged;
        private final String myMessage;

        NotificationInfo(@NotNull String message) {
            this(true, message);
        }

        public boolean isSomethingChanged() {
            return this.mySomethingChanged;
        }

        public String getMessage() {
            return this.myMessage;
        }

        private NotificationInfo(boolean isSomethingChanged, @Nullable String message) {
            this.mySomethingChanged = isSomethingChanged;
            this.myMessage = message;
        }
    }
}

