/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.CodeCleanupCodeProcessor;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.codeInsight.actions.LayoutCodeOptions;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileInEditorProcessor {
    private static final Logger LOG = Logger.getInstance(FileInEditorProcessor.class);
    private final Editor myEditor;
    private boolean myNoChangesDetected = false;
    private final boolean myProcessChangesTextOnly;
    private final boolean myProcessSelectedText;
    private final LayoutCodeOptions myOptions;
    private final Project myProject;
    private final PsiFile myFile;
    private AbstractLayoutCodeProcessor myProcessor;

    public FileInEditorProcessor(PsiFile file2, Editor editor, LayoutCodeOptions runOptions) {
        this.myFile = file2;
        this.myProject = file2.getProject();
        this.myEditor = editor;
        this.myOptions = runOptions;
        this.myProcessSelectedText = this.myEditor != null && runOptions.getTextRangeType() == TextRangeType.SELECTED_TEXT;
        this.myProcessChangesTextOnly = runOptions.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT;
    }

    public void processCode() {
        if (!CodeStyle.isFormattingEnabled((PsiFile)this.myFile)) {
            if (!FileInEditorProcessor.isInHeadlessMode() && !this.myEditor.isDisposed() && this.myEditor.getComponent().isShowing()) {
                FileInEditorProcessor.showHint(this.myEditor, new DisabledFormattingMessageBuilder());
            }
            return;
        }
        if (this.myOptions.isOptimizeImports()) {
            this.myProcessor = new OptimizeImportsProcessor(this.myProject, this.myFile);
        }
        if (this.myProcessChangesTextOnly && !VcsFacade.getInstance().hasChanges(this.myFile)) {
            this.myNoChangesDetected = true;
        }
        this.myProcessor = this.mixWithReformatProcessor(this.myProcessor);
        if (this.myOptions.isRearrangeCode()) {
            this.myProcessor = this.mixWithRearrangeProcessor(this.myProcessor);
        }
        if (this.myOptions.isCodeCleanup()) {
            this.myProcessor = this.mixWithCleanupProcessor(this.myProcessor);
        }
        if (this.shouldNotify()) {
            this.myProcessor.setCollectInfo(true);
            this.myProcessor.setPostRunnable(() -> {
                if (!this.myEditor.isDisposed() && this.myEditor.getComponent().isShowing()) {
                    FileInEditorProcessor.showHint(this.myEditor, new FormattedMessageBuilder());
                }
            });
        }
        this.myProcessor.run();
        if (this.myEditor != null && this.myOptions.getTextRangeType() == TextRangeType.WHOLE_FILE) {
            CodeStyleSettingsManager.getInstance((Project)this.myProject).notifyCodeStyleSettingsChanged();
        }
    }

    @NotNull
    private AbstractLayoutCodeProcessor mixWithCleanupProcessor(@NotNull AbstractLayoutCodeProcessor processor2) {
        processor2 = this.myProcessSelectedText ? new CodeCleanupCodeProcessor(processor2, this.myEditor.getSelectionModel()) : new CodeCleanupCodeProcessor(processor2);
        return processor2;
    }

    private AbstractLayoutCodeProcessor mixWithRearrangeProcessor(@NotNull AbstractLayoutCodeProcessor processor2) {
        processor2 = this.myProcessSelectedText ? new RearrangeCodeProcessor(processor2, this.myEditor.getSelectionModel()) : new RearrangeCodeProcessor(processor2);
        return processor2;
    }

    @NotNull
    private AbstractLayoutCodeProcessor mixWithReformatProcessor(@Nullable AbstractLayoutCodeProcessor processor2) {
        processor2 = processor2 != null ? (this.myProcessSelectedText ? new ReformatCodeProcessor(processor2, this.myEditor.getSelectionModel()) : new ReformatCodeProcessor(processor2, this.myProcessChangesTextOnly)) : (this.myProcessSelectedText ? new ReformatCodeProcessor(this.myFile, this.myEditor.getSelectionModel()) : new ReformatCodeProcessor(this.myFile, this.myProcessChangesTextOnly));
        return processor2;
    }

    @NotNull
    private static String joinWithCommaAndCapitalize(String reformatNotification, String rearrangeNotification) {
        String firstNotificationLine;
        String string = firstNotificationLine = reformatNotification != null ? reformatNotification : rearrangeNotification;
        if (reformatNotification != null && rearrangeNotification != null) {
            firstNotificationLine = firstNotificationLine + ", " + rearrangeNotification;
        }
        firstNotificationLine = StringUtil.capitalize((String)firstNotificationLine);
        return firstNotificationLine;
    }

    private static void showHint(@NotNull Editor editor, @NotNull MessageBuilder messageBuilder) {
        FileInEditorProcessor.showHint(editor, messageBuilder.getMessage(), messageBuilder.createHyperlinkListener());
    }

    public static void showHint(@NotNull Editor editor, @NotNull String info, @Nullable HyperlinkListener hyperlinkListener) {
        JComponent component2 = HintUtil.createInformationLabel(info, hyperlinkListener, null, null);
        LightweightHint hint = new LightweightHint(component2);
        int flags = 42;
        if (EditorUtil.isPrimaryCaretVisible(editor)) {
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, flags, 0, false);
        } else {
            FileInEditorProcessor.showHintWithoutScroll(editor, hint, flags);
        }
    }

    private static void showHintWithoutScroll(Editor editor, LightweightHint hint, int flags) {
        short constraint;
        int y;
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        if (FileInEditorProcessor.isCaretAboveTop(editor, visibleArea)) {
            y = visibleArea.y;
            constraint = 2;
        } else {
            y = visibleArea.y + visibleArea.height;
            constraint = 1;
        }
        Point hintPoint = new Point(visibleArea.x + visibleArea.width / 2, y);
        JComponent component2 = HintManagerImpl.getExternalComponent(editor);
        Point convertedPoint = SwingUtilities.convertPoint(editor.getContentComponent(), hintPoint, component2);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, convertedPoint, flags, 0, false, constraint);
    }

    private static boolean isCaretAboveTop(Editor editor, Rectangle area) {
        Caret caret = editor.getCaretModel().getCurrentCaret();
        VisualPosition caretVisualPosition = caret.getVisualPosition();
        int caretY = editor.visualPositionToXY((VisualPosition)caretVisualPosition).y;
        return caretY < area.y;
    }

    private boolean shouldNotify() {
        if (FileInEditorProcessor.isInHeadlessMode()) {
            return false;
        }
        EditorSettingsExternalizable es = EditorSettingsExternalizable.getInstance();
        return es.isShowNotificationAfterReformat() && this.myEditor != null && !this.myProcessSelectedText;
    }

    private static boolean isInHeadlessMode() {
        Application application = ApplicationManager.getApplication();
        return application.isUnitTestMode() || application.isHeadlessEnvironment();
    }

    private static abstract class MessageBuilder {
        private MessageBuilder() {
        }

        public abstract String getMessage();

        public abstract Runnable getHyperlinkRunnable();

        public final HyperlinkListener createHyperlinkListener() {
            return new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    this.getHyperlinkRunnable().run();
                }
            };
        }
    }

    private class FormattedMessageBuilder
    extends MessageBuilder {
        private FormattedMessageBuilder() {
        }

        @Override
        @NotNull
        public String getMessage() {
            StringBuilder builder2 = new StringBuilder("<html>");
            LayoutCodeInfoCollector notifications = FileInEditorProcessor.this.myProcessor.getInfoCollector();
            LOG.assertTrue(notifications != null);
            if (notifications.isEmpty() && !FileInEditorProcessor.this.myNoChangesDetected) {
                if (FileInEditorProcessor.this.myProcessChangesTextOnly) {
                    builder2.append("No lines changed: changes since last revision are already properly formatted").append("<br>");
                } else {
                    builder2.append("No lines changed: content is already properly formatted").append("<br>");
                }
            } else {
                if (notifications.hasReformatOrRearrangeNotification()) {
                    String reformatInfo = notifications.getReformatCodeNotification();
                    String rearrangeInfo = notifications.getRearrangeCodeNotification();
                    builder2.append(FileInEditorProcessor.joinWithCommaAndCapitalize(reformatInfo, rearrangeInfo));
                    if (FileInEditorProcessor.this.myProcessChangesTextOnly) {
                        builder2.append(" in changes since last revision");
                    }
                    builder2.append("<br>");
                } else if (FileInEditorProcessor.this.myNoChangesDetected) {
                    builder2.append("No lines changed: no changes since last revision").append("<br>");
                }
                String optimizeImportsNotification = notifications.getOptimizeImportsNotification();
                if (optimizeImportsNotification != null) {
                    builder2.append(StringUtil.capitalize((String)optimizeImportsNotification)).append("<br>");
                }
            }
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowReformatFileDialog"));
            String color = ColorUtil.toHex((Color)JBColor.gray);
            builder2.append("<span style='color:#").append(color).append("'>").append("<a href=''>Show</a> reformat dialog: ").append(shortcutText).append("</span>").append("</html>");
            return builder2.toString();
        }

        @Override
        public Runnable getHyperlinkRunnable() {
            return () -> {
                AnAction action2 = ActionManager.getInstance().getAction("ShowReformatFileDialog");
                DataManager manager = DataManager.getInstance();
                if (manager != null) {
                    DataContext context = manager.getDataContext((Component)FileInEditorProcessor.this.myEditor.getContentComponent());
                    action2.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"", (DataContext)context));
                }
            };
        }
    }

    private class DisabledFormattingMessageBuilder
    extends MessageBuilder {
        private DisabledFormattingMessageBuilder() {
        }

        @Override
        @NotNull
        public String getMessage() {
            VirtualFile virtualFile = FileInEditorProcessor.this.myFile.getVirtualFile();
            String name = virtualFile != null ? virtualFile.getName() : "the file";
            return "<html>Formatting is disabled for " + name + "<p><span><a href=''>Show settings...</a></span></html>";
        }

        @Override
        public Runnable getHyperlinkRunnable() {
            return () -> ShowSettingsUtilImpl.showSettingsDialog(FileInEditorProcessor.this.myProject, "preferences.sourceCode", "Do not format");
        }
    }
}

