/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;

public class CodeCleanupCodeProcessor
extends AbstractLayoutCodeProcessor {
    public static final String COMMAND_NAME = "Cleanup code";
    private SelectionModel mySelectionModel = null;

    public CodeCleanupCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor) {
        super(previousProcessor, COMMAND_NAME, CodeCleanupCodeProcessor.getProgressText());
    }

    public CodeCleanupCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor, @NotNull SelectionModel selectionModel) {
        super(previousProcessor, COMMAND_NAME, CodeCleanupCodeProcessor.getProgressText());
        this.mySelectionModel = selectionModel;
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        return new FutureTask<Boolean>(() -> {
            Collection<TextRange> ranges = this.getRanges(file2, processChangedTextOnly);
            GlobalInspectionContextBase.cleanupElements(this.myProject, null, descriptor2 -> CodeCleanupCodeProcessor.isInRanges(ranges, descriptor2), new PsiElement[]{file2});
            return true;
        });
    }

    private Collection<TextRange> getRanges(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (this.mySelectionModel != null) {
            return CodeCleanupCodeProcessor.getSelectedRanges(this.mySelectionModel);
        }
        if (processChangedTextOnly) {
            return VcsFacade.getInstance().getChangedTextRanges(this.myProject, file2);
        }
        return new SmartList((Object)file2.getTextRange());
    }

    private static boolean isInRanges(Collection<? extends TextRange> ranges, @NotNull ProblemDescriptor descriptor2) {
        for (TextRange textRange : ranges) {
            if (!textRange.containsOffset(descriptor2.getStartElement().getTextOffset()) && !textRange.containsOffset(descriptor2.getEndElement().getTextOffset())) continue;
            return true;
        }
        return false;
    }

    public static String getProgressText() {
        return CodeInsightBundle.message((String)"process.cleanup.code", (Object[])new Object[0]);
    }
}

