/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.events.impl;

import com.intellij.build.events.BuildIssueEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.impl.AbstractBuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class BuildIssueEventImpl
extends AbstractBuildEvent
implements BuildIssueEvent {
    private final BuildIssue myIssue;
    private final MessageEvent.Kind myKind;

    public BuildIssueEventImpl(@NotNull Object parentId, @NotNull BuildIssue buildIssue, @NotNull MessageEvent.Kind kind) {
        super(new Object(), parentId, System.currentTimeMillis(), buildIssue.getTitle());
        this.myIssue = buildIssue;
        this.myKind = kind;
    }

    @Override
    @NotNull
    public final String getDescription() {
        return this.myIssue.getDescription();
    }

    @NotNull
    public BuildIssue getIssue() {
        return this.myIssue;
    }

    @NotNull
    public MessageEvent.Kind getKind() {
        return this.myKind;
    }

    @NotNull
    public String getGroup() {
        return "Build issues";
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Project project) {
        return this.myIssue.getNavigatable(project);
    }

    public MessageEventResult getResult() {
        return new MessageEventResult(){

            public MessageEvent.Kind getKind() {
                return BuildIssueEventImpl.this.myKind;
            }

            @NotNull
            public String getDetails() {
                return BuildIssueEventImpl.this.myIssue.getDescription();
            }
        };
    }
}

