/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.AbstractViewManager;
import com.intellij.build.BuildContentDescriptor;
import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.BuildView;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.FinishEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class MultipleBuildsView
implements BuildProgressListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(MultipleBuildsView.class);
    @NonNls
    private static final String SPLITTER_PROPERTY = "MultipleBuildsView.Splitter.Proportion";
    protected final Project myProject;
    protected final BuildContentManager myBuildContentManager;
    private final AtomicBoolean isInitializeStarted;
    private final AtomicBoolean isFirstErrorShown = new AtomicBoolean();
    private final List<Runnable> myPostponedRunnables;
    private final ProgressWatcher myProgressWatcher;
    private final OnePixelSplitter myThreeComponentsSplitter;
    private final JBList<AbstractViewManager.BuildInfo> myBuildsList;
    private final Map<Object, AbstractViewManager.BuildInfo> myBuildsMap;
    private final Map<AbstractViewManager.BuildInfo, BuildView> myViewMap;
    private final AbstractViewManager myViewManager;
    private volatile Content myContent;
    private volatile DefaultActionGroup myToolbarActions;
    private volatile boolean myDisposed;

    public MultipleBuildsView(Project project, BuildContentManager buildContentManager, AbstractViewManager viewManager) {
        this.myProject = project;
        this.myBuildContentManager = buildContentManager;
        this.myViewManager = viewManager;
        this.isInitializeStarted = new AtomicBoolean();
        this.myPostponedRunnables = ContainerUtil.createConcurrentList();
        this.myThreeComponentsSplitter = new OnePixelSplitter(SPLITTER_PROPERTY, 0.25f);
        this.myBuildsList = new JBList();
        this.myBuildsList.setModel(new DefaultListModel());
        this.myBuildsList.setFixedCellHeight(40);
        this.myBuildsList.installCellRenderer(obj -> {
            JPanel panel2 = new JPanel(new BorderLayout());
            SimpleColoredComponent mainComponent = new SimpleColoredComponent();
            mainComponent.setIcon(obj.getIcon());
            mainComponent.append(obj.getTitle() + ": ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            mainComponent.append(obj.message, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            panel2.add((Component)mainComponent, "North");
            if (obj.statusMessage != null) {
                SimpleColoredComponent statusComponent = new SimpleColoredComponent();
                statusComponent.setIcon(EmptyIcon.ICON_16);
                statusComponent.append(obj.statusMessage, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                panel2.add((Component)statusComponent, "South");
            }
            return panel2;
        });
        this.myViewMap = new ConcurrentHashMap<AbstractViewManager.BuildInfo, BuildView>();
        this.myBuildsMap = new ConcurrentHashMap<Object, AbstractViewManager.BuildInfo>();
        this.myProgressWatcher = new ProgressWatcher();
    }

    public void dispose() {
        this.myDisposed = true;
    }

    public Content getContent() {
        return this.myContent;
    }

    public Map<BuildDescriptor, BuildView> getBuildsMap() {
        return Collections.unmodifiableMap(this.myViewMap);
    }

    public boolean shouldConsume(@NotNull Object buildId) {
        return this.myBuildsMap.containsKey(buildId);
    }

    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        AbstractViewManager.BuildInfo buildInfo;
        SmartList runOnEdt = new SmartList();
        if (event instanceof StartBuildEvent) {
            StartBuildEvent startBuildEvent = (StartBuildEvent)event;
            if (this.isInitializeStarted.get()) {
                this.clearOldBuilds((List<Runnable>)runOnEdt, startBuildEvent);
            }
            buildInfo = new AbstractViewManager.BuildInfo(((StartBuildEvent)event).getBuildDescriptor());
            this.myBuildsMap.put(buildId, buildInfo);
        } else {
            buildInfo = this.myBuildsMap.get(buildId);
        }
        if (buildInfo == null) {
            LOG.warn("Build can not be found for buildId: '" + buildId + "'");
            return;
        }
        runOnEdt.add(() -> {
            if (event instanceof StartBuildEvent) {
                Runnable activationCallback;
                RunContentDescriptor contentDescriptor;
                buildInfo.message = event.getMessage();
                DefaultListModel listModel = (DefaultListModel)this.myBuildsList.getModel();
                listModel.addElement(buildInfo);
                Supplier<RunContentDescriptor> contentDescriptorSupplier = buildInfo.getContentDescriptorSupplier();
                RunContentDescriptor runContentDescriptor = contentDescriptor = contentDescriptorSupplier != null ? contentDescriptorSupplier.get() : null;
                if (contentDescriptor != null) {
                    buildInfo.setActivateToolWindowWhenAdded(contentDescriptor.isActivateToolWindowWhenAdded());
                    if (contentDescriptor instanceof BuildContentDescriptor) {
                        buildInfo.setActivateToolWindowWhenFailed(((BuildContentDescriptor)contentDescriptor).isActivateToolWindowWhenFailed());
                    }
                    buildInfo.setAutoFocusContent(contentDescriptor.isAutoFocusContent());
                    activationCallback = contentDescriptor.getActivationCallback();
                } else {
                    activationCallback = null;
                }
                BuildView view = this.myViewMap.computeIfAbsent(buildInfo, info -> {
                    String selectionStateKey = "build.toolwindow." + this.myViewManager.getViewName() + ".selection.state";
                    BuildView buildView = new BuildView(this.myProject, buildInfo, selectionStateKey, this.myViewManager);
                    Disposer.register((Disposable)this, (Disposable)buildView);
                    if (contentDescriptor != null) {
                        Disposer.register((Disposable)buildView, (Disposable)contentDescriptor);
                    }
                    return buildView;
                });
                view.onEvent(buildId, event);
                this.myContent.setPreferredFocusedComponent(view::getPreferredFocusableComponent);
                this.myBuildContentManager.setSelectedContent(this.myContent, buildInfo.isAutoFocusContent(), buildInfo.isAutoFocusContent(), buildInfo.isActivateToolWindowWhenAdded(), activationCallback);
                buildInfo.content = this.myContent;
                if (this.myThreeComponentsSplitter.getSecondComponent() == null) {
                    this.myThreeComponentsSplitter.setSecondComponent((JComponent)view);
                    this.myViewManager.configureToolbar(this.myToolbarActions, this, view);
                }
                if (this.myBuildsList.getModel().getSize() > 1) {
                    JBScrollPane scrollPane = new JBScrollPane();
                    scrollPane.setBorder((Border)JBUI.Borders.empty());
                    scrollPane.setViewportView(this.myBuildsList);
                    this.myThreeComponentsSplitter.setFirstComponent((JComponent)scrollPane);
                    this.myBuildsList.setVisible(true);
                    this.myBuildsList.setSelectedIndex(0);
                    for (BuildView consoleView : this.myViewMap.values()) {
                        BuildTreeConsoleView buildConsoleView = consoleView.getView(BuildTreeConsoleView.class.getName(), BuildTreeConsoleView.class);
                        if (buildConsoleView == null) continue;
                        buildConsoleView.hideRootNode();
                    }
                } else {
                    this.myThreeComponentsSplitter.setFirstComponent(null);
                }
                this.myViewManager.onBuildStart(buildInfo);
                this.myProgressWatcher.addBuild(buildInfo);
                ((BuildContentManagerImpl)this.myBuildContentManager).startBuildNotified(buildInfo, buildInfo.content, buildInfo.getProcessHandler());
            } else {
                BuildView view;
                if ((!this.isFirstErrorShown.get() && event instanceof FinishEvent && ((FinishEvent)event).getResult() instanceof FailureResult || event instanceof MessageEvent && ((MessageEvent)event).getResult().getKind() == MessageEvent.Kind.ERROR) && this.isFirstErrorShown.compareAndSet(false, true)) {
                    ListModel listModel = this.myBuildsList.getModel();
                    IntStream.range(0, listModel.getSize()).filter(i2 -> buildInfo == listModel.getElementAt(i2)).findFirst().ifPresent(arg_0 -> this.myBuildsList.setSelectedIndex(arg_0));
                }
                if ((view = this.myViewMap.get(buildInfo)) != null) {
                    view.onEvent(buildId, event);
                }
                if (event instanceof FinishBuildEvent) {
                    buildInfo.endTime = event.getEventTime();
                    buildInfo.message = event.getMessage();
                    buildInfo.result = ((FinishBuildEvent)event).getResult();
                    this.myProgressWatcher.stopBuild(buildInfo);
                    ((BuildContentManagerImpl)this.myBuildContentManager).finishBuildNotified(buildInfo, buildInfo.content);
                    this.myViewManager.onBuildFinish(buildInfo);
                } else {
                    buildInfo.statusMessage = event.getMessage();
                }
            }
        });
        if (this.myContent == null) {
            this.myPostponedRunnables.addAll((Collection<Runnable>)runOnEdt);
            if (this.isInitializeStarted.compareAndSet(false, true)) {
                EdtExecutorService.getInstance().execute(() -> {
                    if (this.myDisposed) {
                        return;
                    }
                    this.myBuildsList.setSelectionMode(0);
                    this.myBuildsList.addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            AbstractViewManager.BuildInfo selectedBuild = (AbstractViewManager.BuildInfo)MultipleBuildsView.this.myBuildsList.getSelectedValue();
                            if (selectedBuild == null) {
                                return;
                            }
                            BuildView view = (BuildView)MultipleBuildsView.this.myViewMap.get(selectedBuild);
                            JComponent lastComponent = MultipleBuildsView.this.myThreeComponentsSplitter.getSecondComponent();
                            if (view != null && lastComponent != view.getComponent()) {
                                MultipleBuildsView.this.myThreeComponentsSplitter.setSecondComponent(view.getComponent());
                                view.getComponent().setVisible(true);
                                if (lastComponent != null) {
                                    lastComponent.setVisible(false);
                                }
                                MultipleBuildsView.this.myViewManager.configureToolbar(MultipleBuildsView.this.myToolbarActions, MultipleBuildsView.this, view);
                                view.getComponent().repaint();
                            }
                        }
                    });
                    MultipleBuildsPanel consoleComponent = new MultipleBuildsPanel();
                    consoleComponent.add((Component)this.myThreeComponentsSplitter, "Center");
                    this.myToolbarActions = new DefaultActionGroup();
                    ActionToolbar tb = ActionManager.getInstance().createActionToolbar("BuildView", (ActionGroup)this.myToolbarActions, false);
                    tb.setTargetComponent((JComponent)consoleComponent);
                    tb.getComponent().setBorder(JBUI.Borders.merge((Border)tb.getComponent().getBorder(), (Border)JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)0, (int)1), (boolean)true));
                    consoleComponent.add((Component)tb.getComponent(), "West");
                    this.myContent = new ContentImpl(consoleComponent, this.myViewManager.getViewName(), true);
                    Disposer.register((Disposable)this.myContent, (Disposable)new Disposable(){

                        public void dispose() {
                            Disposer.dispose((Disposable)MultipleBuildsView.this);
                        }
                    });
                    Disposer.register((Disposable)this.myContent, (Disposable)new Disposable(){

                        public void dispose() {
                            MultipleBuildsView.this.myViewManager.onBuildsViewRemove(MultipleBuildsView.this);
                        }
                    });
                    Icon contentIcon = this.myViewManager.getContentIcon();
                    if (contentIcon != null) {
                        this.myContent.setIcon(contentIcon);
                        this.myContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                    }
                    this.myBuildContentManager.addContent(this.myContent);
                    ArrayList<Runnable> postponedRunnables = new ArrayList<Runnable>(this.myPostponedRunnables);
                    this.myPostponedRunnables.clear();
                    for (Runnable postponedRunnable : postponedRunnables) {
                        postponedRunnable.run();
                    }
                });
            }
        } else {
            EdtExecutorService.getInstance().execute(() -> this.lambda$onEvent$5((List)runOnEdt));
        }
    }

    private static boolean mayHaveChildren(BuildEvent event) {
        return !(event instanceof OutputBuildEvent) && !(event instanceof MessageEvent);
    }

    private void clearOldBuilds(List<Runnable> runOnEdt, StartBuildEvent startBuildEvent) {
        long currentTime = System.currentTimeMillis();
        DefaultListModel listModel = (DefaultListModel)this.myBuildsList.getModel();
        boolean clearAll = !listModel.isEmpty();
        SmartList sameBuildsToClear = new SmartList();
        for (int i2 = 0; i2 < listModel.getSize(); ++i2) {
            boolean buildFinishedRecently;
            AbstractViewManager.BuildInfo build2 = (AbstractViewManager.BuildInfo)listModel.getElementAt(i2);
            boolean sameBuild = build2.getWorkingDir().equals(startBuildEvent.getBuildDescriptor().getWorkingDir());
            if (!build2.isRunning() && sameBuild) {
                sameBuildsToClear.add(build2);
            }
            boolean bl = buildFinishedRecently = currentTime - build2.endTime < TimeUnit.SECONDS.toMillis(1L);
            if (!build2.isRunning() && (sameBuild || !buildFinishedRecently)) continue;
            clearAll = false;
        }
        if (clearAll) {
            this.myBuildsMap.clear();
            SmartList viewsToDispose = new SmartList(this.myViewMap.values());
            runOnEdt.add(() -> viewsToDispose.forEach(Disposer::dispose));
            this.myViewMap.clear();
            listModel.clear();
            runOnEdt.add(() -> {
                this.myBuildsList.setVisible(false);
                this.myThreeComponentsSplitter.setFirstComponent(null);
                this.myThreeComponentsSplitter.setSecondComponent(null);
            });
            this.myToolbarActions.removeAll();
            this.isFirstErrorShown.set(false);
        } else {
            sameBuildsToClear.forEach(info -> {
                BuildView buildView = this.myViewMap.remove(info);
                if (buildView != null) {
                    runOnEdt.add(() -> Disposer.dispose((Disposable)buildView));
                }
                listModel.removeElement(info);
            });
        }
    }

    @ApiStatus.Internal
    public BuildView getBuildView(Object buildId) {
        AbstractViewManager.BuildInfo buildInfo = this.myBuildsMap.get(buildId);
        if (buildInfo == null) {
            return null;
        }
        return this.myViewMap.get(buildInfo);
    }

    private /* synthetic */ void lambda$onEvent$5(List runOnEdt) {
        if (this.myDisposed) {
            return;
        }
        for (Runnable runnable2 : runOnEdt) {
            runnable2.run();
        }
    }

    private class ProgressWatcher
    implements Runnable {
        private final Alarm myRefreshAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        private final Set<AbstractViewManager.BuildInfo> myBuilds = ContainerUtil.newConcurrentSet();

        private ProgressWatcher() {
        }

        @Override
        public void run() {
            this.myRefreshAlarm.cancelAllRequests();
            JComponent firstComponent = MultipleBuildsView.this.myThreeComponentsSplitter.getFirstComponent();
            if (firstComponent != null) {
                firstComponent.revalidate();
                firstComponent.repaint();
            }
            if (!this.myBuilds.isEmpty()) {
                this.myRefreshAlarm.addRequest((Runnable)this, 300);
            }
        }

        void addBuild(AbstractViewManager.BuildInfo buildInfo) {
            this.myBuilds.add(buildInfo);
            if (this.myBuilds.size() > 1) {
                this.myRefreshAlarm.cancelAllRequests();
                this.myRefreshAlarm.addRequest((Runnable)this, 300);
            }
        }

        void stopBuild(AbstractViewManager.BuildInfo buildInfo) {
            this.myBuilds.remove(buildInfo);
        }
    }

    private class MultipleBuildsPanel
    extends JPanel
    implements OccurenceNavigator {
        MultipleBuildsPanel() {
            super(new BorderLayout());
        }

        public boolean hasNextOccurence() {
            return this.getOccurenceNavigator(true) != null;
        }

        @Nullable
        private Pair<Integer, Supplier<OccurenceNavigator.OccurenceInfo>> getOccurenceNavigator(boolean next) {
            if (MultipleBuildsView.this.myBuildsList.getItemsCount() == 0) {
                return null;
            }
            int index = Math.max(MultipleBuildsView.this.myBuildsList.getSelectedIndex(), 0);
            Function<Integer, Pair> function = i2 -> {
                AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)MultipleBuildsView.this.myBuildsList.getModel().getElementAt((int)i2);
                BuildView buildView = (BuildView)MultipleBuildsView.this.myViewMap.get(buildInfo);
                if (buildView == null) {
                    return null;
                }
                if (i2 != index) {
                    BuildTreeConsoleView eventView = buildView.getEventView();
                    if (eventView == null) {
                        return null;
                    }
                    eventView.getTree().clearSelection();
                }
                if (next) {
                    if (buildView.hasNextOccurence()) {
                        return Pair.create((Object)i2, buildView::goNextOccurence);
                    }
                } else {
                    if (buildView.hasPreviousOccurence()) {
                        return Pair.create((Object)i2, buildView::goPreviousOccurence);
                    }
                    if (i2 != index && buildView.hasNextOccurence()) {
                        return Pair.create((Object)i2, buildView::goNextOccurence);
                    }
                }
                return null;
            };
            if (next) {
                for (int i3 = index; i3 < MultipleBuildsView.this.myBuildsList.getItemsCount(); ++i3) {
                    Pair buildViewPair = function.apply(i3);
                    if (buildViewPair == null) continue;
                    return buildViewPair;
                }
            } else {
                for (int i4 = index; i4 >= 0; --i4) {
                    Pair buildViewPair = function.apply(i4);
                    if (buildViewPair == null) continue;
                    return buildViewPair;
                }
            }
            return null;
        }

        public boolean hasPreviousOccurence() {
            return this.getOccurenceNavigator(false) != null;
        }

        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            Pair<Integer, Supplier<OccurenceNavigator.OccurenceInfo>> navigator = this.getOccurenceNavigator(true);
            if (navigator != null) {
                MultipleBuildsView.this.myBuildsList.setSelectedIndex(((Integer)navigator.first).intValue());
                return (OccurenceNavigator.OccurenceInfo)((Supplier)navigator.second).get();
            }
            return null;
        }

        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            Pair<Integer, Supplier<OccurenceNavigator.OccurenceInfo>> navigator = this.getOccurenceNavigator(false);
            if (navigator != null) {
                MultipleBuildsView.this.myBuildsList.setSelectedIndex(((Integer)navigator.first).intValue());
                return (OccurenceNavigator.OccurenceInfo)((Supplier)navigator.second).get();
            }
            return null;
        }

        @NotNull
        public String getNextOccurenceActionName() {
            return IdeBundle.message((String)"action.next.problem", (Object[])new Object[0]);
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            return IdeBundle.message((String)"action.previous.problem", (Object[])new Object[0]);
        }
    }
}

