/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.BaseContentCloseListener;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildContentManagerImpl
implements BuildContentManager {
    public static final String Build = "Build";
    public static final String Sync = "Sync";
    public static final String Run = "Run";
    public static final String Debug = "Debug";
    private static final String[] ourPresetOrder = new String[]{"Sync", "Build", "Run", "Debug"};
    private static final Key<Map<Object, CloseListener>> CONTENT_CLOSE_LISTENERS = Key.create((String)"CONTENT_CLOSE_LISTENERS");
    private final Project myProject;
    private final Map<Content, Pair<Icon, AtomicInteger>> liveContentsMap = new ConcurrentHashMap<Content, Pair<Icon, AtomicInteger>>();

    public BuildContentManagerImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public ToolWindow getOrCreateToolWindow() {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(Build);
        if (toolWindow != null) {
            return toolWindow;
        }
        toolWindow = toolWindowManager.registerToolWindow(RegisterToolWindowTask.closable((String)Build, (Icon)AllIcons.Toolwindows.ToolWindowBuild));
        final ContentManager contentManager2 = toolWindow.getContentManager();
        contentManager2.addDataProvider(new DataProvider(){
            private int myInsideGetData = 0;

            public Object getData(@NotNull String dataId) {
                ++this.myInsideGetData;
                try {
                    Object object = this.myInsideGetData == 1 ? DataManager.getInstance().getDataContext((Component)contentManager2.getComponent()).getData(dataId) : null;
                    return object;
                }
                finally {
                    --this.myInsideGetData;
                }
            }
        });
        ContentManagerWatcher.watchContentManager(toolWindow, contentManager2);
        return toolWindow;
    }

    private void invokeLaterIfNeeded(@NotNull Runnable runnable2) {
        if (this.myProject.isDefault()) {
            return;
        }
        StartupManagerEx.getInstanceEx(this.myProject).runAfterOpened(() -> GuiUtils.invokeLaterIfNeeded((Runnable)runnable2, (ModalityState)ModalityState.defaultModalityState(), (Condition)this.myProject.getDisposed()));
    }

    public void addContent(Content content2) {
        this.invokeLaterIfNeeded(() -> {
            ContentManager contentManager2 = this.getOrCreateToolWindow().getContentManager();
            String name = content2.getTabName();
            String category = StringUtil.trimEnd((String)((String)StringUtil.split((String)name, (String)" ").get(0)), (char)':');
            int idx = -1;
            for (int i2 = 0; i2 < ourPresetOrder.length; ++i2) {
                String s = ourPresetOrder[i2];
                if (!s.equals(category)) continue;
                idx = i2;
                break;
            }
            Content[] existingContents = contentManager2.getContents();
            if (idx != -1) {
                Content[] existingCategoriesNames = new MultiMap();
                Content[] contentArray = existingContents;
                int n = contentArray.length;
                for (int j = 0; j < n; ++j) {
                    Content existingContent = contentArray[j];
                    String tabName = existingContent.getTabName();
                    existingCategoriesNames.putValue((Object)StringUtil.trimEnd((String)((String)StringUtil.split((String)tabName, (String)" ").get(0)), (char)':'), (Object)tabName);
                }
                int place = 0;
                for (int i3 = 0; i3 <= idx; ++i3) {
                    String key = ourPresetOrder[i3];
                    Collection tabNames = existingCategoriesNames.get((Object)key);
                    place += tabNames.size();
                }
                contentManager2.addContent(content2, place);
            } else {
                contentManager2.addContent(content2);
            }
            for (Content existingContent : existingContents) {
                existingContent.setDisplayName(existingContent.getTabName());
            }
            String tabName = content2.getTabName();
            this.updateTabDisplayName(content2, tabName);
        });
    }

    public void updateTabDisplayName(Content content2, String tabName) {
        this.invokeLaterIfNeeded(() -> {
            if (!tabName.equals(content2.getDisplayName())) {
                content2.setTabName(tabName);
                content2.setDisplayName(tabName);
            }
        });
    }

    public void removeContent(Content content2) {
        this.invokeLaterIfNeeded(() -> {
            ContentManager contentManager2;
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(Build);
            ContentManager contentManager3 = contentManager2 = toolWindow == null ? null : toolWindow.getContentManager();
            if (contentManager2 != null && !contentManager2.isDisposed()) {
                contentManager2.removeContent(content2, true);
            }
        });
    }

    public void setSelectedContent(@NotNull Content content2, boolean requestFocus, boolean forcedFocus, boolean activate2, @Nullable Runnable activationCallback) {
        this.invokeLaterIfNeeded(() -> {
            ToolWindow toolWindow = this.getOrCreateToolWindow();
            if (!toolWindow.isAvailable()) {
                return;
            }
            if (activate2) {
                toolWindow.show(activationCallback);
            }
            toolWindow.getContentManager().setSelectedContent(content2, requestFocus, forcedFocus, false);
        });
    }

    public Content addTabbedContent(@NotNull JComponent contentComponent, @NotNull String groupPrefix, @NotNull String tabName, @Nullable Icon icon2, @Nullable Disposable childDisposable) {
        TabbedContent tabbedContent;
        ContentManager contentManager2 = this.getOrCreateToolWindow().getContentManager();
        ContentUtilEx.addTabbedContent(contentManager2, contentComponent, groupPrefix, tabName, false, childDisposable);
        Content content2 = contentManager2.findContent(ContentUtilEx.getFullName(groupPrefix, tabName));
        if (icon2 != null && (tabbedContent = ContentUtilEx.findTabbedContent(contentManager2, groupPrefix)) != null) {
            tabbedContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            tabbedContent.setIcon(icon2);
        }
        return content2;
    }

    public void startBuildNotified(@NotNull BuildDescriptor buildDescriptor, @NotNull Content content2, @Nullable BuildProcessHandler processHandler2) {
        if (processHandler2 != null) {
            HashMap<Object, CloseListener> closeListenerMap = (HashMap<Object, CloseListener>)content2.getUserData(CONTENT_CLOSE_LISTENERS);
            if (closeListenerMap == null) {
                closeListenerMap = new HashMap<Object, CloseListener>();
                content2.putUserData(CONTENT_CLOSE_LISTENERS, closeListenerMap);
            }
            closeListenerMap.put(buildDescriptor.getId(), new CloseListener(content2, processHandler2));
        }
        Pair pair = this.liveContentsMap.computeIfAbsent(content2, c -> Pair.pair((Object)c.getIcon(), (Object)new AtomicInteger(0)));
        ((AtomicInteger)pair.second).incrementAndGet();
        content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        if (pair.first == null) {
            content2.putUserData(Content.TAB_LABEL_ORIENTATION_KEY, (Object)ComponentOrientation.RIGHT_TO_LEFT);
        }
        content2.setIcon(ExecutionUtil.getLiveIndicator((Icon)((Icon)pair.first), (int)0, (int)13));
        this.invokeLaterIfNeeded(() -> {
            JComponent component2 = content2.getComponent();
            component2.invalidate();
            if (!this.liveContentsMap.isEmpty()) {
                this.getOrCreateToolWindow().setIcon(ExecutionUtil.getLiveIndicator((Icon)AllIcons.Toolwindows.ToolWindowBuild));
            }
        });
    }

    public void finishBuildNotified(@NotNull BuildDescriptor buildDescriptor, @NotNull Content content2) {
        Pair<Icon, AtomicInteger> pair;
        CloseListener closeListener2;
        Map closeListenerMap = (Map)content2.getUserData(CONTENT_CLOSE_LISTENERS);
        if (closeListenerMap != null && (closeListener2 = (CloseListener)closeListenerMap.remove(buildDescriptor.getId())) != null) {
            closeListener2.dispose();
            if (closeListenerMap.isEmpty()) {
                content2.putUserData(CONTENT_CLOSE_LISTENERS, null);
            }
        }
        if ((pair = this.liveContentsMap.get(content2)) != null && ((AtomicInteger)pair.second).decrementAndGet() == 0) {
            content2.setIcon((Icon)pair.first);
            if (pair.first == null) {
                content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.FALSE);
            }
            this.liveContentsMap.remove(content2);
        }
        this.invokeLaterIfNeeded(() -> {
            if (this.liveContentsMap.isEmpty()) {
                this.getOrCreateToolWindow().setIcon(AllIcons.Toolwindows.ToolWindowBuild);
            }
        });
    }

    private final class CloseListener
    extends BaseContentCloseListener {
        @Nullable
        private BuildProcessHandler myProcessHandler;

        private CloseListener(@NotNull Content content2, BuildProcessHandler processHandler2) {
            super(content2, BuildContentManagerImpl.this.myProject);
            this.myProcessHandler = processHandler2;
        }

        @Override
        protected void disposeContent(@NotNull Content content2) {
            if (this.myProcessHandler instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)this.myProcessHandler));
            }
            this.myProcessHandler = null;
        }

        @Override
        protected boolean closeQuery(@NotNull Content content2, boolean modal) {
            if (this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated() || this.myProcessHandler.isProcessTerminating()) {
                return true;
            }
            this.myProcessHandler.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)Boolean.TRUE);
            String sessionName = this.myProcessHandler.getExecutionName();
            BaseContentCloseListener.WaitForProcessTask task2 = new BaseContentCloseListener.WaitForProcessTask((ProcessHandler)this.myProcessHandler, sessionName, modal, BuildContentManagerImpl.this.myProject){

                @Override
                public void onCancel() {
                    CloseListener.this.myProcessHandler.forceProcessDetach();
                }
            };
            return this.askUserAndWait((ProcessHandler)this.myProcessHandler, sessionName, task2);
        }
    }
}

