/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractDescriptionAwareSchemesPanel;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.DumbAwareAction;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DescriptionAwareSchemeActions<T extends Scheme>
extends AbstractSchemeActions<T> {
    protected DescriptionAwareSchemeActions(@NotNull AbstractDescriptionAwareSchemesPanel<T> schemesPanel) {
        super(schemesPanel);
    }

    @Nullable
    public abstract String getDescription(@NotNull T var1);

    protected abstract void setDescription(@NotNull T var1, @NotNull String var2);

    @Override
    protected void addAdditionalActions(@NotNull List<? super AnAction> defaultActions) {
        defaultActions.add((AnAction)new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                Object scheme = DescriptionAwareSchemeActions.this.getSchemesPanel().getSelectedScheme();
                if (scheme == null) {
                    e.getPresentation().setEnabledAndVisible(false);
                    return;
                }
                String text = DescriptionAwareSchemeActions.this.getDescription(scheme) == null ? IdeBundle.message((String)"action.DescriptionAwareSchemeActions.add.description.text", (Object[])new Object[0]) : IdeBundle.message((String)"action.DescriptionAwareSchemeActions.edit.description.text", (Object[])new Object[0]);
                e.getPresentation().setEnabledAndVisible(true);
                e.getPresentation().setText(text);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                ((AbstractDescriptionAwareSchemesPanel)DescriptionAwareSchemeActions.this.mySchemesPanel).editDescription(DescriptionAwareSchemeActions.this.getDescription(DescriptionAwareSchemeActions.this.getSchemesPanel().getSelectedScheme()));
            }
        });
    }

    @Override
    protected void onSchemeChanged(@Nullable T scheme) {
        if (scheme != null) {
            ((AbstractDescriptionAwareSchemesPanel)this.mySchemesPanel).showDescription(scheme);
        }
    }
}

