/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.application.options.colors.FontEditorPreview;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.highlighting.HighlightData;
import com.intellij.application.options.colors.highlighting.HighlightsExtractor;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.UsedColors;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.EditorHighlightingProvidingColorSettingsPage;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.EditorCustomization;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleEditorPreview
implements PreviewPanel {
    private final ColorSettingsPage myPage;
    private final EditorEx myEditor;
    private final Alarm myBlinkingAlarm;
    private final List<HighlightData> myHighlightData = new ArrayList<HighlightData>();
    private final ColorAndFontOptions myOptions;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private final HighlightsExtractor myHighlightsExtractor;
    private final ColorSettingsPage.PreviewCustomizer myCustomizer;
    private static final int BLINK_COUNT = 6;

    public SimpleEditorPreview(ColorAndFontOptions options2, ColorSettingsPage page) {
        this(options2, page, true);
    }

    public SimpleEditorPreview(ColorAndFontOptions options2, ColorSettingsPage page, boolean navigatable) {
        this.myOptions = options2;
        this.myPage = page;
        this.myCustomizer = page.getPreviewEditorCustomizer();
        this.myHighlightsExtractor = new HighlightsExtractor(page.getAdditionalHighlightingTagToDescriptorMap(), page.getAdditionalInlineElementToDescriptorMap(), page.getAdditionalHighlightingTagToColorKeyMap());
        this.myEditor = (EditorEx)FontEditorPreview.createPreviewEditor(this.myHighlightsExtractor.extractHighlights(page.getDemoText(), this.myHighlightData), this.myOptions.getSelectedScheme(), false);
        if (page instanceof EditorCustomization) {
            ((EditorCustomization)page).customize(this.myEditor);
        }
        FontEditorPreview.installTrafficLights(this.myEditor);
        this.myBlinkingAlarm = new Alarm().setActivationComponent(this.myEditor.getComponent());
        if (navigatable) {
            this.myEditor.getContentComponent().addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (SimpleEditorPreview.this.myCustomizer != null && SimpleEditorPreview.this.myCustomizer.getCustomizationAt((Editor)SimpleEditorPreview.this.myEditor, e.getPoint()) != null) {
                        SimpleEditorPreview.this.setCursor(true);
                        return;
                    }
                    SimpleEditorPreview.this.navigate(false, SimpleEditorPreview.this.myEditor.xyToLogicalPosition(new Point(e.getX(), e.getY())));
                }
            });
            this.myEditor.addEditorMouseListener(new EditorMouseListener(){

                public void mouseClicked(@NotNull EditorMouseEvent event) {
                    String customization;
                    if (event.getArea() == EditorMouseEventArea.EDITING_AREA && SimpleEditorPreview.this.myCustomizer != null && (customization = SimpleEditorPreview.this.myCustomizer.getCustomizationAt((Editor)SimpleEditorPreview.this.myEditor, event.getMouseEvent().getPoint())) != null) {
                        ((ColorAndFontSettingsListener)SimpleEditorPreview.this.myDispatcher.getMulticaster()).selectionInPreviewChanged(customization);
                    }
                }
            });
            this.myEditor.getCaretModel().addCaretListener(new CaretListener(){

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    SimpleEditorPreview.this.navigate(true, e.getNewPosition());
                }
            });
        }
    }

    public EditorEx getEditor() {
        return this.myEditor;
    }

    private void navigate(boolean select, @NotNull LogicalPosition pos) {
        int offset = this.myEditor.logicalPositionToOffset(pos);
        SyntaxHighlighter highlighter = this.myPage.getHighlighter();
        HighlightData highlightData = this.getDataFromOffset(offset);
        String type = highlightData != null ? (RainbowHighlighter.isRainbowTempKey(highlightData.getHighlightKey()) ? "rainbow" : (highlightData.getAdditionalColorKey() == null ? highlightData.getHighlightType() : highlightData.getAdditionalColorKey().getExternalName())) : SimpleEditorPreview.selectItem(this.myEditor.getHighlighter().createIterator(offset), highlighter);
        this.setCursor(type != null);
        if (select && type != null) {
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectionInPreviewChanged(type);
        }
    }

    @Nullable
    private HighlightData getDataFromOffset(int offset) {
        for (HighlightData highlightData : this.myHighlightData) {
            if (offset < highlightData.getStartOffset() || offset > highlightData.getEndOffset()) continue;
            return highlightData;
        }
        return null;
    }

    @Nullable
    private static String selectItem(HighlighterIterator itr, SyntaxHighlighter highlighter) {
        IElementType tokenType = itr.getTokenType();
        if (tokenType == null) {
            return null;
        }
        TextAttributesKey[] highlights = highlighter.getTokenHighlights(tokenType);
        String s = null;
        for (int i2 = highlights.length - 1; i2 >= 0; --i2) {
            if (highlights[i2] == HighlighterColors.TEXT) continue;
            s = highlights[i2].getExternalName();
            break;
        }
        return s == null ? HighlighterColors.TEXT.getExternalName() : s;
    }

    @Override
    public JComponent getPanel() {
        return this.myEditor.getComponent();
    }

    @Override
    public void updateView() {
        EditorColorsScheme scheme = this.myOptions.getSelectedScheme();
        this.myEditor.setColorsScheme(scheme);
        EditorHighlighter highlighter = null;
        if (this.myPage instanceof EditorHighlightingProvidingColorSettingsPage) {
            highlighter = ((EditorHighlightingProvidingColorSettingsPage)this.myPage).createEditorHighlighter(scheme);
        }
        if (highlighter == null) {
            SyntaxHighlighter pageHighlighter = this.myPage.getHighlighter();
            highlighter = HighlighterFactory.createHighlighter((SyntaxHighlighter)pageHighlighter, (EditorColorsScheme)scheme);
        }
        this.myEditor.setHighlighter(highlighter);
        this.updateHighlighters();
        this.myEditor.reinitSettings();
    }

    private void updateHighlighters() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myEditor.isDisposed()) {
                return;
            }
            this.removeDecorations();
            Map<TextAttributesKey, String> displayText = ColorSettingsUtil.keyToDisplayTextMap(this.myPage);
            for (HighlightData data2 : this.myHighlightData) {
                data2.addHighlToView(this.myEditor, this.myOptions.getSelectedScheme(), displayText);
            }
            if (this.myCustomizer != null) {
                this.myCustomizer.addCustomizations((Editor)this.myEditor, null);
            }
        });
    }

    private void removeDecorations() {
        this.myEditor.getMarkupModel().removeAllHighlighters();
        for (Inlay inlay : this.myEditor.getInlayModel().getInlineElementsInRange(0, this.myEditor.getDocument().getTextLength())) {
            Disposer.dispose((Disposable)inlay);
        }
        if (this.myCustomizer != null) {
            this.myCustomizer.removeCustomizations((Editor)this.myEditor);
        }
    }

    @Override
    public void blinkSelectedHighlightType(Object description) {
        if (description instanceof EditorSchemeAttributeDescriptor) {
            String type = ((EditorSchemeAttributeDescriptor)description).getType();
            List<HighlightData> highlights = this.startBlinkingHighlights(this.myEditor, type, this.myPage.getHighlighter(), true, this.myBlinkingAlarm, 6, this.myPage);
            this.scrollHighlightInView(highlights);
        }
    }

    private void scrollHighlightInView(@Nullable List<? extends HighlightData> highlightDatas) {
        if (highlightDatas == null) {
            return;
        }
        boolean needScroll = true;
        int minOffset = Integer.MAX_VALUE;
        for (HighlightData highlightData : highlightDatas) {
            if (this.isOffsetVisible(highlightData.getStartOffset())) {
                needScroll = false;
                break;
            }
            minOffset = Math.min(minOffset, highlightData.getStartOffset());
        }
        if (needScroll && minOffset != Integer.MAX_VALUE) {
            LogicalPosition pos = this.myEditor.offsetToLogicalPosition(minOffset);
            this.myEditor.getScrollingModel().scrollTo(pos, ScrollType.MAKE_VISIBLE);
        }
    }

    private boolean isOffsetVisible(int startOffset) {
        return this.myEditor.getScrollingModel().getVisibleAreaOnScrollingFinished().contains(this.myEditor.logicalPositionToXY(this.myEditor.offsetToLogicalPosition(startOffset)));
    }

    private void stopBlinking() {
        this.myBlinkingAlarm.cancelAllRequests();
    }

    private List<HighlightData> startBlinkingHighlights(EditorEx editor, String attrKey, SyntaxHighlighter highlighter, boolean show2, Alarm alarm2, int count, ColorSettingsPage page) {
        TextRange range2;
        if (show2 && count <= 0) {
            return Collections.emptyList();
        }
        this.removeDecorations();
        boolean found = false;
        ArrayList<HighlightData> highlights = new ArrayList<HighlightData>();
        ArrayList<HighlightData> matchingHighlights = new ArrayList<HighlightData>();
        for (HighlightData highlightData : this.myHighlightData) {
            boolean highlight = show2 && (highlightData.getHighlightType().equals(attrKey) || highlightData.getAdditionalColorKey() != null && highlightData.getAdditionalColorKey().getExternalName().equals(attrKey));
            highlightData.addToCollection(highlights, highlight);
            if (!highlight) continue;
            matchingHighlights.add(highlightData);
            found = true;
        }
        if (show2 && !found && highlighter != null) {
            HighlighterIterator iterator2 = editor.getHighlighter().createIterator(0);
            do {
                TextAttributesKey[] tokenHighlights;
                IElementType tokenType = iterator2.getTokenType();
                for (TextAttributesKey tokenHighlight : tokenHighlights = highlighter.getTokenHighlights(tokenType)) {
                    String type = tokenHighlight.getExternalName();
                    if (!type.equals(attrKey)) continue;
                    HighlightData highlightData = new HighlightData(iterator2.getStart(), iterator2.getEnd(), CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES);
                    highlights.add(highlightData);
                    matchingHighlights.add(highlightData);
                }
                iterator2.advance();
            } while (!iterator2.atEnd());
        }
        Map<TextAttributesKey, String> displayText = ColorSettingsUtil.keyToDisplayTextMap(page);
        highlights.sort(Comparator.comparingInt(HighlightData::getStartOffset));
        for (int i2 = highlights.size() - 1; i2 >= 0; --i2) {
            HighlightData prevHighlightData;
            HighlightData highlightData = (HighlightData)highlights.get(i2);
            int startOffset = highlightData.getStartOffset();
            HighlightData highlightData2 = prevHighlightData = i2 == 0 ? null : (HighlightData)highlights.get(i2 - 1);
            if (prevHighlightData != null && startOffset <= prevHighlightData.getEndOffset() && highlightData.getHighlightType().equals(prevHighlightData.getHighlightType())) {
                prevHighlightData.setEndOffset(highlightData.getEndOffset());
                continue;
            }
            highlightData.addHighlToView(editor, this.myOptions.getSelectedScheme(), displayText);
        }
        if (this.myCustomizer != null && (range2 = this.myCustomizer.addCustomizations((Editor)this.myEditor, show2 ? attrKey : null)) != null) {
            matchingHighlights.add(new HighlightData(range2.getStartOffset(), range2.getEndOffset(), null));
        }
        alarm2.cancelAllRequests();
        alarm2.addComponentRequest(() -> this.startBlinkingHighlights(editor, attrKey, highlighter, !show2, alarm2, count - 1, page), 400);
        return matchingHighlights;
    }

    @Override
    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void disposeUIResources() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myEditor);
        this.stopBlinking();
    }

    private void setCursor(boolean hand) {
        this.myEditor.setCustomCursor(SimpleEditorPreview.class, hand ? Cursor.getPredefinedCursor(12) : null);
    }

    void setupRainbow(@NotNull EditorColorsScheme colorsScheme, @NotNull RainbowColorSettingsPage page) {
        ArrayList<HighlightData> initialMarkup = new ArrayList<HighlightData>();
        this.myHighlightsExtractor.extractHighlights(page.getDemoText(), initialMarkup);
        List<HighlightData> rainbowMarkup = this.setupRainbowHighlighting(page, initialMarkup, new RainbowHighlighter((TextAttributesScheme)colorsScheme).getRainbowTempKeys(), RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)colorsScheme, page.getLanguage()));
        this.myHighlightData.clear();
        this.myHighlightData.addAll(rainbowMarkup);
    }

    @NotNull
    private List<HighlightData> setupRainbowHighlighting(@NotNull RainbowColorSettingsPage page, @NotNull List<HighlightData> initialMarkup, TextAttributesKey @NotNull [] rainbowTempKeys, boolean isRainbowOn) {
        int colorCount = rainbowTempKeys.length;
        if (colorCount == 0) {
            return initialMarkup;
        }
        ArrayList<HighlightData> rainbowMarkup = new ArrayList<HighlightData>();
        int tempKeyIndex = 0;
        boolean repeatAnchor = true;
        for (HighlightData d : initialMarkup) {
            boolean rainbowDemoType;
            TextAttributesKey highlightKey = d.getHighlightKey();
            boolean rainbowType = page.isRainbowType(highlightKey);
            boolean bl = rainbowDemoType = highlightKey == RainbowHighlighter.RAINBOW_GRADIENT_DEMO;
            if (rainbowType || rainbowDemoType) {
                HighlightData rainbowAnchor = new HighlightData(d.getStartOffset(), d.getEndOffset(), RainbowHighlighter.RAINBOW_ANCHOR);
                if (isRainbowOn) {
                    HighlightData rainbowTemp;
                    if (rainbowType) {
                        rainbowTemp = this.getRainbowTemp(rainbowTempKeys, d.getStartOffset(), d.getEndOffset());
                    } else {
                        rainbowTemp = new HighlightData(d.getStartOffset(), d.getEndOffset(), rainbowTempKeys[tempKeyIndex % colorCount]);
                        if (repeatAnchor && tempKeyIndex == colorCount / 2) {
                            repeatAnchor = false;
                        } else {
                            ++tempKeyIndex;
                        }
                    }
                    rainbowMarkup.add(rainbowTemp);
                    rainbowMarkup.add(rainbowAnchor);
                    rainbowMarkup.add(d);
                    rainbowMarkup.add(rainbowAnchor);
                    rainbowMarkup.add(rainbowTemp);
                    continue;
                }
                if (rainbowType) {
                    rainbowMarkup.add(d);
                    rainbowMarkup.add(rainbowAnchor);
                    rainbowMarkup.add(d);
                    continue;
                }
                rainbowMarkup.add(rainbowAnchor);
                continue;
            }
            if (RainbowHighlighter.isRainbowTempKey(highlightKey) || highlightKey == RainbowHighlighter.RAINBOW_ANCHOR) continue;
            rainbowMarkup.add(d);
        }
        return rainbowMarkup;
    }

    @NotNull
    private HighlightData getRainbowTemp(TextAttributesKey @NotNull [] rainbowTempKeys, int startOffset, int endOffset) {
        String id2 = this.myEditor.getDocument().getText(TextRange.create((int)startOffset, (int)endOffset));
        int index = UsedColors.getOrAddColorIndex((UserDataHolderEx)((EditorImpl)this.myEditor), id2, rainbowTempKeys.length);
        return new HighlightData(startOffset, endOffset, rainbowTempKeys[index]);
    }
}

