/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSchemesModelListener;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodeStyleSchemesModel
implements SchemesModel<CodeStyleScheme> {
    private static final Logger LOG = Logger.getInstance(CodeStyleSchemesModel.class);
    private final List<CodeStyleScheme> mySchemes = new ArrayList<CodeStyleScheme>();
    private CodeStyleScheme mySelectedScheme;
    private final CodeStyleScheme myProjectScheme;
    private final CodeStyleScheme myDefault;
    private final Map<CodeStyleScheme, CodeStyleSettings> mySettingsToClone = new HashMap<CodeStyleScheme, CodeStyleSettings>();
    private final EventDispatcher<CodeStyleSchemesModelListener> myDispatcher = EventDispatcher.create(CodeStyleSchemesModelListener.class);
    private final Project myProject;
    private boolean myUiEventsEnabled = true;
    @NotNull
    private final OverridingStatus myOverridingStatus = new OverridingStatus();

    public CodeStyleSchemesModel(@NotNull Project project) {
        this.myProject = project;
        this.myProjectScheme = new ProjectScheme(project);
        this.myDefault = CodeStyleSchemes.getInstance().getDefaultScheme();
        this.reset();
    }

    public void selectScheme(CodeStyleScheme selected2, @Nullable Object source) {
        if (this.mySelectedScheme != selected2) {
            this.mySelectedScheme = selected2;
            ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(source);
        }
    }

    public void addScheme(CodeStyleScheme newScheme, boolean changeSelection) {
        this.mySchemes.add(newScheme);
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        if (changeSelection) {
            this.selectScheme(newScheme, this);
        }
    }

    @Override
    public void removeScheme(@NotNull CodeStyleScheme scheme) {
        this.mySchemes.remove(scheme);
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        if (this.mySelectedScheme == scheme) {
            this.selectScheme(this.myDefault, this);
        }
    }

    @NotNull
    public CodeStyleSettings getCloneSettings(CodeStyleScheme scheme) {
        if (!this.mySettingsToClone.containsKey(scheme)) {
            this.mySettingsToClone.put(scheme, ModelSettings.createFrom(scheme.getCodeStyleSettings()));
        }
        return this.mySettingsToClone.get(scheme);
    }

    public CodeStyleScheme getSelectedScheme() {
        return this.mySelectedScheme;
    }

    public void addListener(CodeStyleSchemesModelListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public List<CodeStyleScheme> getSchemes() {
        return Collections.unmodifiableList(this.mySchemes);
    }

    public void reset() {
        this.mySchemes.clear();
        this.mySchemes.addAll(CodeStyleSchemesImpl.getSchemeManager().getAllSchemes());
        this.mySchemes.add(this.myProjectScheme);
        this.updateClonedSettings();
        CodeStyleSettingsManager projectSettings = CodeStyleSettingsManager.getInstance((Project)this.myProject);
        this.mySelectedScheme = projectSettings.USE_PER_PROJECT_SETTINGS ? this.myProjectScheme : CodeStyleSchemes.getInstance().findPreferredScheme(projectSettings.PREFERRED_PROJECT_CODE_STYLE);
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeListChanged();
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).currentSchemeChanged(this);
        this.updateOverridingStatus();
    }

    private void updateClonedSettings() {
        Iterator<CodeStyleScheme> schemeIterator = this.mySettingsToClone.keySet().iterator();
        while (schemeIterator.hasNext()) {
            CodeStyleScheme scheme = schemeIterator.next();
            if (this.mySchemes.contains(scheme)) continue;
            schemeIterator.remove();
        }
        for (CodeStyleScheme scheme : this.mySchemes) {
            CodeStyleSettings current2 = scheme.getCodeStyleSettings();
            CodeStyleSettings clonedSettings = this.getCloneSettings(scheme);
            clonedSettings.copyFrom(current2);
        }
    }

    public boolean isUsePerProjectSettings() {
        return this.mySelectedScheme instanceof ProjectScheme;
    }

    public boolean isSchemeListModified() {
        CodeStyleSchemes schemes = CodeStyleSchemes.getInstance();
        CodeStyleSettingsManager projectSettings = CodeStyleSettingsManager.getInstance((Project)this.myProject);
        if (projectSettings.USE_PER_PROJECT_SETTINGS != this.isProjectScheme(this.mySelectedScheme)) {
            return true;
        }
        if (!this.isProjectScheme(this.mySelectedScheme) && this.getSelectedScheme() != schemes.findPreferredScheme(projectSettings.PREFERRED_PROJECT_CODE_STYLE)) {
            return true;
        }
        HashSet<CodeStyleScheme> configuredSchemesSet = new HashSet<CodeStyleScheme>(this.getIdeSchemes());
        return !configuredSchemesSet.equals(new HashSet<CodeStyleScheme>(CodeStyleSchemesImpl.getSchemeManager().getAllSchemes()));
    }

    public void apply() {
        this.commitClonedSettings();
        this.commitProjectSettings();
        CodeStyleSchemesImpl.getSchemeManager().setSchemes(this.getIdeSchemes(), this.mySelectedScheme instanceof ProjectScheme ? null : this.mySelectedScheme, null);
        this.updateOverridingStatus();
    }

    private void commitProjectSettings() {
        CodeStyleSettingsManager projectSettingsManager = CodeStyleSettingsManager.getInstance((Project)this.myProject);
        projectSettingsManager.USE_PER_PROJECT_SETTINGS = this.isProjectScheme(this.mySelectedScheme);
        projectSettingsManager.PREFERRED_PROJECT_CODE_STYLE = this.mySelectedScheme instanceof ProjectScheme ? null : this.mySelectedScheme.getName();
        CodeStyleSettings projectSettings = this.myProjectScheme.getCodeStyleSettings();
        projectSettings.getModificationTracker().incModificationCount();
        projectSettingsManager.setMainProjectCodeStyle(projectSettings);
    }

    private void commitClonedSettings() {
        for (CodeStyleScheme scheme : this.mySettingsToClone.keySet()) {
            if (scheme instanceof ProjectScheme) continue;
            CodeStyleSettings settings = scheme.getCodeStyleSettings();
            settings.copyFrom(this.mySettingsToClone.get(scheme));
            settings.getModificationTracker().incModificationCount();
        }
    }

    @NotNull
    private List<CodeStyleScheme> getIdeSchemes() {
        return ContainerUtil.filter(this.mySchemes, scheme -> !(scheme instanceof ProjectScheme));
    }

    @Deprecated
    public static boolean cannotBeModified(CodeStyleScheme currentScheme) {
        return false;
    }

    public void fireBeforeCurrentSettingsChanged() {
        if (this.myUiEventsEnabled) {
            ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).beforeCurrentSettingsChanged();
        }
    }

    void updateScheme(CodeStyleScheme scheme) {
        CodeStyleSettings clonedSettings = this.getCloneSettings(scheme);
        clonedSettings.copyFrom(scheme.getCodeStyleSettings());
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeChanged(scheme);
    }

    public void fireSchemeListChanged() {
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeListChanged();
    }

    public void fireAfterCurrentSettingsChanged() {
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).afterCurrentSettingsChanged();
    }

    public void copyToProject(CodeStyleScheme selectedScheme) {
        this.myProjectScheme.getCodeStyleSettings().copyFrom(selectedScheme.getCodeStyleSettings());
        ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).schemeChanged(this.myProjectScheme);
        this.commitProjectSettings();
        this.selectScheme(this.myProjectScheme, this);
    }

    public CodeStyleScheme exportProjectScheme(@NotNull String name) {
        CodeStyleScheme newScheme = this.createNewScheme(name, this.myProjectScheme);
        ((CodeStyleSchemeImpl)newScheme).setCodeStyleSettings(CodeStyleSettingsManager.getInstance().cloneSettings(this.getCloneSettings(this.myProjectScheme)));
        this.addScheme(newScheme, false);
        return newScheme;
    }

    public CodeStyleScheme createNewScheme(String preferredName, CodeStyleScheme parentScheme) {
        boolean isProjectScheme = this.isProjectScheme(parentScheme);
        return new CodeStyleSchemeImpl(SchemeNameGenerator.getUniqueName(preferredName, (Scheme)parentScheme, name -> this.containsScheme((String)name, isProjectScheme)), false, parentScheme);
    }

    @Nullable
    private CodeStyleScheme findSchemeByName(String name, boolean isProjectScheme) {
        for (CodeStyleScheme scheme : this.mySchemes) {
            if (isProjectScheme != this.isProjectScheme(scheme) || !name.equals(scheme.getName())) continue;
            return scheme;
        }
        return null;
    }

    public CodeStyleScheme getProjectScheme() {
        return this.myProjectScheme;
    }

    @Override
    public boolean canDuplicateScheme(@NotNull CodeStyleScheme scheme) {
        return !this.isProjectScheme(scheme);
    }

    @Override
    public boolean canResetScheme(@NotNull CodeStyleScheme scheme) {
        return scheme.isDefault();
    }

    @Override
    public boolean canDeleteScheme(@NotNull CodeStyleScheme scheme) {
        return !this.isProjectScheme(scheme) && !scheme.isDefault();
    }

    @Override
    public boolean isProjectScheme(@NotNull CodeStyleScheme scheme) {
        return scheme instanceof ProjectScheme;
    }

    @Override
    public boolean canRenameScheme(@NotNull CodeStyleScheme scheme) {
        return this.canDeleteScheme(scheme);
    }

    @Override
    public boolean containsScheme(@NotNull String name, boolean isProjectScheme) {
        return this.findSchemeByName(name, isProjectScheme) != null;
    }

    @Override
    public boolean differsFromDefault(@NotNull CodeStyleScheme scheme) {
        CodeStyleSettings clonedSettings;
        CodeStyleSettings defaults = CodeStyleSettings.getDefaults();
        return !defaults.equals((Object)(clonedSettings = this.getCloneSettings(scheme)));
    }

    public List<CodeStyleScheme> getAllSortedSchemes() {
        ArrayList<CodeStyleScheme> schemes = new ArrayList<CodeStyleScheme>(this.getSchemes());
        schemes.sort((s1, s2) -> {
            if (this.isProjectScheme((CodeStyleScheme)s1)) {
                return -1;
            }
            if (this.isProjectScheme((CodeStyleScheme)s2)) {
                return 1;
            }
            if (s1.isDefault()) {
                return -1;
            }
            if (s2.isDefault()) {
                return 1;
            }
            return s1.getName().compareToIgnoreCase(s2.getName());
        });
        return schemes;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void restoreDefaults(@NotNull CodeStyleScheme scheme) {
        if (this.canResetScheme(scheme)) {
            CodeStyleSettings currSettings = this.getCloneSettings(scheme);
            currSettings.copyFrom(CodeStyleSettings.getDefaults());
            this.fireModelSettingsChanged(currSettings);
        }
    }

    void fireModelSettingsChanged(@NotNull CodeStyleSettings currSettings) {
        this.myUiEventsEnabled = false;
        try {
            ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).settingsChanged(currSettings);
        }
        finally {
            this.myUiEventsEnabled = true;
        }
    }

    public boolean containsModifiedCodeStyleSettings() {
        for (CodeStyleScheme scheme : this.mySchemes) {
            CodeStyleSettings originalSettings = scheme.getCodeStyleSettings();
            CodeStyleSettings currentSettings = this.mySettingsToClone.get(scheme);
            if (currentSettings == null || originalSettings.equals((Object)currentSettings)) continue;
            return true;
        }
        return false;
    }

    public void updateOverridingStatus() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.myOverridingStatus.getLock().lock();
                List<CodeStyleSettingsModifier> modifiers = this.getOverridingModifiers();
                if (modifiers.size() > 0) {
                    this.myOverridingStatus.update(modifiers);
                } else {
                    this.myOverridingStatus.reset();
                }
            }
            finally {
                this.myOverridingStatus.getLock().unlock();
            }
            ((CodeStyleSchemesModelListener)this.myDispatcher.getMulticaster()).overridingStatusChanged();
        });
    }

    @Nullable
    public OverridingStatus getOverridingStatus() {
        if (this.myOverridingStatus.getLock().tryLock()) {
            try {
                OverridingStatus overridingStatus = !this.myOverridingStatus.isEmpty() ? this.myOverridingStatus : null;
                return overridingStatus;
            }
            finally {
                this.myOverridingStatus.getLock().unlock();
            }
        }
        return null;
    }

    private List<CodeStyleSettingsModifier> getOverridingModifiers() {
        return ContainerUtil.filter((Collection)CodeStyleSettingsModifier.EP_NAME.getExtensionList(), modifier -> CodeStyleSchemesModel.safeGetOverridingStatus(modifier, this.getProject()));
    }

    private static boolean safeGetOverridingStatus(@NotNull CodeStyleSettingsModifier modifier, @NotNull Project project) {
        try {
            return modifier.mayOverrideSettingsOf(project);
        }
        catch (Throwable t) {
            LOG.error(t);
            return false;
        }
    }

    public void setUiEventsEnabled(boolean enabled) {
        this.myUiEventsEnabled = enabled;
    }

    public boolean isUiEventsEnabled() {
        return this.myUiEventsEnabled;
    }

    public static class OverridingStatus {
        private final Lock myLock = new ReentrantLock();
        private static final CodeStyleSettingsModifier[] EMPTY_MODIFIER_ARRAY = new CodeStyleSettingsModifier[0];
        @Nullable
        private List<CodeStyleSettingsModifier> myModifiers;

        @NotNull
        public Lock getLock() {
            return this.myLock;
        }

        private void update(@NotNull List<CodeStyleSettingsModifier> modifiers) {
            this.myModifiers = modifiers;
        }

        public CodeStyleSettingsModifier @NotNull [] getModifiers() {
            return this.myModifiers != null && !this.myModifiers.isEmpty() ? this.myModifiers.toArray(new CodeStyleSettingsModifier[0]) : EMPTY_MODIFIER_ARRAY;
        }

        private boolean isEmpty() {
            return this.myModifiers == null || this.myModifiers.isEmpty();
        }

        private void reset() {
            this.myModifiers = null;
        }
    }

    public static class ModelSettings
    extends CodeStyleSettings {
        private volatile boolean myLocked;

        public ModelSettings() {
            super(true, true);
        }

        public static ModelSettings createFrom(@NotNull CodeStyleSettings settings) {
            ModelSettings modelSettings = new ModelSettings();
            modelSettings.copyFrom(settings);
            return modelSettings;
        }

        public void doWithLockedSettings(@NotNull Runnable runnable2) {
            this.myLocked = true;
            runnable2.run();
            this.myLocked = false;
        }

        public boolean isLocked() {
            return this.myLocked;
        }
    }

    private static final class ProjectScheme
    extends CodeStyleSchemeImpl {
        ProjectScheme(@NotNull Project project) {
            super("Project", false, CodeStyleSchemes.getInstance().getDefaultScheme());
            CodeStyleSettings perProjectSettings = CodeStyleSettingsManager.getInstance((Project)project).getMainProjectCodeStyle();
            if (perProjectSettings != null) {
                this.setCodeStyleSettings(perProjectSettings);
            }
        }
    }
}

