/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ModuleListCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.SortedComboBoxModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesComboBox
extends ComboBox<Module> {
    private final SortedComboBoxModel<Module> myModel;
    private boolean myAllowEmptySelection;

    public ModulesComboBox() {
        this((SortedComboBoxModel<Module>)new SortedComboBoxModel((Comparator)ModulesAlphaComparator.INSTANCE));
    }

    private ModulesComboBox(SortedComboBoxModel<Module> model) {
        super(model);
        this.myModel = model;
        this.setRenderer((ListCellRenderer)((Object)new ModuleListCellRenderer()));
        this.setSwingPopup(false);
    }

    public void allowEmptySelection(@NotNull String emptySelectionText) {
        this.myAllowEmptySelection = true;
        this.myModel.add(null);
        this.setRenderer((ListCellRenderer)((Object)new ModuleListCellRenderer(emptySelectionText)));
    }

    public void setModules(@NotNull Collection<? extends Module> modules2) {
        this.myModel.setAll(modules2);
        if (this.myAllowEmptySelection) {
            this.myModel.add(null);
        }
    }

    public void fillModules(@NotNull Project project) {
        this.fillModules(project, null);
    }

    public void fillModules(@NotNull Project project, @Nullable ModuleType moduleType) {
        Module[] allModules = ModuleManager.getInstance((Project)project).getModules();
        if (moduleType == null) {
            this.setModules(Arrays.asList(allModules));
        } else {
            ArrayList<Module> modules2 = new ArrayList<Module>();
            for (Module module : allModules) {
                if (!moduleType.equals((Object)ModuleType.get((Module)module))) continue;
                modules2.add(module);
            }
            this.setModules(modules2);
        }
    }

    public void setSelectedModule(@Nullable Module module) {
        this.myModel.setSelectedItem((Object)module);
    }

    @Nullable
    public Module getSelectedModule() {
        return (Module)this.myModel.getSelectedItem();
    }
}

