/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleSchemesConfigurable;
import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.codeStyle.CodeStyleMainPanel;
import com.intellij.application.options.codeStyle.CodeStyleSettingsPanelFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleConfigurableWrapper
implements SearchableConfigurable,
Configurable.NoMargin,
Configurable.NoScroll,
OptionsContainingConfigurable {
    private boolean myInitialResetInvoked;
    protected CodeStyleMainPanel myPanel;
    private final CodeStyleSettingsProvider myProvider;
    private final CodeStyleSettingsPanelFactory myFactory;
    private final CodeStyleSchemesConfigurable myOwner;

    public CodeStyleConfigurableWrapper(@NotNull CodeStyleSettingsProvider provider, @NotNull CodeStyleSettingsPanelFactory factory2, CodeStyleSchemesConfigurable owner) {
        this.myProvider = provider;
        this.myFactory = factory2;
        this.myOwner = owner;
        this.myInitialResetInvoked = false;
    }

    @Nls
    public String getDisplayName() {
        String displayName = this.myProvider.getConfigurableDisplayName();
        if (displayName != null) {
            return displayName;
        }
        return this.myPanel != null ? this.myPanel.getDisplayName() : null;
    }

    public String getHelpTopic() {
        return this.myPanel != null ? this.myPanel.getHelpTopic() : null;
    }

    public JComponent createComponent() {
        if (this.myPanel == null) {
            this.myPanel = new CodeStyleMainPanel(this.myOwner.getModel(), this.myFactory, this.canBeShared());
        }
        return this.myPanel;
    }

    protected boolean canBeShared() {
        return true;
    }

    public boolean isModified() {
        if (this.myPanel != null) {
            boolean someSchemeModified = this.myPanel.isModified();
            if (someSchemeModified) {
                this.myOwner.resetCompleted();
            }
            return someSchemeModified;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        this.myOwner.apply();
    }

    public void resetPanel() {
        if (this.myPanel != null) {
            this.myPanel.reset();
        }
    }

    public String toString() {
        return this.myProvider.getClass().getName();
    }

    public void reset() {
        if (!this.myInitialResetInvoked) {
            try {
                this.myOwner.resetFromChild();
            }
            finally {
                this.myInitialResetInvoked = true;
            }
        } else {
            this.myOwner.revert();
        }
    }

    @NotNull
    public String getId() {
        return CodeStyleConfigurableWrapper.getConfigurableId(this.getDisplayName());
    }

    @NotNull
    public Class<?> getOriginalClass() {
        return this.myProvider.getClass();
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            this.myPanel.disposeUIResources();
        }
    }

    public boolean isPanelModified() {
        return this.myPanel != null && this.myPanel.isModified();
    }

    public void applyPanel() throws ConfigurationException {
        if (this.myPanel != null) {
            this.myPanel.apply();
        }
    }

    @Override
    @NotNull
    public Set<String> processListOptions() {
        return this.getOptionIndexer().processListOptions();
    }

    @Override
    public Map<String, Set<String>> processListOptionsWithPaths() {
        return this.getOptionIndexer().processListOptionsWithPaths();
    }

    @NotNull
    private OptionsContainingConfigurable getOptionIndexer() {
        if (this.myPanel == null) {
            this.myPanel = new CodeStyleMainPanel(this.myOwner.getModel(), this.myFactory, this.canBeShared());
        }
        return this.myPanel.getOptionIndexer();
    }

    public void selectTab(@NotNull String tab) {
        this.createComponent();
        this.myPanel.showTabOnCurrentPanel(tab);
    }

    @NotNull
    public static String getConfigurableId(String configurableDisplayName) {
        return "preferences.sourceCode." + configurableDisplayName;
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        return this.myPanel != null ? () -> this.myPanel.highlightOptions(option2) : null;
    }
}

