/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.toolWindow.FileNode;
import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.NodeComparator;
import com.intellij.analysis.problemsView.toolWindow.ProblemNode;
import com.intellij.analysis.problemsView.toolWindow.ProblemsTreeModel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPreview;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewState;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleOptionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.RestoreSelectionListener;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ProblemsViewPanel
extends OnePixelSplitter
implements Disposable,
DataProvider {
    private static final Logger LOG = Logger.getInstance(ProblemsViewPanel.class);
    private final Project myProject;
    private final ProblemsViewState myState;
    private final ProblemsTreeModel myTreeModel = new ProblemsTreeModel(this);
    private final ProblemsViewPreview myPreview = new ProblemsViewPreview(this);
    private final JPanel myPanel;
    private final ActionToolbar myToolbar;
    private final Insets myToolbarInsets = JBUI.insetsRight((int)1);
    private final Tree myTree;
    private final TreeExpander myTreeExpander;
    private final SingleAlarm mySelectionAlarm = new SingleAlarm(() -> {
        OpenFileDescriptor descriptor2 = this.getSelectedDescriptor();
        this.updateAutoscroll(descriptor2);
        this.updatePreview(descriptor2);
    }, 50, ModalityState.stateForComponent((Component)((Object)this)), (Disposable)this);
    private final SingleAlarm myUpdateAlarm = new SingleAlarm(() -> {
        ToolWindow window = ProblemsView.getToolWindow(this.getProject());
        if (window == null) {
            return;
        }
        ContentManager manager = window.getContentManagerIfCreated();
        if (manager == null) {
            return;
        }
        Content content2 = manager.getContent((JComponent)((Object)this));
        if (content2 == null) {
            return;
        }
        Root root = this.myTreeModel.getRoot();
        int count = root == null ? 0 : root.getProblemsCount();
        content2.setDisplayName(this.getContentDisplayName(count));
        Icon icon2 = this.getToolWindowIcon(count);
        if (icon2 != null) {
            window.setIcon(icon2);
        }
    }, 50, ModalityState.stateForComponent((Component)((Object)this)), (Disposable)this);
    private final ToggleOptionAction.Option myAutoscrollToSource = new ToggleOptionAction.Option(){

        public boolean isSelected() {
            return ProblemsViewPanel.this.myState.getAutoscrollToSource();
        }

        public void setSelected(boolean selected2) {
            ProblemsViewPanel.this.myState.setAutoscrollToSource(selected2);
            if (selected2) {
                ProblemsViewPanel.this.updateAutoscroll(ProblemsViewPanel.this.getSelectedDescriptor());
            }
        }
    };
    private final ToggleOptionAction.Option myShowPreview = new ToggleOptionAction.Option(){

        public boolean isEnabled() {
            OpenFileDescriptor descriptor2 = ProblemsViewPanel.this.getSelectedDescriptor();
            return descriptor2 != null && null != ProblemsView.getDocument(ProblemsViewPanel.this.getProject(), descriptor2.getFile());
        }

        public boolean isAlwaysVisible() {
            return true;
        }

        public boolean isSelected() {
            return ProblemsViewPanel.this.myState.getShowPreview();
        }

        public void setSelected(boolean selected2) {
            ProblemsViewPanel.this.myState.setShowPreview(selected2);
            ProblemsViewPanel.this.updatePreview(ProblemsViewPanel.this.getSelectedDescriptor());
        }
    };
    private final ToggleOptionAction.Option mySortFoldersFirst = new ToggleOptionAction.Option(){

        public boolean isSelected() {
            return ProblemsViewPanel.this.myState.getSortFoldersFirst();
        }

        public void setSelected(boolean selected2) {
            ProblemsViewPanel.this.myState.setSortFoldersFirst(selected2);
            ProblemsViewPanel.this.myTreeModel.setComparator(ProblemsViewPanel.this.createComparator());
        }
    };
    private final ToggleOptionAction.Option mySortBySeverity = new ToggleOptionAction.Option(){

        public boolean isSelected() {
            return ProblemsViewPanel.this.myState.getSortBySeverity();
        }

        public void setSelected(boolean selected2) {
            ProblemsViewPanel.this.myState.setSortBySeverity(selected2);
            ProblemsViewPanel.this.myTreeModel.setComparator(ProblemsViewPanel.this.createComparator());
        }
    };
    private final ToggleOptionAction.Option mySortByName = new ToggleOptionAction.Option(){

        public boolean isSelected() {
            return ProblemsViewPanel.this.myState.getSortByName();
        }

        public void setSelected(boolean selected2) {
            ProblemsViewPanel.this.myState.setSortByName(selected2);
            ProblemsViewPanel.this.myTreeModel.setComparator(ProblemsViewPanel.this.createComparator());
        }
    };

    ProblemsViewPanel(@NotNull Project project, @NotNull ProblemsViewState state) {
        super(false, 0.5f, 0.1f, 0.9f);
        this.myProject = project;
        this.myState = state;
        this.myTreeModel.setComparator(this.createComparator());
        this.myTree = new Tree((TreeModel)((Object)new AsyncTreeModel((TreeModel)((Object)this.myTreeModel), this)));
        this.myTree.setRootVisible(false);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.addTreeSelectionListener((TreeSelectionListener)new RestoreSelectionListener());
        this.myTree.addTreeSelectionListener(event -> this.mySelectionAlarm.cancelAndRequest());
        new TreeSpeedSearch((JTree)this.myTree);
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        EditSourceOnEnterKeyHandler.install((JTree)this.myTree);
        PopupHandler.installPopupHandler((JComponent)this.myTree, (String)"ProblemsView.ToolWindow.TreePopup", (String)"popup");
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTree);
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("ProblemsView.ToolWindow.Toolbar");
        this.myToolbar = ActionManager.getInstance().createActionToolbar(((Object)((Object)this)).getClass().getName(), group, false);
        this.myToolbar.getComponent().setVisible(state.getShowToolbar());
        UIUtil.addBorder((JComponent)this.myToolbar.getComponent(), (Border)new CustomLineBorder(this.myToolbarInsets));
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add("Center", ScrollPaneFactory.createScrollPane((Component)this.myTree, (boolean)true));
        this.myPanel.add("West", this.myToolbar.getComponent());
        this.setFirstComponent(this.myPanel);
        this.putClientProperty(UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> JBIterable.of((Object)this.myPreview).filter(component2 -> null == component2.getParent()).iterator());
    }

    public void dispose() {
        this.myPreview.preview(null, false);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.getProject();
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            return this.getTreeExpander();
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData((DataProvider)this);
            return file2 == null ? null : this.getPreview().findFileEditor(file2, this.getProject());
        }
        OpenFileDescriptor descriptor2 = this.getSelectedDescriptor();
        if (descriptor2 != null) {
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return descriptor2;
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return descriptor2.getFile();
            }
            if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                return new Navigatable[]{descriptor2};
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                return new VirtualFile[]{descriptor2.getFile()};
            }
        }
        return null;
    }

    @NotNull
    abstract String getDisplayName();

    final void updateToolWindowContent() {
        this.myUpdateAlarm.cancelAndRequest();
    }

    @Nullable
    Icon getToolWindowIcon(int count) {
        return null;
    }

    @NotNull
    String getContentDisplayName(int count) {
        String name = this.getDisplayName();
        if (count <= 0) {
            return name;
        }
        return "<html><body>" + name + " <font color='" + ColorUtil.toHtmlColor((Color)UIUtil.getInactiveTextColor()) + "'>" + count + "</font></body></html>";
    }

    protected void loadProportion() {
        if (this.myState != null) {
            this.setProportion(this.myState.getProportion());
        }
    }

    protected void saveProportion() {
        if (this.myState != null) {
            this.myState.setProportion(this.getProportion());
        }
    }

    @NotNull
    final Project getProject() {
        return this.myProject;
    }

    @NotNull
    final ProblemsViewState getState() {
        return this.myState;
    }

    @NotNull
    final ProblemsTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    @NotNull
    final Tree getTree() {
        return this.myTree;
    }

    @NotNull
    final ProblemsViewPreview getPreview() {
        return this.myPreview;
    }

    @Nullable
    TreeExpander getTreeExpander() {
        return this.myTreeExpander;
    }

    void orientationChangedTo(boolean vertical) {
        this.setOrientation(vertical);
        this.myPanel.remove(this.myToolbar.getComponent());
        this.myToolbar.setOrientation(vertical ? 0 : 1);
        this.myToolbarInsets.right = !vertical ? JBUIScale.scale((int)1) : 0;
        this.myToolbarInsets.bottom = vertical ? JBUIScale.scale((int)1) : 0;
        this.myPanel.add(vertical ? "North" : "West", this.myToolbar.getComponent());
        this.updatePreview(this.getSelectedDescriptor());
    }

    void selectionChangedTo(boolean selected2) {
        if (selected2) {
            this.myTreeModel.setComparator(this.createComparator());
            this.updatePreview(this.getSelectedDescriptor());
            ToolWindow window = ProblemsView.getToolWindow(this.getProject());
            if (window instanceof ToolWindowEx) {
                ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("ProblemsView.ToolWindow.SecondaryActions");
                ((ToolWindowEx)window).setAdditionalGearActions(group);
            }
        }
    }

    @Nullable
    private OpenFileDescriptor getSelectedDescriptor() {
        Object object = TreeUtil.getLastUserObject((TreePath)this.getTree().getSelectionPath());
        if (object instanceof FileNode) {
            return this.getDescriptor((FileNode)((Object)object));
        }
        if (object instanceof ProblemNode) {
            return this.getDescriptor((ProblemNode)((Object)object));
        }
        return null;
    }

    @Nullable
    private OpenFileDescriptor getDescriptor(@NotNull FileNode node) {
        return this.getDescriptor(node.getFile(), -1);
    }

    @Nullable
    private OpenFileDescriptor getDescriptor(@NotNull ProblemNode node) {
        return this.getDescriptor(node.getFile(), node.getOffset());
    }

    @Nullable
    private OpenFileDescriptor getDescriptor(@NotNull VirtualFile file2, int offset) {
        Document document = ProblemsView.getDocument(this.getProject(), file2);
        if (document == null) {
            return null;
        }
        if (offset < 0) {
            return new OpenFileDescriptor(this.getProject(), file2);
        }
        int length = document.getTextLength();
        if (offset <= length) {
            return new OpenFileDescriptor(this.getProject(), file2, offset);
        }
        LOG.warn("offset is bigger then document length: " + file2);
        return new OpenFileDescriptor(this.getProject(), file2, length);
    }

    private void updateAutoscroll(@Nullable OpenFileDescriptor descriptor2) {
        if (descriptor2 != null && UIUtil.isFocusAncestor((Component)((Object)this)) && ProblemsViewPanel.isNotNullAndSelected(this.getAutoscrollToSource())) {
            this.invokeLater(() -> OpenSourceUtil.navigate((boolean)false, (Navigatable[])new Navigatable[]{descriptor2}));
        }
    }

    private void updatePreview(@Nullable OpenFileDescriptor descriptor2) {
        Editor editor = this.myPreview.preview(descriptor2, ProblemsViewPanel.isNotNullAndSelected(this.getShowPreview()));
        if (editor != null && descriptor2 != null) {
            this.invokeLater(() -> {
                if (editor.getComponent().isShowing()) {
                    descriptor2.navigateIn(editor);
                }
            });
        }
    }

    private void invokeLater(@NotNull Runnable runnable2) {
        ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.stateForComponent((Component)((Object)this)));
    }

    void select(@NotNull Node node) {
        TreeUtil.promiseSelect((JTree)this.getTree(), (TreeVisitor)this.createVisitor(node));
    }

    @NotNull
    TreeVisitor createVisitor(@NotNull Node node) {
        return new TreeVisitor.ByTreePath(node.getPath(), o -> o);
    }

    @NotNull
    Comparator<Node> createComparator() {
        return new NodeComparator(ProblemsViewPanel.isNullableOrSelected(this.getSortFoldersFirst()), ProblemsViewPanel.isNullableOrSelected(this.getSortBySeverity()), ProblemsViewPanel.isNotNullAndSelected(this.getSortByName()));
    }

    @Nullable
    ToggleOptionAction.Option getAutoscrollToSource() {
        return ProblemsViewPanel.isNotNullAndSelected(this.getShowPreview()) ? null : this.myAutoscrollToSource;
    }

    @Nullable
    ToggleOptionAction.Option getShowPreview() {
        return this.myShowPreview;
    }

    @Nullable
    ToggleOptionAction.Option getSortFoldersFirst() {
        return this.mySortFoldersFirst;
    }

    @Nullable
    ToggleOptionAction.Option getSortBySeverity() {
        return this.mySortBySeverity;
    }

    @Nullable
    ToggleOptionAction.Option getSortByName() {
        return this.mySortByName;
    }

    private static boolean isNotNullAndSelected(@Nullable ToggleOptionAction.Option option2) {
        return option2 != null && option2.isSelected();
    }

    private static boolean isNullableOrSelected(@Nullable ToggleOptionAction.Option option2) {
        return option2 == null || option2.isSelected();
    }
}

