/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl.java;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.CannotCreateJavaCompilerException;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.javac.JavacMain;

public class JavacCompilerTool
extends JavaCompilingTool {
    public static final String ID = "Javac";
    public static final String ALTERNATIVE_ID = "compAPI";

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @Nullable
    public String getAlternativeId() {
        return ALTERNATIVE_ID;
    }

    @Override
    public boolean isCompilerTreeAPISupported() {
        return true;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "javac " + System.getProperty("java.version");
    }

    @Override
    @NotNull
    public JavaCompiler createCompiler() throws CannotCreateJavaCompilerException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler != null) {
            return compiler;
        }
        try {
            return (JavaCompiler)Class.forName("com.sun.tools.javac.api.JavacTool", true, JavacMain.class.getClassLoader()).newInstance();
        }
        catch (Throwable ex) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("System Java Compiler was not found in classpath");
            stringWriter.write(":\n");
            ex.printStackTrace(new PrintWriter(stringWriter));
            String message = stringWriter.getBuffer().toString();
            throw new CannotCreateJavaCompilerException(message);
        }
    }

    @Override
    @NotNull
    public List<File> getAdditionalClasspath() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getDefaultCompilerOptions() {
        return Collections.singletonList("-implicit:class");
    }
}

