/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.google.gct.login.GoogleLogin;
import com.google.gct.login.InvalidThreadTypeException;
import com.google.services.firebase.FirebaseAnalyticsProvider;
import com.google.services.firebase.view.FirebaseUiUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

class GoogleLoginManager {
    private final GoogleLogin googleLogin;
    private final Project project;
    private final Runnable successCallback;
    private final Runnable errorCallback;

    private GoogleLoginManager(GoogleLogin googleLogin, Project project, Runnable successCallback, Runnable errorCallback) {
        this.googleLogin = googleLogin;
        this.project = project;
        this.successCallback = successCallback;
        this.errorCallback = errorCallback;
    }

    private void logMeIn() {
        try {
            new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_ATTEMPT_LOGIN).withProject(this.project).log();
            GoogleLogin.promptToLogIn(null, () -> ApplicationManager.getApplication().invokeLater(this::onLoginComplete));
        }
        catch (InvalidThreadTypeException invalidThreadException) {
            FirebaseUiUtils.showTrackedErrorBalloon(this.project, invalidThreadException, "firebaseService.internalError.couldNotVerifySignIn", new Object[0]);
        }
    }

    private void onLoginComplete() {
        if (this.googleLogin.isLoggedIn()) {
            new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_LOGIN_SUCCESS).withProject(this.project).log();
            this.successCallback.run();
            return;
        }
        this.errorCallback.run();
    }

    static void login(@NotNull Project project, @NotNull Runnable successCallback, @NotNull Runnable errorCallback) {
        GoogleLogin googleLogin = GoogleLogin.getInstance();
        if (googleLogin.isLoggedIn()) {
            successCallback.run();
        } else {
            new GoogleLoginManager(googleLogin, project, successCallback, errorCallback).logMeIn();
        }
    }
}

