/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.TestRunner;

@State(name="GradleMigrationSettings", storages={@Storage(value="gradle.xml")})
public class GradleSettingsMigration
implements PersistentStateComponent<Element> {
    private Element myElement = new Element("settings");

    public int getMigrationVersion() {
        return StringUtil.parseInt((String)this.myElement.getAttributeValue("migrationVersion"), (int)0);
    }

    public void setMigrationVersion(int version) {
        this.myElement.setAttribute("migrationVersion", String.valueOf(version));
    }

    @NotNull
    public Element getState() {
        return this.myElement;
    }

    public void loadState(@NotNull Element state) {
        this.myElement = state;
    }

    @State(name="DefaultGradleProjectSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
    public static class LegacyDefaultGradleProjectSettings
    implements PersistentStateComponent<MyState> {
        @Nullable
        private MyState myState = null;

        @Nullable
        public MyState getState() {
            return this.myState;
        }

        public void loadState(@NotNull MyState state) {
            this.myState = state;
        }

        public static class MyState {
            @NotNull
            public TestRunner testRunner = TestRunner.PLATFORM;
            public boolean delegatedBuild = false;
        }
    }
}

