/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="gradleExecuteTaskHistory", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ExecuteGradleTaskHistoryService
implements PersistentStateComponent<String[]> {
    private static final int MAX_HISTORY_LENGTH = 20;
    private final LinkedList<String> myHistory = new LinkedList();
    private String myWorkDirectory = "";
    private String myCanceledCommand;

    public static ExecuteGradleTaskHistoryService getInstance(@NotNull Project project) {
        return (ExecuteGradleTaskHistoryService)ServiceManager.getService((Project)project, ExecuteGradleTaskHistoryService.class);
    }

    @Nullable
    public String getCanceledCommand() {
        return this.myCanceledCommand;
    }

    public void setCanceledCommand(@Nullable String canceledCommand) {
        this.myCanceledCommand = canceledCommand;
    }

    public void addCommand(@NotNull String command, @NotNull String projectPath) {
        this.myWorkDirectory = projectPath.trim();
        if ((command = command.trim()).length() == 0) {
            return;
        }
        this.myHistory.remove(command);
        this.myHistory.addFirst(command);
        while (this.myHistory.size() > 20) {
            this.myHistory.removeLast();
        }
    }

    public List<String> getHistory() {
        return new ArrayList<String>(this.myHistory);
    }

    @NotNull
    public String getWorkDirectory() {
        return this.myWorkDirectory;
    }

    public String @Nullable [] getState() {
        String[] res = new String[this.myHistory.size() + 1];
        res[0] = this.myWorkDirectory;
        int i2 = 1;
        for (String goal : this.myHistory) {
            res[i2++] = goal;
        }
        return res;
    }

    public void loadState(String @NotNull [] state) {
        if (state.length == 0) {
            this.myWorkDirectory = "";
            this.myHistory.clear();
        } else {
            this.myWorkDirectory = state[0];
            this.myHistory.addAll(Arrays.asList(state).subList(1, state.length));
        }
    }
}

