/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=-2147483637)
public class GradleSourceSetDataService
extends AbstractModuleDataService<GradleSourceSetData> {
    @NotNull
    public Key<GradleSourceSetData> getTargetDataKey() {
        return GradleSourceSetData.KEY;
    }

    @NotNull
    public Computable<Collection<Module>> computeOrphanData(@NotNull Collection<DataNode<GradleSourceSetData>> toImport, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        return () -> {
            SmartList orphanIdeModules = new SmartList();
            for (Module module : modelsProvider.getModules()) {
                if (module.isDisposed() || !ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module) || !"sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module))) continue;
                String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
                if (!projectData.getLinkedExternalProjectPath().equals(rootProjectPath) || module.getUserData(AbstractModuleDataService.MODULE_DATA_KEY) != null) continue;
                orphanIdeModules.add(module);
            }
            return orphanIdeModules;
        };
    }

    @NotNull
    protected Module createModule(@NotNull DataNode<GradleSourceSetData> sourceSetModuleNode, @NotNull IdeModifiableModelsProvider modelsProvider) {
        String sourceSetModuleInternalName;
        DataNode parentModuleNode = sourceSetModuleNode.getParent();
        assert (parentModuleNode != null);
        Module parentModule = (Module)parentModuleNode.getUserData(MODULE_KEY);
        assert (parentModule != null);
        String projectPath = ((GradleSourceSetData)((Object)sourceSetModuleNode.getData())).getLinkedExternalProjectPath();
        ExternalProjectSettings settings2 = ExternalSystemApiUtil.getSettings((Project)parentModule.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID).getLinkedProjectSettings(projectPath);
        if (settings2 != null && settings2.isUseQualifiedModuleNames() && !(sourceSetModuleInternalName = ((GradleSourceSetData)((Object)sourceSetModuleNode.getData())).getInternalName()).startsWith(parentModule.getName())) {
            String sourceSetName = ((GradleSourceSetData)((Object)sourceSetModuleNode.getData())).getModuleName();
            String adjustedInternalName = GradleSourceSetDataService.findDeduplicatedModuleName(parentModule.getName() + "." + sourceSetName, modelsProvider);
            ((GradleSourceSetData)((Object)sourceSetModuleNode.getData())).setInternalName(adjustedInternalName);
        }
        return super.createModule(sourceSetModuleNode, modelsProvider);
    }

    @NotNull
    private static String findDeduplicatedModuleName(@NotNull String moduleName, @NotNull IdeModifiableModelsProvider modelsProvider) {
        String nextModuleNameCandidate;
        Module ideModule = modelsProvider.findIdeModule(moduleName);
        if (ideModule == null) {
            return moduleName;
        }
        int i2 = 0;
        while ((ideModule = modelsProvider.findIdeModule(nextModuleNameCandidate = moduleName + "~" + ++i2)) != null) {
        }
        return nextModuleNameCandidate;
    }

    protected void setModuleOptions(Module module, DataNode<GradleSourceSetData> moduleDataNode) {
        super.setModuleOptions(module, moduleDataNode);
        ExternalSystemModulePropertyManager.getInstance((Module)module).setExternalModuleType("sourceSet");
    }
}

