/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.Build;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.model.data.CompositeBuildData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ToolingModelsProviderImpl;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleBuildSrcProjectsResolver {
    public static final String BUILD_SRC_MODULE_PROPERTY = "buildSrcModule";
    @NotNull
    private final GradleProjectResolver myProjectResolver;
    @NotNull
    private final DefaultProjectResolverContext myResolverContext;
    @Nullable
    private final File myGradleUserHome;
    @Nullable
    private final GradleExecutionSettings myMainBuildExecutionSettings;
    @NotNull
    private final ExternalSystemTaskNotificationListener myListener;
    @NotNull
    private final ExternalSystemTaskId mySyncTaskId;
    @NotNull
    private final GradleProjectResolverExtension myResolverChain;

    public GradleBuildSrcProjectsResolver(@NotNull GradleProjectResolver projectResolver, @NotNull DefaultProjectResolverContext resolverContext, @Nullable File gradleUserHome, @Nullable GradleExecutionSettings mainBuildSettings, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ExternalSystemTaskId syncTaskId, @NotNull GradleProjectResolverExtension projectResolverChain) {
        this.myProjectResolver = projectResolver;
        this.myResolverContext = resolverContext;
        this.myGradleUserHome = gradleUserHome;
        this.myMainBuildExecutionSettings = mainBuildSettings;
        this.myListener = listener2;
        this.mySyncTaskId = syncTaskId;
        this.myResolverChain = projectResolverChain;
    }

    public void discoverAndAppendTo(@NotNull DataNode<ProjectData> mainBuildProjectDataNode) {
        String gradleHome = this.myGradleUserHome == null ? null : this.myGradleUserHome.getPath();
        ProjectData mainBuildProjectData = (ProjectData)mainBuildProjectDataNode.getData();
        String projectPath = mainBuildProjectData.getLinkedExternalProjectPath();
        HashMap<String, Object> includedBuildsPaths = new HashMap<String, Object>();
        HashMap<Object, String> buildNames = new HashMap<Object, String>();
        buildNames.put(projectPath, mainBuildProjectData.getExternalName());
        CompositeBuildData compositeBuildData = GradleBuildSrcProjectsResolver.getCompositeBuildData(mainBuildProjectDataNode);
        if (compositeBuildData != null) {
            for (BuildParticipant buildParticipant : compositeBuildData.getCompositeParticipants()) {
                String buildParticipantRootPath = buildParticipant.getRootPath();
                buildNames.put(buildParticipantRootPath, buildParticipant.getRootProjectName());
                for (String path : buildParticipant.getProjects()) {
                    includedBuildsPaths.put(path, buildParticipantRootPath);
                }
            }
        }
        MultiMap buildClasspathNodesMap = new MultiMap();
        HashMap<String, Object> includedModulesPaths = new HashMap<String, Object>();
        for (DataNode moduleDataNode : ExternalSystemApiUtil.findAll(mainBuildProjectDataNode, (Key)ProjectKeys.MODULE)) {
            String path;
            path = ((ModuleData)moduleDataNode.getData()).getLinkedExternalProjectPath();
            includedModulesPaths.put(path, moduleDataNode.getData());
            DataNode scriptClasspathDataNode = ExternalSystemApiUtil.find((DataNode)moduleDataNode, BuildScriptClasspathData.KEY);
            if (scriptClasspathDataNode == null) continue;
            String rootPath = (String)includedBuildsPaths.get(path);
            buildClasspathNodesMap.putValue((Object)Paths.get(rootPath != null ? rootPath : projectPath, new String[0]), (Object)scriptClasspathDataNode);
        }
        SmartList jvmOptions = new SmartList();
        BuildEnvironment mainBuildEnvironment = this.myResolverContext.getModels().getBuildEnvironment();
        if (mainBuildEnvironment != null) {
            jvmOptions.addAll(mainBuildEnvironment.getJava().getJvmArguments());
        }
        if (this.myMainBuildExecutionSettings != null) {
            jvmOptions.addAll(this.myMainBuildExecutionSettings.getJvmArguments());
        }
        Stream<Build> builds = new ToolingModelsProviderImpl(this.myResolverContext.getModels()).builds();
        builds.forEach(arg_0 -> this.lambda$discoverAndAppendTo$0(buildClasspathNodesMap, gradleHome, (List)jvmOptions, compositeBuildData, buildNames, mainBuildProjectDataNode, includedModulesPaths, arg_0));
    }

    private void includeRootBuildIncludedBuildsIfNeeded(@NotNull GradleExecutionSettings buildSrcProjectSettings, @Nullable CompositeBuildData compositeBuildData) {
        GradleVersion gradleBaseVersion;
        if (compositeBuildData == null) {
            return;
        }
        String projectGradleVersion = this.myResolverContext.getProjectGradleVersion();
        GradleVersion gradleVersion = gradleBaseVersion = projectGradleVersion == null ? null : GradleVersion.version((String)projectGradleVersion).getBaseVersion();
        if (gradleBaseVersion == null) {
            return;
        }
        if (gradleBaseVersion.compareTo(GradleVersion.version((String)"6.7")) < 0) {
            return;
        }
        for (BuildParticipant buildParticipant : compositeBuildData.getCompositeParticipants()) {
            buildSrcProjectSettings.withArguments(new String[]{"--include-build", buildParticipant.getRootPath()});
        }
    }

    @Nullable
    private static CompositeBuildData getCompositeBuildData(@NotNull DataNode<ProjectData> mainBuildProjectDataNode) {
        DataNode compositeBuildDataNode = ExternalSystemApiUtil.find(mainBuildProjectDataNode, CompositeBuildData.KEY);
        return compositeBuildDataNode != null ? (CompositeBuildData)compositeBuildDataNode.getData() : null;
    }

    private void handleBuildSrcProject(@NotNull DataNode<ProjectData> resultProjectDataNode, @Nullable String buildName, @NotNull Collection<DataNode<BuildScriptClasspathData>> buildClasspathNodes, @NotNull Map<String, ModuleData> includedModulesPaths, @NotNull DefaultProjectResolverContext buildSrcResolverCtx, @NotNull Function<ProjectConnection, DataNode<ProjectData>> projectConnectionDataNodeFunction) {
        String projectPath = buildSrcResolverCtx.getProjectPath();
        File projectPathFile = new File(projectPath);
        if (!projectPathFile.isDirectory()) {
            return;
        }
        if (includedModulesPaths.containsKey(projectPath)) {
            return;
        }
        if (ArrayUtil.isEmpty((Object[])projectPathFile.list((dir, name) -> !name.equals(".gradle") && !name.equals("build")))) {
            return;
        }
        if (buildSrcResolverCtx.isPreviewMode()) {
            ModuleData buildSrcModuleData = new ModuleData(":buildSrc", GradleConstants.SYSTEM_ID, GradleProjectResolverUtil.getDefaultModuleTypeId(), "buildSrc", projectPath, projectPath);
            buildSrcModuleData.setProperty(BUILD_SRC_MODULE_PROPERTY, "true");
            resultProjectDataNode.createChild(ProjectKeys.MODULE, (Object)buildSrcModuleData);
            return;
        }
        DataNode<ProjectData> buildSrcProjectDataNode = this.myProjectResolver.getHelper().execute(projectPath, buildSrcResolverCtx.getSettings(), this.mySyncTaskId, this.myListener, null, projectConnectionDataNodeFunction);
        if (buildSrcProjectDataNode == null) {
            return;
        }
        for (DataNode libraryDataNode : ExternalSystemApiUtil.getChildren(buildSrcProjectDataNode, (Key)ProjectKeys.LIBRARY)) {
            resultProjectDataNode.createChild(ProjectKeys.LIBRARY, libraryDataNode.getData());
        }
        HashMap<String, DataNode> buildSrcModules = new HashMap<String, DataNode>();
        boolean modulePerSourceSet = buildSrcResolverCtx.isResolveModulePerSourceSet();
        DataNode buildSrcModuleNode = null;
        for (DataNode moduleNode : ExternalSystemApiUtil.getChildren(buildSrcProjectDataNode, (Key)ProjectKeys.MODULE)) {
            ModuleData includedModule;
            ModuleData moduleData = (ModuleData)moduleNode.getData();
            buildSrcModules.put(moduleData.getId(), moduleNode);
            boolean isBuildSrcModule = "buildSrc".equals(moduleData.getExternalName());
            if (isBuildSrcModule && !modulePerSourceSet) {
                buildSrcModuleNode = moduleNode;
            }
            if (modulePerSourceSet) {
                for (DataNode sourceSetNode : ExternalSystemApiUtil.getChildren((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                    buildSrcModules.put(((GradleSourceSetData)((Object)sourceSetNode.getData())).getId(), sourceSetNode);
                    if (!isBuildSrcModule || buildSrcModuleNode != null || !((GradleSourceSetData)((Object)sourceSetNode.getData())).getExternalName().endsWith(":main")) continue;
                    buildSrcModuleNode = sourceSetNode;
                }
            }
            if ((includedModule = includedModulesPaths.get(moduleData.getLinkedExternalProjectPath())) == null) {
                moduleData.setProperty(BUILD_SRC_MODULE_PROPERTY, "true");
                resultProjectDataNode.addChild(moduleNode);
                if (buildSrcResolverCtx.isUseQualifiedModuleNames() || moduleData.getIdeModuleGroup() == null) continue;
                String[] moduleGroup = (String[])ArrayUtil.prepend((Object)(StringUtil.isNotEmpty((String)buildName) ? buildName : ((ProjectData)resultProjectDataNode.getData()).getInternalName()), (Object[])moduleData.getIdeModuleGroup());
                moduleData.setIdeModuleGroup(moduleGroup);
                for (DataNode sourceSetNode : ExternalSystemApiUtil.getChildren((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                    ((GradleSourceSetData)((Object)sourceSetNode.getData())).setIdeModuleGroup(moduleGroup);
                }
                continue;
            }
            includedModule.setProperty(BUILD_SRC_MODULE_PROPERTY, "true");
        }
        if (buildSrcModuleNode != null) {
            THashSet buildSrcRuntimeSourcesPaths = new THashSet();
            THashSet buildSrcRuntimeClassesPaths = new THashSet();
            GradleBuildSrcProjectsResolver.addSourcePaths((Set<String>)buildSrcRuntimeSourcesPaths, buildSrcModuleNode);
            for (DataNode child : buildSrcModuleNode.getChildren()) {
                LibraryDependencyData dependencyData;
                Object childData = child.getData();
                if (childData instanceof ModuleDependencyData && ((ModuleDependencyData)childData).getScope().isForProductionRuntime()) {
                    DataNode depModuleNode = (DataNode)buildSrcModules.get(((ModuleData)((ModuleDependencyData)childData).getTarget()).getId());
                    if (depModuleNode == null) continue;
                    GradleBuildSrcProjectsResolver.addSourcePaths((Set<String>)buildSrcRuntimeSourcesPaths, (DataNode<? extends ModuleData>)depModuleNode);
                    continue;
                }
                if (!(childData instanceof LibraryDependencyData) || (dependencyData = (LibraryDependencyData)childData).getExternalName().startsWith("gradle-api-")) continue;
                LibraryData libraryData = (LibraryData)dependencyData.getTarget();
                buildSrcRuntimeSourcesPaths.addAll(libraryData.getPaths(LibraryPathType.SOURCE));
                buildSrcRuntimeClassesPaths.addAll(libraryData.getPaths(LibraryPathType.BINARY));
            }
            if (!buildSrcRuntimeSourcesPaths.isEmpty() || !buildSrcRuntimeClassesPaths.isEmpty()) {
                buildClasspathNodes.forEach(arg_0 -> GradleBuildSrcProjectsResolver.lambda$handleBuildSrcProject$2((Set)buildSrcRuntimeClassesPaths, (Set)buildSrcRuntimeSourcesPaths, arg_0));
            }
        }
    }

    private static void addSourcePaths(Set<String> paths, DataNode<? extends ModuleData> moduleNode) {
        ExternalSystemApiUtil.getChildren(moduleNode, (Key)ProjectKeys.CONTENT_ROOT).stream().flatMap(contentNode -> ((ContentRootData)contentNode.getData()).getPaths(ExternalSystemSourceType.SOURCE).stream()).map(ContentRootData.SourceRoot::getPath).forEach(paths::add);
    }

    @NotNull
    private static String getBuildSrcGroup(String buildPath, String buildName) {
        if (StringUtil.isEmpty((String)buildName)) {
            return new File(buildPath).getName();
        }
        return buildName;
    }

    private static /* synthetic */ void lambda$handleBuildSrcProject$2(Set buildSrcRuntimeClassesPaths, Set buildSrcRuntimeSourcesPaths, DataNode classpathNode) {
        BuildScriptClasspathData copyFrom = (BuildScriptClasspathData)((Object)classpathNode.getData());
        ArrayList<BuildScriptClasspathData.ClasspathEntry> classpathEntries = new ArrayList<BuildScriptClasspathData.ClasspathEntry>(copyFrom.getClasspathEntries().size() + 1);
        classpathEntries.addAll(copyFrom.getClasspathEntries());
        classpathEntries.add(BuildScriptClasspathData.ClasspathEntry.create((Set<String>)new THashSet((Collection)buildSrcRuntimeClassesPaths), (Set<String>)new THashSet((Collection)buildSrcRuntimeSourcesPaths), Collections.emptySet()));
        BuildScriptClasspathData buildScriptClasspathData = new BuildScriptClasspathData(GradleConstants.SYSTEM_ID, classpathEntries);
        buildScriptClasspathData.setGradleHomeDir(copyFrom.getGradleHomeDir());
        DataNode parent = classpathNode.getParent();
        assert (parent != null);
        parent.createChild(BuildScriptClasspathData.KEY, (Object)buildScriptClasspathData);
        classpathNode.clear(true);
    }

    private /* synthetic */ void lambda$discoverAndAppendTo$0(MultiMap buildClasspathNodesMap, String gradleHome, List jvmOptions, CompositeBuildData compositeBuildData, Map buildNames, DataNode mainBuildProjectDataNode, Map includedModulesPaths, Build build) {
        GradleExecutionSettings buildSrcProjectSettings;
        String buildPath = build.getBuildIdentifier().getRootDir().getPath();
        Collection buildClasspathNodes = buildClasspathNodesMap.getModifiable((Object)Paths.get(buildPath, new String[0]));
        if (gradleHome != null) {
            if (this.myMainBuildExecutionSettings != null) {
                buildSrcProjectSettings = new GradleExecutionSettings(gradleHome, this.myMainBuildExecutionSettings.getServiceDirectory(), DistributionType.LOCAL, this.myMainBuildExecutionSettings.isOfflineWork());
                buildSrcProjectSettings.setIdeProjectPath(this.myMainBuildExecutionSettings.getIdeProjectPath());
                buildSrcProjectSettings.setJavaHome(this.myMainBuildExecutionSettings.getJavaHome());
                buildSrcProjectSettings.setResolveModulePerSourceSet(this.myMainBuildExecutionSettings.isResolveModulePerSourceSet());
                buildSrcProjectSettings.setUseQualifiedModuleNames(this.myMainBuildExecutionSettings.isUseQualifiedModuleNames());
                buildSrcProjectSettings.setRemoteProcessIdleTtlInMs(this.myMainBuildExecutionSettings.getRemoteProcessIdleTtlInMs());
                buildSrcProjectSettings.setVerboseProcessing(this.myMainBuildExecutionSettings.isVerboseProcessing());
                buildSrcProjectSettings.setWrapperPropertyFile(this.myMainBuildExecutionSettings.getWrapperPropertyFile());
                buildSrcProjectSettings.withArguments(this.myMainBuildExecutionSettings.getArguments()).withEnvironmentVariables(this.myMainBuildExecutionSettings.getEnv()).passParentEnvs(this.myMainBuildExecutionSettings.isPassParentEnvs()).withVmOptions((Collection)jvmOptions);
            } else {
                buildSrcProjectSettings = new GradleExecutionSettings(gradleHome, null, DistributionType.LOCAL, false);
            }
            this.includeRootBuildIncludedBuildsIfNeeded(buildSrcProjectSettings, compositeBuildData);
        } else {
            buildSrcProjectSettings = this.myMainBuildExecutionSettings;
        }
        String buildSrcProjectPath = buildPath + "/buildSrc";
        DefaultProjectResolverContext buildSrcResolverCtx = new DefaultProjectResolverContext(this.mySyncTaskId, buildSrcProjectPath, buildSrcProjectSettings, this.myListener, this.myResolverContext.getPolicy(), false);
        this.myResolverContext.copyUserDataTo(buildSrcResolverCtx);
        String buildName = (String)buildNames.get(buildPath);
        String buildSrcGroup = GradleBuildSrcProjectsResolver.getBuildSrcGroup(buildPath, buildName);
        buildSrcResolverCtx.setBuildSrcGroup(buildSrcGroup);
        this.handleBuildSrcProject((DataNode<ProjectData>)mainBuildProjectDataNode, buildName, buildClasspathNodes, includedModulesPaths, buildSrcResolverCtx, this.myProjectResolver.getProjectDataFunction(buildSrcResolverCtx, this.myResolverChain, true));
    }
}

