/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueChecker;
import com.intellij.build.issue.BuildIssueData;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.List;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectImportErrorHandler;

public class BaseProjectImportErrorHandler
extends AbstractProjectImportErrorHandler {
    private static final Logger LOG = Logger.getInstance(BaseProjectImportErrorHandler.class);

    @Override
    @NotNull
    public ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        GradleExecutionErrorHandler executionErrorHandler = new GradleExecutionErrorHandler(error, projectPath, buildFilePath);
        ExternalSystemException exception = this.doGetUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath, executionErrorHandler);
        if (!exception.isCauseInitialized()) {
            exception.initCause((Throwable)ObjectUtils.notNull((Object)executionErrorHandler.getRootCause(), (Object)error));
        }
        return exception;
    }

    @ApiStatus.Experimental
    ExternalSystemException checkErrorsWithoutQuickFixes(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath, @NotNull ExternalSystemException e) {
        if (e.getQuickFixes().length > 0 || e instanceof BuildIssueException) {
            return e;
        }
        return this.getUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath);
    }

    /*
     * WARNING - void declaration
     */
    private ExternalSystemException doGetUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath, @NotNull GradleExecutionErrorHandler executionErrorHandler) {
        void var12_36;
        String string;
        Throwable throwable;
        String string2;
        ExternalSystemException friendlyError = executionErrorHandler.getUserFriendlyError();
        if (friendlyError != null) {
            return friendlyError;
        }
        LOG.debug(String.format("Failed to run Gradle project at '%1$s'", projectPath), error);
        Throwable rootCause = executionErrorHandler.getRootCause();
        String location = executionErrorHandler.getLocation();
        if (location == null && !StringUtil.isEmpty((String)buildFilePath)) {
            location = String.format("Build file: '%1$s'", buildFilePath);
        }
        GradleIssueData issueData = new GradleIssueData(projectPath, error, buildEnvironment, null);
        List<GradleIssueChecker> knownIssuesCheckList = GradleIssueChecker.getKnownIssuesCheckList();
        for (BuildIssueChecker buildIssueChecker : knownIssuesCheckList) {
            BuildIssue buildIssue = buildIssueChecker.check((BuildIssueData)issueData);
            if (buildIssue == null) continue;
            return new BuildIssueException(buildIssue);
        }
        if (rootCause instanceof UnsupportedVersionException) {
            String msg2 = "You are using unsupported version of Gradle.";
            msg2 = msg2 + "\nPlease point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
            return this.createUserFriendlyError(msg2, null, new String[0]);
        }
        String rootCauseMessage = rootCause.getMessage();
        if (rootCause.getClass().getName().equals(CommandLineArgumentException.class.getName()) && StringUtil.contains((CharSequence)rootCauseMessage, (CharSequence)"Unknown command-line option '--include-build'")) {
            String string3 = String.format("Gradle composite build support available for Gradle 3.1 or better version (<a href=\"%s\">Fix Gradle settings</a>)", "open_gradle_settings");
            return this.createUserFriendlyError(string3, location, "open_gradle_settings");
        }
        if (rootCause instanceof OutOfMemoryError) {
            void var12_19;
            void var12_16;
            String string4 = "Out of memory";
            if (rootCauseMessage != null && !rootCauseMessage.isEmpty()) {
                String string5 = string4 + ": " + rootCauseMessage;
            }
            if (var12_16.endsWith("Java heap space")) {
                String string6 = (String)var12_16 + ". Configure Gradle memory settings using '-Xmx' JVM option (e.g. '-Xmx2048m'.)";
            } else if (!var12_16.endsWith(".")) {
                String string7 = (String)var12_16 + ".";
            }
            String string8 = (String)var12_19 + "\n\nPlease fix the project's Gradle settings.";
            return this.createUserFriendlyError(string8, null, new String[0]);
        }
        if (rootCause instanceof ClassNotFoundException) {
            String string9 = String.format("Unable to load class '%1$s'.", rootCauseMessage) + "\n\n" + "This is an unexpected error. Please file a bug containing the idea.log file.";
            return this.createUserFriendlyError(string9, null, new String[0]);
        }
        if (rootCause instanceof UnknownHostException) {
            String string10 = String.format("Unknown host '%1$s'.", rootCauseMessage) + "\n\n" + "Please ensure the host name is correct. " + "If you are behind an HTTP proxy, please configure the proxy settings either in IDE or Gradle.";
            return this.createUserFriendlyError(string10, null, new String[0]);
        }
        if (rootCause instanceof ConnectException && (string2 = rootCauseMessage) != null && string2.contains("timed out")) {
            String string12 = string2 + (string2.endsWith(".") ? " " : ". ");
            string12 = string12 + "If you are behind an HTTP proxy, please configure the proxy settings either in IDE or Gradle.";
            return this.createUserFriendlyError(string12, null, new String[0]);
        }
        if (rootCause instanceof FileNotFoundException && (throwable = error.getCause()) instanceof IllegalArgumentException && GradleExecutionErrorHandler.DOWNLOAD_GRADLE_DISTIBUTION_ERROR_PATTERN.matcher(throwable.getMessage()).matches()) {
            return this.createUserFriendlyError(throwable.getMessage(), null, new String[0]);
        }
        if (rootCause instanceof RuntimeException && (string = rootCauseMessage) != null && GradleExecutionErrorHandler.UNSUPPORTED_GRADLE_VERSION_ERROR_PATTERN.matcher(string).matches()) {
            void var12_31;
            if (!string.endsWith(".")) {
                String string13 = string + ".";
            }
            String string14 = (String)var12_31 + "\n\nPlease fix the project's Gradle settings.";
            return this.createUserFriendlyError(string14, null, new String[0]);
        }
        if (rootCauseMessage == null || ApplicationManager.getApplication().isUnitTestMode()) {
            StringWriter writer = new StringWriter();
            if (rootCauseMessage != null) {
                writer.write(rootCauseMessage + "\n");
            }
            rootCause.printStackTrace(new PrintWriter(writer));
            String string15 = writer.toString();
        } else {
            String string16 = rootCauseMessage;
        }
        return this.createUserFriendlyError((String)var12_36, location, new String[0]);
    }
}

