/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.serialization.PropertyMapping;
import com.intellij.util.containers.Interner;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildScriptClasspathData
extends AbstractExternalEntityData {
    @NotNull
    public static final Key<BuildScriptClasspathData> KEY = Key.create(BuildScriptClasspathData.class, (int)(ProjectKeys.LIBRARY_DEPENDENCY.getProcessingWeight() + 1));
    @Nullable
    private File gradleHomeDir;
    @NotNull
    private final List<ClasspathEntry> classpathEntries;

    @PropertyMapping(value={"owner", "classpathEntries"})
    public BuildScriptClasspathData(@NotNull ProjectSystemId owner, @NotNull List<ClasspathEntry> classpathEntries) {
        super(owner);
        this.classpathEntries = classpathEntries;
    }

    @Nullable
    public File getGradleHomeDir() {
        return this.gradleHomeDir;
    }

    public void setGradleHomeDir(@Nullable File gradleHomeDir) {
        this.gradleHomeDir = gradleHomeDir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildScriptClasspathData data = (BuildScriptClasspathData)((Object)o);
        return Objects.equals(this.gradleHomeDir, data.gradleHomeDir) && this.classpathEntries.equals(data.classpathEntries);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.gradleHomeDir, this.classpathEntries);
    }

    @NotNull
    public List<ClasspathEntry> getClasspathEntries() {
        return this.classpathEntries;
    }

    public static final class ClasspathEntry {
        private static final Interner<ClasspathEntry> ourEntryInterner = Interner.createWeakInterner();
        @NotNull
        private final Set<String> classesFile;
        @NotNull
        private final Set<String> sourcesFile;
        @NotNull
        private final Set<String> javadocFile;

        public static ClasspathEntry create(@NotNull Set<String> classesFile, @NotNull Set<String> sourcesFile, @NotNull Set<String> javadocFile) {
            return (ClasspathEntry)ourEntryInterner.intern((Object)new ClasspathEntry(classesFile, sourcesFile, javadocFile));
        }

        @Deprecated
        @PropertyMapping(value={"classesFile", "sourcesFile", "javadocFile"})
        public ClasspathEntry(@NotNull Set<String> classesFile, @NotNull Set<String> sourcesFile, @NotNull Set<String> javadocFile) {
            this.classesFile = classesFile;
            this.sourcesFile = sourcesFile;
            this.javadocFile = javadocFile;
        }

        @NotNull
        public Set<String> getClassesFile() {
            return this.classesFile;
        }

        @NotNull
        public Set<String> getSourcesFile() {
            return this.sourcesFile;
        }

        @NotNull
        public Set<String> getJavadocFile() {
            return this.javadocFile;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClasspathEntry)) {
                return false;
            }
            ClasspathEntry entry = (ClasspathEntry)o;
            if (!this.classesFile.equals(entry.classesFile)) {
                return false;
            }
            if (!this.javadocFile.equals(entry.javadocFile)) {
                return false;
            }
            return this.sourcesFile.equals(entry.sourcesFile);
        }

        public int hashCode() {
            int result = this.classesFile.hashCode();
            result = 31 * result + this.sourcesFile.hashCode();
            result = 31 * result + this.javadocFile.hashCode();
            return result;
        }
    }
}

